/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.path.spi.AbstractPathSPIAdapter;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.ApacheReposHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.HtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.JettyWebServerHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.MavenCentralHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.TomcatWebServerHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;
import net.thevpc.nuts.spi.NutsUseDefault;

public class HtmlfsPath
extends AbstractPathSPIAdapter {
    public static final String PROTOCOL = "htmlfs";
    public static final String PREFIX = "htmlfs:";
    public static final HtmlfsParser[] PARSERS = new HtmlfsParser[]{new MavenCentralHtmlfsParser(), new ApacheReposHtmlfsParser(), new TomcatWebServerHtmlfsParser(), new JettyWebServerHtmlfsParser()};
    private String url;

    public HtmlfsPath(String url, NutsSession session) {
        super(NutsPath.of((String)url.substring(PREFIX.length()), (NutsSession)session), session);
        if (!url.startsWith(PREFIX)) {
            throw new NutsUnsupportedArgumentException(session, NutsMessage.cstyle((String)"expected prefix '%s'", (Object[])new Object[]{PREFIX}));
        }
        this.url = url;
    }

    @Override
    public int hashCode() {
        return Objects.hash(PROTOCOL, super.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return PREFIX + this.ref.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NutsStream<NutsPath> list(NutsPath basePath) {
        try (InputStream q = this.ref.getInputStream();){
            NutsStream nutsStream = NutsStream.of(this.parseHtml(q).stream().map(x -> {
                if (x.endsWith("/")) {
                    String a = PREFIX + this.ref.resolve(x);
                    if (!a.endsWith("/")) {
                        a = a + "/";
                    }
                    return NutsPath.of((NutsPathSPI)new HtmlfsPath(a, this.session), (NutsSession)this.session);
                }
                return this.ref.resolve(x);
            }), (NutsSession)this.session);
            return nutsStream;
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    @Override
    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getProtocol(NutsPath basePath) {
        return PROTOCOL;
    }

    @Override
    public NutsPath resolve(NutsPath basePath, String path) {
        if (NutsBlankable.isBlank((String)path)) {
            return basePath;
        }
        if (!path.endsWith("/")) {
            return this.ref.resolve(path);
        }
        String a = PREFIX + this.ref.resolve(path);
        if (!a.endsWith("/")) {
            a = a + "/";
        }
        return NutsPath.of((NutsPathSPI)new HtmlfsPath(a, this.session), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        if (NutsBlankable.isBlank((Object)path)) {
            return basePath;
        }
        if (!path.toString().endsWith("/")) {
            return this.ref.resolve(path);
        }
        return NutsPath.of((String)(PREFIX + this.ref.resolve(path)), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolveSibling(NutsPath basePath, String path) {
        if (NutsBlankable.isBlank((String)path)) {
            return basePath;
        }
        if (!path.endsWith("/")) {
            return this.ref.resolve(path);
        }
        String a = PREFIX + this.ref.resolveSibling(path);
        if (!a.endsWith("/")) {
            a = a + "/";
        }
        return NutsPath.of((NutsPathSPI)new HtmlfsPath(a, this.session), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        if (NutsBlankable.isBlank((Object)path)) {
            return basePath;
        }
        if (!path.toString().endsWith("/")) {
            return this.ref.resolveSibling(path);
        }
        return NutsPath.of((String)(PREFIX + this.ref.resolveSibling(path)), (NutsSession)this.session);
    }

    @Override
    public boolean isSymbolicLink(NutsPath basePath) {
        return false;
    }

    @Override
    public boolean isOther(NutsPath basePath) {
        return false;
    }

    @Override
    public boolean isDirectory(NutsPath basePath) {
        if (NutsBlankable.isBlank((String)basePath.getLocation()) || basePath.getLocation().endsWith("/") || this.url.endsWith("/")) {
            return true;
        }
        String t = this.getContentType(basePath);
        if (t != null) {
            if (t.endsWith("text/html")) {
                return true;
            }
            return t.startsWith("text/html;");
        }
        return false;
    }

    @Override
    public boolean isRegularFile(NutsPath basePath) {
        return false;
    }

    @Override
    public boolean exists(NutsPath basePath) {
        String t = this.getContentType(basePath);
        return "text/html".equals(t);
    }

    @Override
    public NutsPath getParent(NutsPath basePath) {
        NutsPath p = this.ref.getParent();
        if (p == null) {
            return null;
        }
        return NutsPath.of((String)(PREFIX + p), (NutsSession)this.session);
    }

    @Override
    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return NutsPath.of((String)(PREFIX + basePath.toAbsolute(rootPath)), (NutsSession)this.session);
    }

    @Override
    public NutsPath normalize(NutsPath basePath) {
        return NutsPath.of((String)(PREFIX + this.ref.normalize()), (NutsSession)this.session);
    }

    @Override
    public boolean isName(NutsPath basePath) {
        return false;
    }

    @Override
    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        return NutsPath.of((String)(PREFIX + this.ref.getRoot()), (NutsSession)this.session);
    }

    @Override
    @NutsUseDefault
    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        return null;
    }

    @Override
    @NutsUseDefault
    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
    }

    public List<String> parseHtml(InputStream html) {
        List value;
        byte[] bytes = NutsCp.of((NutsSession)this.session).from(html).getByteArrayResult();
        NutsSupported best = Arrays.stream(PARSERS).map(p -> {
            try {
                return p.parseHtmlTomcat(bytes, this.session);
            }
            catch (Exception ex) {
                NutsLoggerOp.of(HtmlfsPath.class, (NutsSession)this.session).verb(NutsLogVerb.FAIL).level(Level.FINEST).error((Throwable)ex).log(NutsMessage.cstyle((String)"failed to parse using %s", (Object[])new Object[]{p.getClass().getSimpleName()}));
                return null;
            }
        }).filter(p -> NutsSupported.isValid((NutsSupported)p)).max(Comparator.comparing(NutsSupported::getSupportLevel)).orElse(null);
        if (best != null && (value = (List)best.getValue()) != null) {
            return value;
        }
        return Collections.emptyList();
    }

    public boolean isLocal(NutsPath basePath) {
        return this.ref.isLocal();
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final HtmlfsPath p;

        public MyPathFormat(HtmlfsPath p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            NutsTextBuilder sb = NutsTextBuilder.of((NutsSession)this.p.getSession());
            sb.append((Object)HtmlfsPath.PROTOCOL, NutsTextStyle.primary1());
            sb.append((Object)":", NutsTextStyle.separator());
            sb.append((Object)this.p.ref);
            return sb.build();
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }

    public static class HtmlfsFactory
    implements NutsPathFactory {
        private final NutsWorkspace ws;

        public HtmlfsFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            if (path.startsWith(HtmlfsPath.PREFIX)) {
                return NutsSupported.of((int)10, () -> new HtmlfsPath(path, session));
            }
            return null;
        }
    }
}

