/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentTypes;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeVisitResult;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.standalone.io.util.URLBuilder;
import net.thevpc.nuts.runtime.standalone.util.NutsCachedValue;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.download.DefaultHttpTransportComponent;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;
import net.thevpc.nuts.spi.NutsTransportComponent;
import net.thevpc.nuts.spi.NutsTransportConnection;

public class URLPath
implements NutsPathSPI {
    public static final Pattern MOSTLY_URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9_-]+):.*");
    private final NutsSession session;
    protected URL url;
    protected NutsCachedValue<CacheInfo> cachedHeader = new NutsCachedValue<CacheInfo>(s -> this.loadCacheInfo(), 1000L);

    public URLPath(URL url, NutsSession session) {
        this(url, session, false);
    }

    protected URLPath(URL url, NutsSession session, boolean acceptNull) {
        this.session = session;
        if (url == null && !acceptNull) {
            throw new IllegalArgumentException("invalid url");
        }
        this.url = url;
    }

    public static String getURLParentPath(String ppath) {
        if (ppath == null) {
            return null;
        }
        while (ppath.endsWith("/")) {
            ppath = ppath.substring(0, ppath.length() - 1);
        }
        if (ppath.isEmpty()) {
            return null;
        }
        int i = ppath.lastIndexOf(47);
        ppath = i <= 0 ? "/" : ppath.substring(0, i + 1);
        return ppath;
    }

    public static String getURLName(String path) {
        int index = path.lastIndexOf(47);
        String name = index < 0 ? path : path.substring(index + 1);
        index = name.indexOf(63);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        name = name.trim();
        return name;
    }

    private static File _toFile(URL url) {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLPath urlPath = (URLPath)o;
        return Objects.equals(this.url, urlPath.url);
    }

    public String toString() {
        return this.url == null ? "broken-url" : this.url.toString();
    }

    public NutsStream<NutsPath> list(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.list();
        }
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    public String getName(NutsPath basePath) {
        String loc = this.getLocation(basePath);
        return loc == null ? "" : Paths.get(loc, new String[0]).getFileName().toString();
    }

    public String getProtocol(NutsPath basePath) {
        return this.url == null ? null : this.url.getProtocol();
    }

    public NutsPath resolve(NutsPath basePath, String path) {
        String u = this.url.getFile();
        if (!u.endsWith("/") && !path.startsWith("/")) {
            u = u + "/";
        }
        u = u + path;
        return this.rebuildURLPath(this.rebuildURLString(this.url.getProtocol(), this.url.getAuthority(), u, this.url.getRef()));
    }

    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        String spath = path.toString().replace("\\", "/");
        String u = this.url.getFile();
        if (!u.endsWith("/") && !spath.startsWith("/")) {
            u = u + "/";
        }
        u = u + spath;
        return this.rebuildURLPath(this.rebuildURLString(this.url.getProtocol(), this.url.getAuthority(), u, this.url.getRef()));
    }

    public NutsPath resolveSibling(NutsPath basePath, String path) {
        String u = this._parent(this.url.getFile());
        String spath = path.replace("\\", "/");
        if (u == null || u.isEmpty()) {
            u = spath;
        } else {
            if (!u.endsWith("/") && !spath.startsWith("/")) {
                u = u + "/";
            }
            u = u + spath;
        }
        return this.rebuildURLPath(this.rebuildURLString(this.url.getProtocol(), this.url.getAuthority(), u, this.url.getRef()));
    }

    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return this.resolveSibling(basePath, path.toString());
    }

    public NutsPath toCompressedForm(NutsPath basePath) {
        return null;
    }

    public URL toURL(NutsPath basePath) {
        if (this.url == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve url %s", (Object[])new Object[]{this.toString()}));
        }
        return this.url;
    }

    public Path toFile(NutsPath basePath) {
        File f = URLPath._toFile(this.toURL(basePath));
        if (f != null) {
            return f.toPath();
        }
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve file %s", (Object[])new Object[]{this.toString()}));
    }

    public boolean isSymbolicLink(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null && f.isSymbolicLink();
    }

    public boolean isOther(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null && f.isOther();
    }

    public boolean isDirectory(NutsPath basePath) {
        if (this.url.toString().endsWith("/")) {
            return this.exists(basePath);
        }
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.isDirectory();
        }
        return false;
    }

    public boolean isLocal(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null && f.isLocal();
    }

    public boolean isRegularFile(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.isRegularFile();
        }
        if (!this.url.toString().endsWith("/")) {
            return this.exists(basePath);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(NutsPath basePath) {
        if (this.url == null) {
            return false;
        }
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.exists();
        }
        try {
            CacheInfo a = this.cachedHeader.getValue(this.session);
            if (a != null) {
                int r = a.responseCode;
                if (r < 200) return false;
                if (r >= 300) return false;
                return true;
            }
        }
        catch (Exception a) {
            // empty catch block
        }
        try (InputStream is = this.url.openStream();){
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public long getContentLength(NutsPath basePath) {
        if (this.url == null) {
            return -1L;
        }
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getContentLength();
        }
        try {
            CacheInfo a = this.cachedHeader.getValue(this.session);
            if (a != null) {
                return a.contentLength;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public String getContentEncoding(NutsPath basePath) {
        try {
            CacheInfo a = this.cachedHeader.getValue(this.session);
            if (a != null) {
                return a.contentEncoding;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getContentType(NutsPath basePath) {
        if (this.url == null) {
            return null;
        }
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getContentType();
        }
        try {
            CacheInfo a = this.cachedHeader.getValue(this.session);
            if (a != null) {
                return a.contentType;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NutsContentTypes.of((NutsSession)this.session).probeContentType(basePath);
    }

    public String getLocation(NutsPath basePath) {
        return this.url == null ? null : this.url.getFile();
    }

    public InputStream getInputStream(NutsPath basePath) {
        if (this.url == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve input stream %s", (Object[])new Object[]{this.toString()}));
        }
        NutsTransportComponent best = (NutsTransportComponent)this.session.extensions().createSupported(NutsTransportComponent.class, false, (Object)this.url);
        if (best == null) {
            best = DefaultHttpTransportComponent.INSTANCE;
        }
        NutsTransportConnection uu = best.open(this.url.toString());
        return InputStreamMetadataAwareImpl.of(uu.open(), basePath.getStreamMetadata());
    }

    public OutputStream getOutputStream(NutsPath basePath) {
        try {
            if (this.url == null) {
                throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve output stream %s", (Object[])new Object[]{this.toString()}));
            }
            return this.url.openConnection().getOutputStream();
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(NutsPath basePath, boolean recurse) {
        NutsPath f;
        if (this.url != null && (f = this.asFilePath(basePath)) != null) {
            f.delete(recurse);
            return;
        }
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete %s", (Object[])new Object[]{this.toString()}));
    }

    public void mkdir(boolean parents, NutsPath basePath) {
        NutsPath f;
        if (this.url != null && (f = this.asFilePath(basePath)) != null) {
            f.mkdir(parents);
            return;
        }
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to mkdir %s", (Object[])new Object[]{this.toString()}));
    }

    public Instant getLastModifiedInstant(NutsPath basePath) {
        if (this.url == null) {
            return null;
        }
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getLastModifiedInstant();
        }
        try {
            CacheInfo a = this.cachedHeader.getValue(this.session);
            if (a != null) {
                return a.lastModified;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Instant getLastAccessInstant(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null ? f.getLastAccessInstant() : null;
    }

    public Instant getCreationInstant(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null ? f.getCreationInstant() : null;
    }

    public NutsPath getParent(NutsPath basePath) {
        if (this.url == null) {
            return null;
        }
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getParent();
        }
        try {
            String ppath = URLPath.getURLParentPath(this.url.getPath());
            if (ppath == null) {
                return null;
            }
            URL url = new URL(URLBuilder.buildURLString(this.url.getProtocol(), this.url.getAuthority(), ppath, this.url.getQuery(), this.url.getRef()));
            return NutsPath.of((URL)url, (NutsSession)this.getSession());
        }
        catch (IOException e) {
            return null;
        }
    }

    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        return basePath;
    }

    public NutsPath normalize(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.normalize();
        }
        return basePath;
    }

    public boolean isAbsolute(NutsPath basePath) {
        return true;
    }

    public String owner(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null ? f.owner() : null;
    }

    public String group(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null ? f.group() : null;
    }

    public Set<NutsPathPermission> getPermissions(NutsPath basePath) {
        NutsPath f = this.asFilePath(basePath);
        return f != null ? f.getPermissions() : Collections.emptySet();
    }

    public void setPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            f.setPermissions(permissions);
        }
    }

    public void addPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            f.addPermissions(permissions);
        }
    }

    public void removePermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            f.removePermissions(permissions);
        }
    }

    public boolean isName(NutsPath basePath) {
        return false;
    }

    public int getPathCount(NutsPath basePath) {
        String location = this.getLocation(basePath);
        if (NutsBlankable.isBlank((String)location)) {
            return 0;
        }
        return NutsPath.of((String)location, (NutsSession)this.getSession()).getPathCount();
    }

    public boolean isRoot(NutsPath basePath) {
        String loc = this.getLocation(basePath);
        if (NutsBlankable.isBlank((String)loc)) {
            return false;
        }
        switch (loc) {
            case "/": 
            case "\\\\": {
                return true;
            }
        }
        return NutsPath.of((String)loc, (NutsSession)this.getSession()).isRoot();
    }

    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        return basePath.getParent().getRoot();
    }

    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        NutsPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.walk(maxDepth, options);
        }
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsPath subpath(NutsPath basePath, int beginIndex, int endIndex) {
        return this.rebuildURLPath(NutsPath.of((String)this.getLocation(basePath), (NutsSession)this.getSession()).subpath(beginIndex, endIndex).toString());
    }

    public String[] getItems(NutsPath basePath) {
        return NutsPath.of((String)this.getLocation(basePath), (NutsSession)this.getSession()).getItems();
    }

    public void moveTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"unable to move %s", (Object[])new Object[]{this}));
    }

    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        NutsCp.of((NutsSession)this.session).from(basePath).to(other).run();
    }

    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        for (NutsPath x : this.walk(basePath, maxDepth, options)) {
            NutsTreeVisitResult r;
            if (x.isDirectory()) {
                r = visitor.preVisitDirectory((Object)x, this.session);
                switch (r) {
                    case CONTINUE: {
                        break;
                    }
                    case TERMINATE: {
                        return;
                    }
                    case SKIP_SIBLINGS: 
                    case SKIP_SUBTREE: {
                        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{r}));
                    }
                }
                continue;
            }
            if (!x.isRegularFile()) continue;
            r = visitor.visitFile((Object)x, this.session);
            switch (r) {
                case CONTINUE: {
                    break;
                }
                case TERMINATE: {
                    return;
                }
                case SKIP_SIBLINGS: 
                case SKIP_SUBTREE: {
                    throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{r}));
                }
            }
        }
    }

    public NutsPath toRelativePath(NutsPath basePath, NutsPath parentPath) {
        String parent;
        String child = basePath.getLocation();
        if (child.startsWith(parent = parentPath.getLocation())) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            return NutsPath.of((String)child, (NutsSession)this.session);
        }
        return null;
    }

    private CacheInfo loadCacheInfo() {
        try {
            URLConnection uu = this.url.openConnection();
            uu.setDoOutput(false);
            CacheInfo cc = new CacheInfo();
            if (uu instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)uu;
                hc.setRequestMethod("HEAD");
                cc.responseCode = hc.getResponseCode();
            } else {
                cc.responseCode = 200;
            }
            cc.contentLength = uu.getContentLengthLong();
            cc.contentEncoding = uu.getContentEncoding();
            cc.contentType = uu.getContentType();
            long z = uu.getLastModified();
            if (z > 0L) {
                cc.lastModified = Instant.ofEpochMilli(z);
            }
            return cc;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String _parent(String p) {
        while (p.endsWith("/") || p.endsWith("\\")) {
            p = p.substring(0, p.length() - 1);
        }
        if (p.isEmpty()) {
            return null;
        }
        int x = p.lastIndexOf(47);
        int y = p.lastIndexOf(92);
        if (x < 0) {
            x = y;
        } else if (y >= 0 && y > x) {
            x = y;
        }
        if (x < 0) {
            return "";
        }
        return p.substring(0, x);
    }

    protected NutsPath rebuildURLPath(String other) {
        return NutsPath.of((String)other, (NutsSession)this.getSession());
    }

    protected String rebuildURLString(String protocol, String authority, String file, String ref) {
        int len = protocol.length() + 1;
        if (authority != null && authority.length() > 0) {
            len += 2 + authority.length();
        }
        if (file != null) {
            len += file.length();
        }
        if (ref != null) {
            len += 1 + ref.length();
        }
        StringBuilder result = new StringBuilder(len);
        result.append(protocol);
        result.append(":");
        if (authority != null && authority.length() > 0) {
            result.append("//");
            result.append(authority);
        }
        if (file != null) {
            result.append(file);
        }
        if (ref != null) {
            result.append("#");
            result.append(ref);
        }
        return result.toString();
    }

    public NutsPath asFilePath(NutsPath basePath) {
        File f = URLPath._toFile(this.toURL(basePath));
        return f != null ? NutsPath.of((File)f, (NutsSession)this.getSession()) : null;
    }

    public static class URLPathFactory
    implements NutsPathFactory {
        NutsWorkspace ws;

        public URLPathFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            try {
                char s;
                if (path != null && path.length() > 0 && Character.isAlphabetic(s = path.charAt(0))) {
                    URL url = new URL(path);
                    return NutsSupported.of((int)5, () -> new URLPath(url, session));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final URLPath p;

        public MyPathFormat(URLPath p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            if (this.p.url == null) {
                return NutsTexts.of((NutsSession)this.p.getSession()).ofPlain("");
            }
            return NutsTexts.of((NutsSession)this.p.getSession()).toText((Object)this.p.url);
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }

    private static class CacheInfo {
        long contentLength;
        String contentEncoding;
        String contentType;
        int responseCode;
        Instant lastModified;

        private CacheInfo() {
        }
    }
}

