/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNutsClassLoader;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;

public class NutsResourcePath
implements NutsPathSPI {
    private String path;
    private final List<NutsId> ids;
    private String location;
    private boolean urlPathLookedUp = false;
    private URL[] urls = null;
    private NutsPath urlPath = null;
    private NutsSession session;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NutsResourcePath(String path, NutsSession session) {
        String idsStr;
        int x2;
        this.path = path;
        this.session = session;
        if (path.startsWith("nuts-resource://(")) {
            x2 = path.indexOf(41);
            if (x2 <= 0) throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{path}));
            idsStr = path.substring("nuts-resource://(".length(), x2);
            this.location = path.substring(x2 + 1);
        } else {
            if (!path.startsWith("nuts-resource://")) throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{path}));
            x2 = path.indexOf(47, "nuts-resource://".length());
            if (x2 <= 0) throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{path}));
            idsStr = path.substring("nuts-resource://".length(), x2);
            this.location = path.substring(x2);
        }
        NutsIdParser nutsIdParser = NutsIdParser.of((NutsSession)session);
        this.ids = Arrays.stream(idsStr.split(";")).map(x -> {
            if ((x = x.trim()).length() > 0) {
                return nutsIdParser.parse(x);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected String rebuildURL(String location, NutsId[] ids) {
        StringBuilder sb = new StringBuilder("nuts-resource://");
        boolean complex = Arrays.stream(ids).map(Object::toString).anyMatch(x -> x.contains(";") || x.contains("/"));
        if (complex) {
            sb.append("(");
            sb.append(Arrays.stream(ids).map(Object::toString).collect(Collectors.joining(";")));
            sb.append(")");
        } else {
            sb.append(Arrays.stream(ids).map(Object::toString).collect(Collectors.joining(";")));
        }
        if (!location.startsWith("/")) {
            sb.append("/");
        }
        sb.append(location);
        return sb.toString();
    }

    public NutsPath toURLPath() {
        if (!this.urlPathLookedUp) {
            this.urlPathLookedUp = true;
            try {
                URL resource;
                String loc = this.location;
                ClassLoader resultClassLoader = this.getSession().search().addIds(this.ids.toArray(new NutsId[0])).setLatest(true).setContent(true).setDependencies(true).setDependencyFilter(NutsDependencyFilters.of((NutsSession)this.getSession()).byRunnable()).setOptional(Boolean.valueOf(false)).getResultClassLoader();
                this.urls = ((DefaultNutsClassLoader)resultClassLoader).getURLs();
                if (loc.length() > 1 && loc.startsWith("/")) {
                    loc = loc.substring(1);
                }
                if ((resource = resultClassLoader.getResource(loc)) != null) {
                    this.urlPath = NutsPath.of((URL)resource, (NutsSession)this.getSession());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.urlPath;
    }

    public NutsPath normalize(NutsPath basePath) {
        return basePath;
    }

    public NutsStream<NutsPath> list(NutsPath basePath) {
        return this.toURLPath().list();
    }

    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        return this.toURLPath().walk(maxDepth, options);
    }

    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        this.toURLPath().walkDfs(visitor, maxDepth, options);
    }

    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    public String getName(NutsPath basePath) {
        String loc = this.getLocation(basePath);
        return loc == null ? "" : Paths.get(loc, new String[0]).getFileName().toString();
    }

    public String getProtocol(NutsPath basePath) {
        return "nuts-resource";
    }

    public NutsPath resolve(NutsPath basePath, String path) {
        return NutsPath.of((NutsPathSPI)new NutsResourcePath(this.rebuildURL(NutsPath.of((String)this.location, (NutsSession)this.session).resolve(path).toString(), this.ids.toArray(new NutsId[0])), this.getSession()), (NutsSession)this.session);
    }

    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        return NutsPath.of((NutsPathSPI)new NutsResourcePath(this.rebuildURL(NutsPath.of((String)this.location, (NutsSession)this.session).resolve(path).toString(), this.ids.toArray(new NutsId[0])), this.getSession()), (NutsSession)this.session);
    }

    public NutsPath resolveSibling(NutsPath basePath, String path) {
        return NutsPath.of((NutsPathSPI)new NutsResourcePath(this.rebuildURL(NutsPath.of((String)this.location, (NutsSession)this.session).resolveSibling(path).toString(), this.ids.toArray(new NutsId[0])), this.getSession()), (NutsSession)this.session);
    }

    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return NutsPath.of((NutsPathSPI)new NutsResourcePath(this.rebuildURL(NutsPath.of((String)this.location, (NutsSession)this.session).resolveSibling(path).toString(), this.ids.toArray(new NutsId[0])), this.getSession()), (NutsSession)this.session);
    }

    public NutsPath subpath(NutsPath basePath, int beginIndex, int endIndex) {
        return NutsPath.of((NutsPathSPI)new NutsResourcePath(this.rebuildURL(NutsPath.of((String)this.location, (NutsSession)this.getSession()).subpath(beginIndex, endIndex).toString(), this.ids.toArray(new NutsId[0])), this.getSession()), (NutsSession)this.session);
    }

    public String[] getItems(NutsPath basePath) {
        return NutsPath.of((String)this.location, (NutsSession)this.getSession()).getItems();
    }

    public URL toURL(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up != null) {
            return up.toURL();
        }
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve url from %s", (Object[])new Object[]{this.toString()}));
    }

    public Path toFile(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up != null) {
            return up.toFile();
        }
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve file from %s", (Object[])new Object[]{this.toString()}));
    }

    public boolean isDirectory(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null && up.isDirectory();
    }

    public boolean isRegularFile(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null && up.isRegularFile();
    }

    public boolean isSymbolicLink(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null && up.isSymbolicLink();
    }

    public boolean isOther(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null && up.isOther();
    }

    public Instant getLastAccessInstant(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null ? up.getLastAccessInstant() : null;
    }

    public Instant getCreationInstant(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null ? up.getCreationInstant() : null;
    }

    public String owner(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null ? up.owner() : null;
    }

    public String group(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null ? up.group() : null;
    }

    public Set<NutsPathPermission> getPermissions(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        return up != null ? up.getPermissions() : new LinkedHashSet();
    }

    public boolean exists(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            return false;
        }
        return up.exists();
    }

    public long getContentLength(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            return -1L;
        }
        return up.getContentLength();
    }

    public String getContentEncoding(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up != null) {
            return up.getContentEncoding();
        }
        return null;
    }

    public String getContentType(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up != null) {
            return up.getContentType();
        }
        return null;
    }

    public String getLocation(NutsPath basePath) {
        return this.location;
    }

    public NutsPath getParent(NutsPath basePath) {
        String ppath = URLPath.getURLParentPath(this.location);
        if (ppath == null) {
            return null;
        }
        return NutsPath.of((String)this.rebuildURL(ppath, this.ids.toArray(new NutsId[0])), (NutsSession)this.getSession());
    }

    public InputStream getInputStream(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve input stream %s", (Object[])new Object[]{this.toString()}));
        }
        return up.getInputStream();
    }

    public OutputStream getOutputStream(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to resolve output stream %s", (Object[])new Object[]{this.toString()}));
        }
        return up.getOutputStream();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(NutsPath basePath, boolean recurse) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete %s", (Object[])new Object[]{this.toString()}));
        }
        up.delete(recurse);
    }

    public void mkdir(boolean parents, NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to mkdir %s", (Object[])new Object[]{this.toString()}));
        }
        up.mkdir(parents);
    }

    public Instant getLastModifiedInstant(NutsPath basePath) {
        NutsPath up = this.toURLPath();
        if (up == null) {
            return null;
        }
        return up.getLastModifiedInstant();
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsResourcePath that = (NutsResourcePath)o;
        return this.urlPathLookedUp == that.urlPathLookedUp && Objects.equals(this.path, that.path) && Objects.equals(this.ids, that.ids) && Objects.equals(this.location, that.location) && Objects.equals(this.urlPath, that.urlPath);
    }

    public String toString() {
        return String.valueOf(this.path);
    }

    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        return basePath;
    }

    public boolean isAbsolute(NutsPath basePath) {
        return true;
    }

    public void setPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void addPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void removePermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public boolean isName(NutsPath basePath) {
        return false;
    }

    public int getPathCount(NutsPath basePath) {
        String location = this.getLocation(basePath);
        if (NutsBlankable.isBlank((String)location)) {
            return 0;
        }
        return NutsPath.of((String)location, (NutsSession)this.getSession()).getPathCount();
    }

    public boolean isRoot(NutsPath basePath) {
        String loc = this.getLocation(basePath);
        if (NutsBlankable.isBlank((String)loc)) {
            return false;
        }
        switch (loc) {
            case "/": 
            case "\\\\": {
                return true;
            }
        }
        return NutsPath.of((String)loc, (NutsSession)this.getSession()).isRoot();
    }

    public NutsPath toCompressedForm(NutsPath basePath) {
        return null;
    }

    public void moveTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"unable to move %s", (Object[])new Object[]{this}));
    }

    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        NutsCp.of((NutsSession)this.session).from(basePath).to(other).run();
    }

    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        return basePath.getParent().getRoot();
    }

    public boolean isLocal(NutsPath basePath) {
        return this.toURLPath().isLocal();
    }

    public NutsPath toRelativePath(NutsPath basePath, NutsPath parentPath) {
        String parent;
        String child = basePath.getLocation();
        if (child.startsWith(parent = parentPath.getLocation())) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            return NutsPath.of((String)child, (NutsSession)this.session);
        }
        return null;
    }

    public static class NutsResourceFactory
    implements NutsPathFactory {
        NutsWorkspace ws;

        public NutsResourceFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            try {
                if (path.startsWith("nuts-resource:")) {
                    return NutsSupported.of((int)10, () -> new NutsResourcePath(path, session));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private NutsResourcePath p;

        public MyPathFormat(NutsResourcePath p) {
            this.p = p;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public NutsString asFormattedString() {
            String path = this.p.path;
            NutsTexts text = NutsTexts.of((NutsSession)this.p.getSession());
            NutsTextBuilder tb = text.builder();
            tb.append((Object)"nuts-resource://", NutsTextStyle.primary1());
            if (path.startsWith("nuts-resource://(")) {
                tb.append((Object)"(", NutsTextStyle.separator());
                int x = path.indexOf(41);
                if (x <= 0) return text.toText((Object)path);
                String idsStr = path.substring("nuts-resource://(".length(), x);
                NutsIdParser nutsIdParser = NutsIdParser.of((NutsSession)this.p.getSession());
                tb.appendJoined((Object)NutsTexts.of((NutsSession)this.p.getSession()).ofStyled(";", NutsTextStyle.separator()), (Collection)Arrays.stream(idsStr.split(";")).map(xi -> {
                    if ((xi = xi.trim()).length() > 0) {
                        NutsId pp = nutsIdParser.parse(xi);
                        if (pp == null) {
                            return xi;
                        }
                        return pp;
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList()));
                tb.append((Object)")", NutsTextStyle.separator());
                tb.append((Object)path.substring(x + 1), NutsTextStyle.path());
                return tb.toText();
            } else {
                if (!path.startsWith("nuts-resource://")) return text.toText((Object)path);
                int x = path.indexOf(47, "nuts-resource://".length());
                if (x <= 0) return text.toText((Object)path);
                String sid = path.substring("nuts-resource://".length(), x);
                NutsId ii = NutsId.of((String)sid, (NutsSession)this.p.getSession());
                if (ii == null) {
                    tb.append((Object)sid);
                } else {
                    tb.append((Object)ii);
                }
                tb.append((Object)path.substring(x), NutsTextStyle.path());
            }
            return tb.toText();
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

