/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.util.Iterator;
import java.util.Stack;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsTreeVisitResult;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.runtime.standalone.util.iter.NutsIteratorBase;

public class NutsPathSPIHelper {
    public static NutsStream<NutsPath> walk(NutsSession session, NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        boolean noMax = maxDepth <= 0 || maxDepth == Integer.MAX_VALUE;
        NutsPathIterator it = new NutsPathIterator(basePath, noMax, maxDepth);
        return NutsStream.of((Iterator)((Object)it), (NutsSession)session);
    }

    public static void walkDfs(NutsSession session, NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        boolean noMax = maxDepth <= 0 || maxDepth == Integer.MAX_VALUE;
        Stack<Data> stack = new Stack<Data>();
        stack.push(new Data(basePath, 0, true));
        while (!stack.isEmpty()) {
            Data i = (Data)stack.peek();
            if (i.folder) {
                NutsTreeVisitResult r;
                if (!i.visited) {
                    i.visited = true;
                    r = visitor.preVisitDirectory((Object)i.p, session);
                    switch (r) {
                        case TERMINATE: {
                            return;
                        }
                        case SKIP_SUBTREE: {
                            break;
                        }
                        case SKIP_SIBLINGS: 
                        case CONTINUE: {
                            if (!noMax && i.depth >= maxDepth) break;
                            for (NutsPath c : i.p.list()) {
                                stack.push(new Data(c, i.depth + 1, c.isDirectory()));
                            }
                            break;
                        }
                    }
                    continue;
                }
                stack.pop();
                r = visitor.postVisitDirectory((Object)i.p, null, session);
                switch (r) {
                    case TERMINATE: {
                        return;
                    }
                    case SKIP_SUBTREE: {
                        break;
                    }
                }
                continue;
            }
            stack.pop();
        }
    }

    private static class NutsPathIterator
    extends NutsIteratorBase<NutsPath> {
        private final boolean noMax;
        private final int maxDepth;
        private final NutsPath basePath;
        Stack<Data> stack;

        public NutsPathIterator(NutsPath basePath, boolean noMax, int maxDepth) {
            this.noMax = noMax;
            this.maxDepth = maxDepth;
            this.basePath = basePath;
            this.stack = new Stack();
            this.stack.push(new Data(basePath, 0, basePath.isDirectory()));
        }

        public NutsElement describe(NutsElements elems) {
            return elems.ofObject().set("type", "ScanPath").set("path", elems.toElement((Object)this.basePath)).set("maxDepth", this.maxDepth).build();
        }

        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        public NutsPath next() {
            Data i = this.stack.pop();
            if (i.folder && (this.noMax || i.depth < this.maxDepth)) {
                for (NutsPath c : i.p.list()) {
                    this.stack.push(new Data(c, i.depth + 1, c.isDirectory()));
                }
            }
            return i.p;
        }
    }

    private static class Data {
        NutsPath p;
        int depth;
        boolean folder;
        boolean visited;

        public Data(NutsPath p, int depth, boolean folder) {
            this.p = p;
            this.depth = depth;
            this.folder = folder;
        }
    }
}

