/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NutsPathPart;

public class NutsPathPartList
implements Iterable<NutsPathPart> {
    private List<NutsPathPart> list = new ArrayList<NutsPathPart>();
    private NutsSession session;

    public NutsPathPartList(List<NutsPathPart> list, NutsSession session) {
        this.session = session;
        for (int i = 0; i < list.size(); ++i) {
            NutsPathPart p = list.get(i);
            if (!(p.isName() ? i > 0 : p.isTrailingSeparator() && i != list.size() - 1)) continue;
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid part %s at %i", (Object[])new Object[]{p, i}));
        }
        this.list.addAll(list);
    }

    public NutsPathPartList concat(NutsPathPartList other) {
        return new NutsPathPartList(this.concat(this.list, other.list), this.session);
    }

    private List<NutsPathPart> concat(List<NutsPathPart> a, List<NutsPathPart> b) {
        a = new ArrayList<NutsPathPart>(a);
        if ((b = new ArrayList<NutsPathPart>(b)).isEmpty()) {
            return a;
        }
        if (a.isEmpty()) {
            return b;
        }
        if (!a.get(a.size() - 1).isTrailingSeparator()) {
            if (b.get(0).isSeparated()) {
                a.addAll(b);
                return a;
            }
            if (b.get(0).isName()) {
                NutsPathPart p = b.get(0);
                p = new NutsPathPart(File.separator, p.getName());
                b.set(0, p);
                a.addAll(b);
                return a;
            }
            return a;
        }
        if (a.size() == 1) {
            if (b.get(0).isSeparated()) {
                return b;
            }
            if (b.get(0).isName()) {
                NutsPathPart p = b.get(0);
                p = new NutsPathPart(a.get(0).getSeparator(), p.getName());
                b.set(0, p);
                return b;
            }
            return a;
        }
        if (b.get(0).isSeparated()) {
            a.remove(0);
            a.addAll(b);
            return a;
        }
        if (b.get(0).isName()) {
            NutsPathPart p = b.get(0);
            p = new NutsPathPart(a.get(0).getSeparator(), p.getName());
            b.set(0, p);
            a.remove(0);
            a.addAll(b);
            return a;
        }
        return a;
    }

    public int size() {
        return this.list.size();
    }

    public NutsPathPart get(int i) {
        if (i < 0) {
            return this.list.get(this.list.size() + i);
        }
        return this.list.get(i);
    }

    public NutsPathPart last() {
        return this.list.get(this.list.size() - 1);
    }

    public NutsPathPart first() {
        return this.list.get(0);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return this.list.stream().map(NutsPathPart::toString).collect(Collectors.joining());
    }

    @Override
    public Iterator<NutsPathPart> iterator() {
        return this.list.iterator();
    }

    public NutsPathPartList subList(int beginIndex, int endIndex) {
        return new NutsPathPartList(this.list.subList(beginIndex, endIndex), this.session);
    }

    public String[] toStringArray() {
        return (String[])this.stream().map(NutsPathPart::getName).toArray(String[]::new);
    }

    public Stream<NutsPathPart> stream() {
        return this.list.stream();
    }
}

