/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

public class InvalidFilePath
implements NutsPathSPI {
    private final String value;
    private final NutsSession session;

    public InvalidFilePath(String value, NutsSession session) {
        this.value = value == null ? "" : value;
        this.session = session;
    }

    public NutsStream<NutsPath> list(NutsPath basePath) {
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    public String getName(NutsPath basePath) {
        String[] pa = this.asPathArray();
        if (pa.length == 0) {
            return "";
        }
        return pa[pa.length - 1];
    }

    public String getProtocol(NutsPath basePath) {
        return "";
    }

    public NutsPath resolve(NutsPath basePath, String path) {
        String b = this.value;
        if (b.endsWith("/") || b.endsWith("\\")) {
            return NutsPath.of((String)(b + path), (NutsSession)this.session);
        }
        return NutsPath.of((String)(b + "/" + path), (NutsSession)this.session);
    }

    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        return this.resolve(basePath, path == null ? null : path.toString());
    }

    public NutsPath resolveSibling(NutsPath basePath, String path) {
        if (path == null || path.isEmpty()) {
            return this.getParent(basePath);
        }
        if (this.isRoot(basePath)) {
            return NutsPath.of((String)("/" + path), (NutsSession)this.session);
        }
        return this.getParent(basePath).resolve(path);
    }

    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return this.resolveSibling(basePath, path == null ? null : path.toString());
    }

    public NutsPath toCompressedForm(NutsPath basePath) {
        return null;
    }

    public URL toURL(NutsPath basePath) {
        try {
            if (URLPath.MOSTLY_URL_PATTERN.matcher(this.value).matches()) {
                return new URL(this.value);
            }
            return new URL("file:" + this.value);
        }
        catch (MalformedURLException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public Path toFile(NutsPath basePath) {
        try {
            return Paths.get(this.value, new String[0]);
        }
        catch (Exception ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public boolean isSymbolicLink(NutsPath basePath) {
        return false;
    }

    public boolean isOther(NutsPath basePath) {
        return false;
    }

    public boolean isDirectory(NutsPath basePath) {
        return false;
    }

    public boolean isRegularFile(NutsPath basePath) {
        return false;
    }

    public boolean exists(NutsPath basePath) {
        return false;
    }

    public long getContentLength(NutsPath basePath) {
        return -1L;
    }

    public String getContentEncoding(NutsPath basePath) {
        return null;
    }

    public String getContentType(NutsPath basePath) {
        return null;
    }

    public String getLocation(NutsPath basePath) {
        return this.value;
    }

    public InputStream getInputStream(NutsPath basePath) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"path not found %s", (Object[])new Object[]{this}));
    }

    public OutputStream getOutputStream(NutsPath basePath) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"path not found %s", (Object[])new Object[]{this}));
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(NutsPath basePath, boolean recurse) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete path %s", (Object[])new Object[]{this}));
    }

    public void mkdir(boolean parents, NutsPath basePath) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to create folder out of regular file %s", (Object[])new Object[]{this}));
    }

    public Instant getLastModifiedInstant(NutsPath basePath) {
        return null;
    }

    public Instant getLastAccessInstant(NutsPath basePath) {
        return null;
    }

    public Instant getCreationInstant(NutsPath basePath) {
        return null;
    }

    public NutsPath getParent(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.value);
        while (sb.length() > 0 && (sb.charAt(sb.length() - 1) == '/' || sb.charAt(sb.length() - 1) == '\\')) {
            sb.delete(sb.length() - 1, sb.length());
        }
        int x = this.value.lastIndexOf(47);
        int y = this.value.lastIndexOf(92);
        if (y < x && y >= 0) {
            x = y;
        }
        if (x >= 0) {
            return NutsPath.of((String)sb.substring(0, x), (NutsSession)this.getSession());
        }
        return null;
    }

    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        return basePath;
    }

    public NutsPath normalize(NutsPath basePath) {
        return basePath;
    }

    public boolean isAbsolute(NutsPath basePath) {
        return false;
    }

    public String owner(NutsPath basePath) {
        return null;
    }

    public String group(NutsPath basePath) {
        return null;
    }

    public Set<NutsPathPermission> getPermissions(NutsPath basePath) {
        LinkedHashSet p = new LinkedHashSet();
        return Collections.unmodifiableSet(p);
    }

    public void setPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void addPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void removePermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public boolean isName(NutsPath basePath) {
        String[] pa = this.asPathArray();
        if (pa.length == 0) {
            return true;
        }
        if (pa.length > 1) {
            return false;
        }
        String v = pa[0];
        switch (v) {
            case "/": 
            case "\\": 
            case ".": 
            case "..": {
                return false;
            }
        }
        for (Object c : (String)v.toCharArray()) {
            switch (c) {
                case 47: 
                case 92: {
                    return false;
                }
            }
        }
        return true;
    }

    public int getPathCount(NutsPath basePath) {
        String[] pa = this.asPathArray();
        return pa.length == 0 ? 1 : pa.length;
    }

    public boolean isRoot(NutsPath basePath) {
        return this.asPathArray().length == 0 && (this.value.contains("/") || this.value.contains("\\"));
    }

    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsPath subpath(NutsPath basePath, int beginIndex, int endIndex) {
        String[] a = this.asPathArray();
        return NutsPath.of((String)String.join((CharSequence)"/", Arrays.copyOfRange(a, beginIndex, endIndex)), (NutsSession)this.getSession());
    }

    public String[] getItems(NutsPath basePath) {
        return this.asPathArray();
    }

    private String[] normalizePath(String[] aa) {
        ArrayList<String> p = new ArrayList<String>(Arrays.asList(aa));
        block8: for (int i = p.size() - 1; i >= 0; --i) {
            switch ((String)p.get(i)) {
                case ".": {
                    p.remove(i);
                    ++i;
                    continue block8;
                }
                case "..": {
                    p.remove(i);
                    if (i <= 0) continue block8;
                    p.remove(i);
                    continue block8;
                }
            }
        }
        return p.toArray(new String[0]);
    }

    private String[] asPathArray(String s) {
        return new String[]{s};
    }

    private String[] asPathArray() {
        return this.asPathArray(this.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvalidFilePath urlPath = (InvalidFilePath)o;
        return Objects.equals(this.value, urlPath.value);
    }

    public String toString() {
        return this.value;
    }

    public void moveTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"unable to move %s", (Object[])new Object[]{this}));
    }

    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"unable to copy %s", (Object[])new Object[]{this}));
    }

    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        NutsPath r = basePath.getParent();
        if (r != null) {
            return r.getRoot();
        }
        return null;
    }

    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
    }

    public boolean isLocal(NutsPath basePath) {
        return true;
    }

    public NutsPath toRelativePath(NutsPath basePath, NutsPath parentPath) {
        String parent;
        String child = basePath.getLocation();
        if (child.startsWith(parent = parentPath.getLocation())) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            return NutsPath.of((String)child, (NutsSession)this.session);
        }
        return null;
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final InvalidFilePath p;

        public MyPathFormat(InvalidFilePath p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            return NutsTexts.of((NutsSession)this.p.getSession()).toText((Object)this.p.value);
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

