/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.path.spi.AbstractPathSPIAdapter;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;
import net.thevpc.nuts.spi.NutsUseDefault;

public class GithubfsPath
extends AbstractPathSPIAdapter {
    public static final String PROTOCOL = "githubfs";
    public static final String PREFIX = "githubfs:";
    private final Info info;
    private Object loaded;

    public GithubfsPath(String url, NutsSession session) {
        this(url, null, session);
    }

    private GithubfsPath(String url, Info info, NutsSession session) {
        super(NutsPath.of((String)url.substring(PREFIX.length()), (NutsSession)session), session);
        if (!url.startsWith(PREFIX)) {
            throw new NutsUnsupportedArgumentException(session, NutsMessage.cstyle((String)"expected prefix 'githubfs:'", (Object[])new Object[0]));
        }
        this.info = info;
    }

    @Override
    public int hashCode() {
        return Objects.hash(PROTOCOL, super.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return PREFIX + this.ref.toString();
    }

    @Override
    public NutsStream<NutsPath> list(NutsPath basePath) {
        Object q = this.load();
        if (q instanceof Info[]) {
            return NutsStream.of((Object[])((Info[])q), (NutsSession)this.session).map(NutsFunction.of(x -> NutsPath.of((NutsPathSPI)new GithubfsPath(PREFIX + this.ref.resolve(x.name).toString(), (Info)x, this.session), (NutsSession)this.session), (String)"GithubfsPath::of"));
        }
        return NutsStream.ofEmpty((NutsSession)this.session);
    }

    @Override
    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getProtocol(NutsPath basePath) {
        return PROTOCOL;
    }

    @Override
    public NutsPath resolve(NutsPath basePath, String path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolve(path)), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolve(path)), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolveSibling(NutsPath basePath, String path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolveSibling(path)), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolveSibling(path)), (NutsSession)this.session);
    }

    @Override
    public boolean isSymbolicLink(NutsPath basePath) {
        return "symlink".equals(this._type());
    }

    @Override
    public boolean isOther(NutsPath basePath) {
        switch (this._type()) {
            case "dir": 
            case "file": 
            case "symlink": 
            case "": {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDirectory(NutsPath basePath) {
        return "dir".equals(this._type());
    }

    @Override
    public boolean isRegularFile(NutsPath basePath) {
        return "file".equals(this._type());
    }

    @Override
    public boolean exists(NutsPath basePath) {
        if (this.info != null) {
            return true;
        }
        return this.load() != null;
    }

    @Override
    public long getContentLength(NutsPath basePath) {
        Info o = this._fileInfo();
        if (o != null) {
            return o.size;
        }
        return -1L;
    }

    @Override
    public String getContentEncoding(NutsPath basePath) {
        NutsPath p = this.getDownloadPath();
        return p == null ? null : p.getContentEncoding();
    }

    @Override
    public String getContentType(NutsPath basePath) {
        NutsPath p = this.getDownloadPath();
        return p == null ? null : p.getContentType();
    }

    @Override
    public InputStream getInputStream(NutsPath basePath) {
        NutsPath p = this.getDownloadPath();
        if (p != null) {
            return p.getInputStream();
        }
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"not a file %s", (Object[])new Object[]{basePath}));
    }

    @Override
    public OutputStream getOutputStream(NutsPath basePath) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"not writable %s", (Object[])new Object[]{basePath}));
    }

    @Override
    public Instant getLastModifiedInstant(NutsPath basePath) {
        NutsPath p = this.getDownloadPath();
        return p == null ? null : p.getLastModifiedInstant();
    }

    @Override
    public Instant getLastAccessInstant(NutsPath basePath) {
        NutsPath p = this.getDownloadPath();
        return p == null ? null : p.getLastAccessInstant();
    }

    @Override
    public Instant getCreationInstant(NutsPath basePath) {
        NutsPath p = this.getDownloadPath();
        return p == null ? null : p.getCreationInstant();
    }

    @Override
    public NutsPath getParent(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return null;
        }
        NutsPath p = this.ref.getParent();
        if (p == null) {
            return null;
        }
        return NutsPath.of((String)(PREFIX + p), (NutsSession)this.session);
    }

    @Override
    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return NutsPath.of((String)(PREFIX + basePath.toAbsolute(rootPath)), (NutsSession)this.session);
    }

    @Override
    public NutsPath normalize(NutsPath basePath) {
        return NutsPath.of((String)(PREFIX + this.ref.normalize()), (NutsSession)this.session);
    }

    @Override
    public boolean isName(NutsPath basePath) {
        return false;
    }

    @Override
    public boolean isRoot(NutsPath basePath) {
        Info[] infoArray;
        int n;
        int n2;
        Info f = this._fileInfo();
        if (f != null) {
            if (!"dir".equals(f.type)) {
                return false;
            }
            return "".equals(f.path);
        }
        Object a = this.load();
        if (a instanceof Info[] && (n2 = 0) < (n = (infoArray = (Info[])a).length)) {
            Info i = infoArray[n2];
            return !i.path.contains("/");
        }
        return false;
    }

    @Override
    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        return NutsPath.of((String)(PREFIX + this.ref.getRoot()), (NutsSession)this.session);
    }

    @Override
    @NutsUseDefault
    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        return null;
    }

    @Override
    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        NutsPath p = this.getDownloadPath();
        if (p != null) {
            p.copyTo(other, options);
        } else {
            NutsCp.of((NutsSession)this.session).from(basePath).to(other).run();
        }
    }

    @Override
    @NutsUseDefault
    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
    }

    private Object load() {
        if (this.loaded == null) {
            this.loaded = this.load(this.ref);
        }
        return this.loaded;
    }

    private Object load(NutsPath p) {
        NutsElements elems = NutsElements.of((NutsSession)this.session);
        NutsElement e = elems.json().parse(this.ref);
        if (e != null) {
            if (e.isArray()) {
                return NutsStream.of((Object[])((Object[])elems.convert((Object)e, Info[].class)), (NutsSession)this.session).toArray(Info[]::new);
            }
            if (e.isObject()) {
                return elems.convert((Object)e, Info.class);
            }
        }
        return null;
    }

    private Info _fileInfo() {
        if (this.info != null) {
            return this.info;
        }
        Object o = this.load();
        if (o instanceof Info) {
            return (Info)o;
        }
        return null;
    }

    private String _type() {
        if (this.info != null) {
            return NutsUtilStrings.trim((String)this.info.type);
        }
        Object a = this.load();
        if (a != null) {
            if (a instanceof Info) {
                return NutsUtilStrings.trim((String)((Info)a).type);
            }
            if (a instanceof Info[]) {
                return "dir";
            }
        }
        return "";
    }

    private NutsPath getDownloadPath() {
        Info i = this._fileInfo();
        if (i != null && this._type().equals("file")) {
            return NutsPath.of((String)i.download_url, (NutsSession)this.session);
        }
        return null;
    }

    public boolean isLocal(NutsPath basePath) {
        return this.ref.isLocal();
    }

    private static class Info {
        String name;
        String path;
        String target;
        String sha;
        long size;
        String url;
        String html_url;
        String git_url;
        String download_url;
        String type;
        String content;
        String encoding;
        Map<String, String> self;

        private Info() {
        }
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final GithubfsPath p;

        public MyPathFormat(GithubfsPath p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            NutsTextBuilder sb = NutsTextBuilder.of((NutsSession)this.p.getSession());
            sb.append((Object)GithubfsPath.PROTOCOL, NutsTextStyle.primary1());
            sb.append((Object)":", NutsTextStyle.separator());
            sb.append((Object)this.p.ref);
            return sb.build();
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }

    public static class GithubfsFactory
    implements NutsPathFactory {
        private final NutsWorkspace ws;

        public GithubfsFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            if (path.startsWith(GithubfsPath.PREFIX)) {
                return NutsSupported.of((int)10, () -> new GithubfsPath(path, session));
            }
            return null;
        }
    }
}

