/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NutsPathPart;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NutsPathPartList;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NutsPathPartParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;

public class GenericFilePath
implements NutsPathSPI {
    private final String value;
    private final NutsPathPartList parts;
    private final NutsSession session;

    public GenericFilePath(String value, NutsSession session) {
        this.value = value == null ? "" : value;
        this.parts = NutsPathPartParser.parseParts(this.value, session);
        this.session = session;
    }

    public NutsStream<NutsPath> list(NutsPath basePath) {
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    public String getName(NutsPath basePath) {
        if (this.parts.isEmpty()) {
            return "";
        }
        if (this.parts.size() == 1) {
            return this.parts.first().getName();
        }
        if (this.parts.last().isTrailingSeparator()) {
            return this.parts.get(-2).getName();
        }
        return this.parts.last().getName();
    }

    public String getProtocol(NutsPath basePath) {
        return "";
    }

    public NutsPath resolve(NutsPath basePath, String path) {
        NutsPathPartList newParts = NutsPathPartParser.parseParts(path, this.session);
        if (newParts.isEmpty()) {
            return basePath;
        }
        if (this.parts.isEmpty() || newParts.get(0).getSeparator().length() > 0) {
            return NutsPath.of((String)path, (NutsSession)this.session);
        }
        return this.partsToPath(this.parts.concat(newParts));
    }

    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        return this.resolve(basePath, path == null ? null : path.toString());
    }

    public NutsPath resolveSibling(NutsPath basePath, String path) {
        if (path == null || path.isEmpty()) {
            return this.getParent(basePath);
        }
        if (this.isRoot(basePath)) {
            ArrayList<NutsPathPart> a = new ArrayList<NutsPathPart>();
            if (this.parts.size() > 0) {
                a.add(new NutsPathPart(this.parts.get(0).getSeparator(), ""));
            } else {
                a.add(new NutsPathPart(File.separator, ""));
            }
            return this.partsToPath(new NutsPathPartList(a, this.session).concat(NutsPathPartParser.parseParts(path, this.session)));
        }
        return this.getParent(basePath).resolve(path);
    }

    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return this.resolveSibling(basePath, path == null ? null : path.toString());
    }

    public NutsPath toCompressedForm(NutsPath basePath) {
        return null;
    }

    public URL toURL(NutsPath basePath) {
        try {
            if (URLPath.MOSTLY_URL_PATTERN.matcher(this.value).matches()) {
                return new URL(this.value);
            }
            return new URL("file:" + this.value);
        }
        catch (MalformedURLException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public Path toFile(NutsPath basePath) {
        try {
            return Paths.get(this.value, new String[0]);
        }
        catch (Exception ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }

    public boolean isSymbolicLink(NutsPath basePath) {
        return false;
    }

    public boolean isOther(NutsPath basePath) {
        return false;
    }

    public boolean isDirectory(NutsPath basePath) {
        return false;
    }

    public boolean isRegularFile(NutsPath basePath) {
        return false;
    }

    public boolean exists(NutsPath basePath) {
        return false;
    }

    public long getContentLength(NutsPath basePath) {
        return -1L;
    }

    public String getContentEncoding(NutsPath basePath) {
        return null;
    }

    public String getContentType(NutsPath basePath) {
        return null;
    }

    public String getLocation(NutsPath basePath) {
        return this.value;
    }

    public InputStream getInputStream(NutsPath basePath) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"path not found %s", (Object[])new Object[]{this}));
    }

    public OutputStream getOutputStream(NutsPath basePath) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"path not found %s", (Object[])new Object[]{this}));
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(NutsPath basePath, boolean recurse) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete path %s", (Object[])new Object[]{this}));
    }

    public void mkdir(boolean parents, NutsPath basePath) {
        throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to create folder out of regular file %s", (Object[])new Object[]{this}));
    }

    public Instant getLastModifiedInstant(NutsPath basePath) {
        return null;
    }

    public Instant getLastAccessInstant(NutsPath basePath) {
        return null;
    }

    public Instant getCreationInstant(NutsPath basePath) {
        return null;
    }

    public NutsPath getParent(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return null;
        }
        if (this.parts.isEmpty()) {
            return null;
        }
        if (this.parts.size() == 1) {
            NutsPathPart p = this.parts.get(0);
            if (p.isTrailingSeparator()) {
                return null;
            }
            if (p.isName()) {
                return null;
            }
            return this.partsToPath(new NutsPathPartList(Arrays.asList(new NutsPathPart(p.getSeparator(), "")), this.session));
        }
        if (this.parts.get(this.parts.size() - 1).isTrailingSeparator()) {
            return this.partsToPath(this.parts.subList(0, this.parts.size() - 2));
        }
        return this.partsToPath(this.parts.subList(0, this.parts.size() - 1));
    }

    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        if (rootPath == null) {
            return this.partsToPath(NutsPathPartParser.parseParts(System.getProperty("user.dir"), this.session).concat(this.parts));
        }
        return rootPath.toAbsolute().resolve(this.toString());
    }

    public NutsPath normalize(NutsPath basePath) {
        ArrayList<NutsPathPart> p2 = new ArrayList<NutsPathPart>();
        for (NutsPathPart part : this.parts) {
            NutsPathPart p = part;
            if (p.isSeparated() && !p.getSeparator().equals(File.separator)) {
                p = new NutsPathPart(File.separator, p.getName());
            }
            if (p.isTrailingSeparator() && p2.size() > 0) continue;
            if (p.getName().equals(".")) {
                if (p2.size() > 0 || p.getSeparator().isEmpty()) continue;
                p = new NutsPathPart(p.getSeparator(), "");
                p2.add(p);
                continue;
            }
            if (p.getName().equals("..")) {
                if (p2.size() == 0) {
                    if (p.getSeparator().isEmpty()) {
                        p2.add(p);
                    } else {
                        p = new NutsPathPart(p.getSeparator(), "");
                        p2.add(p);
                    }
                }
                if (p2.size() == 1) {
                    NutsPathPart r = (NutsPathPart)p2.get(0);
                    if (r.isTrailingSeparator()) continue;
                    p = new NutsPathPart(p.getSeparator(), "");
                    p2.add(p);
                    continue;
                }
                p2.remove(p2.size() - 1);
                continue;
            }
            p2.add(p);
        }
        return this.partsToPath(new NutsPathPartList(p2, this.session));
    }

    private NutsPath partsToPath(NutsPathPartList p2) {
        return NutsPath.of((String)p2.toString(), (NutsSession)this.session);
    }

    public boolean isAbsolute(NutsPath basePath) {
        if (this.parts.size() != 0) {
            char c;
            String n;
            NutsPathPart f = this.parts.first();
            if (f.getSeparator().length() > 0) {
                return true;
            }
            if (this.session.env().getOsFamily() == NutsOsFamily.WINDOWS && (n = f.getName()).length() == 2 && n.charAt(1) == ':' && ((c = n.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                return true;
            }
        }
        return false;
    }

    public String owner(NutsPath basePath) {
        return null;
    }

    public String group(NutsPath basePath) {
        return null;
    }

    public Set<NutsPathPermission> getPermissions(NutsPath basePath) {
        LinkedHashSet p = new LinkedHashSet();
        return Collections.unmodifiableSet(p);
    }

    public void setPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void addPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public void removePermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public boolean isName(NutsPath basePath) {
        if (this.parts.size() == 0) {
            return true;
        }
        if (this.parts.size() > 1) {
            return false;
        }
        NutsPathPart v = this.parts.get(0);
        if (!v.getSeparator().isEmpty()) {
            return false;
        }
        switch (v.getName()) {
            case "/": 
            case "\\": 
            case ".": 
            case "..": {
                return false;
            }
        }
        return true;
    }

    public int getPathCount(NutsPath basePath) {
        if (this.parts.isEmpty()) {
            return 1;
        }
        if (this.parts.size() == 1 && this.parts.get(0).isTrailingSeparator()) {
            return 1;
        }
        if (this.parts.get(this.parts.size() - 1).isTrailingSeparator()) {
            return this.parts.size() - 1;
        }
        return this.parts.size();
    }

    public boolean isRoot(NutsPath basePath) {
        if (this.parts.isEmpty()) {
            return true;
        }
        return this.parts.size() == 1 && this.parts.get(0).isTrailingSeparator();
    }

    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsPath subpath(NutsPath basePath, int beginIndex, int endIndex) {
        NutsPathPartList parts = this.parts.subList(beginIndex, endIndex);
        return this.partsToPath(parts);
    }

    public String[] getItems(NutsPath basePath) {
        NutsPathPartList parts = this.parts;
        if (parts.isEmpty()) {
            return new String[0];
        }
        if (parts.size() == 1 && parts.get(0).isTrailingSeparator()) {
            return new String[]{""};
        }
        if (parts.get(parts.size() - 1).isTrailingSeparator()) {
            return parts.subList(0, parts.size() - 1).toStringArray();
        }
        return parts.subList(0, parts.size()).toStringArray();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericFilePath urlPath = (GenericFilePath)o;
        return Objects.equals(this.value, urlPath.value);
    }

    public String toString() {
        return this.value;
    }

    public void moveTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"unable to move %s", (Object[])new Object[]{this}));
    }

    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        throw new NutsIOException(this.session, NutsMessage.cstyle((String)"unable to copy %s", (Object[])new Object[]{this}));
    }

    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        NutsPath r = basePath.getParent();
        if (r != null) {
            return r.getRoot();
        }
        return null;
    }

    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
    }

    public boolean isLocal(NutsPath basePath) {
        return true;
    }

    public NutsPath toRelativePath(NutsPath basePath, NutsPath parentPath) {
        String parent;
        String child = basePath.getLocation();
        if (child.startsWith(parent = parentPath.getLocation())) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            return NutsPath.of((String)child, (NutsSession)this.session);
        }
        return null;
    }

    public static class GenericPathFactory
    implements NutsPathFactory {
        NutsWorkspace ws;

        public GenericPathFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            if (path != null && path.trim().length() > 0) {
                for (char c : path.toCharArray()) {
                    if (c >= ' ') continue;
                    return null;
                }
                return NutsSupported.of((int)1, () -> new GenericFilePath(path, session));
            }
            return null;
        }
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final GenericFilePath p;

        public MyPathFormat(GenericFilePath p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            return NutsTexts.of((NutsSession)this.p.getSession()).toText((Object)this.p.value);
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

