/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentTypes;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeVisitResult;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;

public class FilePath
implements NutsPathSPI {
    private final Path value;
    private final NutsSession session;

    public FilePath(Path value, NutsSession session) {
        if (value == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"invalid null value"));
        }
        this.value = value;
        this.session = session;
    }

    private NutsPath fastPath(Path p, NutsSession s) {
        return NutsPath.of((NutsPathSPI)new FilePath(p, s), (NutsSession)s);
    }

    public NutsStream<NutsPath> list(NutsPath basePath) {
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            try {
                return NutsStream.of(Files.list(this.value).map(x -> this.fastPath((Path)x, this.getSession())), (NutsSession)this.getSession());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    public String getName(NutsPath basePath) {
        Path a = this.value.getFileName();
        return a == null ? null : a.toString();
    }

    public String getProtocol(NutsPath basePath) {
        return "";
    }

    public NutsPath resolve(NutsPath basePath, String path) {
        if (NutsBlankable.isBlank((String)path)) {
            return this.fastPath(this.value, this.getSession());
        }
        try {
            return this.fastPath(this.value.resolve(path), this.getSession());
        }
        catch (Exception ex) {
            return NutsPath.of((String)(this.value + this.getSep() + path), (NutsSession)this.getSession());
        }
    }

    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        if (path == null) {
            return this.fastPath(this.value, this.getSession());
        }
        if (path.toString().isEmpty()) {
            return this.fastPath(this.value, this.getSession());
        }
        Path f = path.asFile();
        if (f != null) {
            return this.fastPath(this.value.resolve(f), this.getSession());
        }
        return this.resolve(basePath, path.toString());
    }

    public NutsPath resolveSibling(NutsPath basePath, String path) {
        if (path == null) {
            return this.getParent(basePath);
        }
        if (path.isEmpty()) {
            return this.getParent(basePath);
        }
        try {
            return this.fastPath(this.value.resolveSibling(path), this.getSession());
        }
        catch (Exception e) {
            Path p = this.value.getParent();
            if (p == null) {
                return NutsPath.of((String)path, (NutsSession)this.session);
            }
            return this.fastPath(p, this.session).resolve(path);
        }
    }

    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        if (path == null) {
            return this.getParent(basePath);
        }
        return this.resolveSibling(basePath, path.toString());
    }

    public NutsPath toCompressedForm(NutsPath basePath) {
        return null;
    }

    public URL toURL(NutsPath basePath) {
        try {
            return this.value.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public Path toFile(NutsPath basePath) {
        return this.value;
    }

    public boolean isSymbolicLink(NutsPath basePath) {
        PosixFileAttributes a = this.getUattr();
        return a != null && a.isSymbolicLink();
    }

    public boolean isOther(NutsPath basePath) {
        PosixFileAttributes a = this.getUattr();
        return a != null && a.isOther();
    }

    public boolean isDirectory(NutsPath basePath) {
        return Files.isDirectory(this.value, new LinkOption[0]);
    }

    public boolean isLocal(NutsPath basePath) {
        return true;
    }

    public boolean isRegularFile(NutsPath basePath) {
        return Files.isRegularFile(this.value, new LinkOption[0]);
    }

    public boolean exists(NutsPath basePath) {
        return Files.exists(this.value, new LinkOption[0]);
    }

    public long getContentLength(NutsPath basePath) {
        try {
            return Files.size(this.value);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public String getContentEncoding(NutsPath basePath) {
        return null;
    }

    public String getContentType(NutsPath basePath) {
        return NutsContentTypes.of((NutsSession)this.session).probeContentType(this.value);
    }

    public String getLocation(NutsPath basePath) {
        return this.value.toString();
    }

    public InputStream getInputStream(NutsPath basePath) {
        try {
            return InputStreamMetadataAwareImpl.of(Files.newInputStream(this.value, new OpenOption[0]), basePath.getStreamMetadata());
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public OutputStream getOutputStream(NutsPath basePath) {
        try {
            return Files.newOutputStream(this.value, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(NutsPath basePath, boolean recurse) {
        if (Files.isRegularFile(this.value, new LinkOption[0])) {
            try {
                Files.delete(this.value);
            }
            catch (IOException e) {
                throw new NutsIOException(this.getSession(), (Throwable)e);
            }
        } else if (Files.isDirectory(this.value, new LinkOption[0])) {
            if (recurse) {
                CoreIOUtils.delete(this.getSession(), this.value);
            } else {
                try {
                    Files.delete(this.value);
                }
                catch (IOException e) {
                    throw new NutsIOException(this.getSession(), (Throwable)e);
                }
            }
        } else {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to delete path %s", (Object[])new Object[]{this.value}));
        }
    }

    public void mkdir(boolean parents, NutsPath basePath) {
        if (Files.isRegularFile(this.value, new LinkOption[0])) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to create folder out of regular file %s", (Object[])new Object[]{this.value}));
        }
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(this.value, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to create folders %s", (Object[])new Object[]{this.value}));
        }
    }

    public Instant getLastModifiedInstant(NutsPath basePath) {
        FileTime r = null;
        try {
            r = Files.getLastModifiedTime(this.value, new LinkOption[0]);
            if (r != null) {
                return r.toInstant();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Instant getLastAccessInstant(NutsPath basePath) {
        BasicFileAttributes a = this.getBattr();
        if (a != null) {
            FileTime t = a.lastAccessTime();
            return t == null ? null : Instant.ofEpochMilli(t.toMillis());
        }
        return null;
    }

    public Instant getCreationInstant(NutsPath basePath) {
        BasicFileAttributes a = this.getBattr();
        if (a != null) {
            FileTime t = a.creationTime();
            return t == null ? null : Instant.ofEpochMilli(t.toMillis());
        }
        return null;
    }

    public NutsPath getParent(NutsPath basePath) {
        Path p = this.value.getParent();
        if (p == null) {
            return null;
        }
        return this.fastPath(p, this.getSession());
    }

    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        if (rootPath == null) {
            return this.fastPath(this.value.normalize().toAbsolutePath(), this.session);
        }
        return rootPath.toAbsolute().resolve(this.toString());
    }

    public NutsPath normalize(NutsPath basePath) {
        return this.fastPath(this.value.normalize(), this.session);
    }

    public boolean isAbsolute(NutsPath basePath) {
        return this.value.isAbsolute();
    }

    public String owner(NutsPath basePath) {
        PosixFileAttributes a = this.getUattr();
        if (a != null) {
            UserPrincipal o = a.owner();
            return o == null ? null : o.getName();
        }
        return null;
    }

    public String group(NutsPath basePath) {
        PosixFileAttributes a = this.getUattr();
        if (a != null) {
            GroupPrincipal o = a.group();
            return o == null ? null : o.getName();
        }
        return null;
    }

    public Set<NutsPathPermission> getPermissions(NutsPath basePath) {
        LinkedHashSet<NutsPathPermission> p = new LinkedHashSet<NutsPathPermission>();
        PosixFileAttributes a = this.getUattr();
        File file = this.value.toFile();
        if (file.canRead()) {
            p.add(NutsPathPermission.CAN_READ);
        }
        if (file.canWrite()) {
            p.add(NutsPathPermission.CAN_WRITE);
        }
        if (file.canExecute()) {
            p.add(NutsPathPermission.CAN_EXECUTE);
        }
        if (a != null) {
            for (PosixFilePermission permission : a.permissions()) {
                switch (permission) {
                    case OWNER_READ: {
                        p.add(NutsPathPermission.OWNER_READ);
                    }
                    case OWNER_WRITE: {
                        p.add(NutsPathPermission.OWNER_WRITE);
                    }
                    case OWNER_EXECUTE: {
                        p.add(NutsPathPermission.OWNER_EXECUTE);
                    }
                    case GROUP_READ: {
                        p.add(NutsPathPermission.GROUP_READ);
                    }
                    case GROUP_WRITE: {
                        p.add(NutsPathPermission.GROUP_WRITE);
                    }
                    case GROUP_EXECUTE: {
                        p.add(NutsPathPermission.GROUP_EXECUTE);
                    }
                    case OTHERS_READ: {
                        p.add(NutsPathPermission.OTHERS_READ);
                    }
                    case OTHERS_WRITE: {
                        p.add(NutsPathPermission.OTHERS_WRITE);
                    }
                    case OTHERS_EXECUTE: {
                        p.add(NutsPathPermission.OTHERS_EXECUTE);
                    }
                }
            }
        }
        return Collections.unmodifiableSet(p);
    }

    public void setPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        LinkedHashSet<NutsPathPermission> add = new LinkedHashSet<NutsPathPermission>(Arrays.asList(permissions));
        LinkedHashSet<NutsPathPermission> remove = new LinkedHashSet<NutsPathPermission>(EnumSet.allOf(NutsPathPermission.class));
        remove.addAll(add);
        this.setPermissions(add.toArray(new NutsPathPermission[0]), true);
    }

    public void addPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        this.setPermissions(permissions, true);
    }

    public void removePermissions(NutsPath basePath, NutsPathPermission ... permissions) {
    }

    public boolean isName(NutsPath basePath) {
        if (this.value.getNameCount() > 1) {
            return false;
        }
        String v = this.value.toString();
        switch (v) {
            case "/": 
            case "\\": 
            case ".": 
            case "..": {
                return false;
            }
        }
        for (Object c : (String)v.toCharArray()) {
            switch (c) {
                case 47: 
                case 92: {
                    return false;
                }
            }
        }
        return true;
    }

    public int getPathCount(NutsPath basePath) {
        return this.value.getNameCount();
    }

    public boolean isRoot(NutsPath basePath) {
        return this.value.getNameCount() == 0;
    }

    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        NutsPath parent = basePath.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getRoot();
    }

    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        FileVisitOption[] fileOptions = (FileVisitOption[])Arrays.stream(options).map(x -> {
            if (x == null) {
                return null;
            }
            switch (x) {
                case FOLLOW_LINKS: {
                    return FileVisitOption.FOLLOW_LINKS;
                }
            }
            return null;
        }).filter(Objects::nonNull).toArray(FileVisitOption[]::new);
        if (Files.isDirectory(this.value, new LinkOption[0])) {
            try {
                return NutsStream.of(Files.walk(this.value, maxDepth, fileOptions).map(x -> this.fastPath((Path)x, this.getSession())), (NutsSession)this.getSession());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public NutsPath subpath(NutsPath basePath, int beginIndex, int endIndex) {
        return this.fastPath(this.value.subpath(beginIndex, endIndex), this.getSession());
    }

    public String[] getItems(NutsPath basePath) {
        int nameCount = this.value.getNameCount();
        String[] names = new String[nameCount];
        for (int i = 0; i < nameCount; ++i) {
            names[i] = this.value.getName(i).toString();
        }
        return names;
    }

    public void moveTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        Path f = other.asFile();
        if (f != null) {
            try {
                Files.move(this.value, f, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new NutsIOException(this.session, (Throwable)e);
            }
        } else {
            this.copyTo(basePath, other, options);
            this.delete(basePath, true);
        }
    }

    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        NutsCp.of((NutsSession)this.session).from(this.fastPath(this.value, this.session)).to(other).run();
    }

    public void walkDfs(NutsPath basePath, final NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        HashSet<FileVisitOption> foptions = new HashSet<FileVisitOption>();
        for (NutsPathOption option : options) {
            switch (option) {
                case FOLLOW_LINKS: {
                    foptions.add(FileVisitOption.FOLLOW_LINKS);
                }
            }
        }
        try {
            Files.walkFileTree(this.value, foptions, maxDepth, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return this.fileVisitResult(visitor.preVisitDirectory((Object)FilePath.this.fastPath(dir, FilePath.this.session), FilePath.this.session));
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return this.fileVisitResult(visitor.visitFile((Object)FilePath.this.fastPath(file, FilePath.this.session), FilePath.this.session));
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return this.fileVisitResult(visitor.visitFileFailed((Object)FilePath.this.fastPath(file, FilePath.this.session), (Exception)exc, FilePath.this.session));
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return this.fileVisitResult(visitor.postVisitDirectory((Object)FilePath.this.fastPath(dir, FilePath.this.session), (Exception)exc, FilePath.this.session));
                }

                private FileVisitResult fileVisitResult(NutsTreeVisitResult z) {
                    if (z != null) {
                        switch (z) {
                            case CONTINUE: {
                                return FileVisitResult.CONTINUE;
                            }
                            case TERMINATE: {
                                return FileVisitResult.TERMINATE;
                            }
                            case SKIP_SUBTREE: {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            case SKIP_SIBLINGS: {
                                return FileVisitResult.SKIP_SIBLINGS;
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new NutsIOException(this.getSession(), (Throwable)e);
        }
    }

    private String getSep() {
        for (char c : this.value.toString().toCharArray()) {
            switch (c) {
                case '/': 
                case '\\': {
                    return String.valueOf(c);
                }
            }
        }
        return "/";
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePath urlPath = (FilePath)o;
        return Objects.equals(this.value, urlPath.value);
    }

    public String toString() {
        return this.value.toString();
    }

    private BasicFileAttributes getBattr() {
        try {
            return Files.readAttributes(this.value, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PosixFileAttributes getUattr() {
        try {
            return Files.readAttributes(this.value, PosixFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean setPermissions(NutsPathPermission[] permissions, boolean f) {
        int count = 0;
        block14: for (NutsPathPermission permission : permissions = permissions == null ? new NutsPathPermission[]{} : (NutsPathPermission[])Arrays.stream(permissions).filter(Objects::nonNull).distinct().toArray(NutsPathPermission[]::new)) {
            switch (permission) {
                case CAN_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case CAN_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case CAN_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OWNER_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OWNER_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OWNER_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case GROUP_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case GROUP_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case GROUP_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OTHERS_READ: {
                    boolean b = this.value.toFile().setReadable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OTHERS_WRITE: {
                    boolean b = this.value.toFile().setWritable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
                case OTHERS_EXECUTE: {
                    boolean b = this.value.toFile().setExecutable(f);
                    if (!b) continue block14;
                    ++count;
                    continue block14;
                }
            }
        }
        return count == permissions.length;
    }

    public NutsPath toRelativePath(NutsPath basePath, NutsPath parentPath) {
        String parent;
        String child = basePath.getLocation();
        if (child.startsWith(parent = parentPath.getLocation())) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            return NutsPath.of((String)child, (NutsSession)this.session);
        }
        return null;
    }

    public static class FilePathFactory
    implements NutsPathFactory {
        NutsWorkspace ws;

        public FilePathFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            try {
                if (URLPath.MOSTLY_URL_PATTERN.matcher(path).matches()) {
                    return null;
                }
                Path value = Paths.get(path, new String[0]);
                return NutsSupported.of((int)10, () -> new FilePath(value, session));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final FilePath p;

        public MyPathFormat(FilePath p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            return NutsTexts.of((NutsSession)this.p.getSession()).toText((Object)this.p.value);
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

