/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.path.spi.AbstractPathSPIAdapter;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.HtmlfsPath;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;
import net.thevpc.nuts.spi.NutsUseDefault;

public class DotfilefsPath
extends AbstractPathSPIAdapter {
    public static final String PROTOCOL = "dotfilefs";
    public static final String PREFIX = "dotfilefs:";

    public DotfilefsPath(String url, NutsSession session) {
        super(NutsPath.of((String)url.substring(PREFIX.length()), (NutsSession)session), session);
        if (!url.startsWith(PREFIX)) {
            throw new NutsUnsupportedArgumentException(session, NutsMessage.cstyle((String)"expected prefix 'dotfilefs:'", (Object[])new Object[0]));
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(PROTOCOL, super.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return PREFIX + this.ref.toString();
    }

    @Override
    public NutsStream<NutsPath> list(NutsPath basePath) {
        return NutsStream.of(this.parseHtml(this.ref.toString()).stream().map(x -> {
            if (x.endsWith("/")) {
                return NutsPath.of((String)(PREFIX + this.ref.resolve(x)), (NutsSession)this.session);
            }
            return this.ref.resolve(x);
        }), (NutsSession)this.session);
    }

    @Override
    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getProtocol(NutsPath basePath) {
        return PROTOCOL;
    }

    @Override
    public NutsPath resolve(NutsPath basePath, String path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolve(path)), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolve(path)), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolveSibling(NutsPath basePath, String path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolveSibling(path)), (NutsSession)this.session);
    }

    @Override
    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return NutsPath.of((String)(PREFIX + this.ref.resolveSibling(path)), (NutsSession)this.session);
    }

    @Override
    public boolean isSymbolicLink(NutsPath basePath) {
        return false;
    }

    @Override
    public boolean isOther(NutsPath basePath) {
        return false;
    }

    @Override
    public boolean isDirectory(NutsPath basePath) {
        if (NutsBlankable.isBlank((String)basePath.getLocation()) || basePath.getLocation().endsWith("/")) {
            return true;
        }
        String t = this.getContentType(basePath);
        if (t != null) {
            if (t.endsWith("text/html")) {
                return true;
            }
            if (t.startsWith("text/html;")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRegularFile(NutsPath basePath) {
        return false;
    }

    @Override
    public boolean exists(NutsPath basePath) {
        String t = this.getContentType(basePath);
        return "text/html".equals(t);
    }

    @Override
    public NutsPath getParent(NutsPath basePath) {
        NutsPath p = this.ref.getParent();
        if (p == null) {
            return null;
        }
        return NutsPath.of((String)(PREFIX + p), (NutsSession)this.session);
    }

    @Override
    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return NutsPath.of((String)(PREFIX + basePath.toAbsolute(rootPath)), (NutsSession)this.session);
    }

    @Override
    public NutsPath normalize(NutsPath basePath) {
        return NutsPath.of((String)(PREFIX + this.ref.normalize()), (NutsSession)this.session);
    }

    @Override
    public boolean isName(NutsPath basePath) {
        return false;
    }

    @Override
    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        return NutsPath.of((String)(PREFIX + this.ref.getRoot()), (NutsSession)this.session);
    }

    @Override
    @NutsUseDefault
    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        return null;
    }

    @Override
    @NutsUseDefault
    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
    }

    private List<String> parseHtml(String baseUrl) {
        boolean folders = true;
        boolean files = true;
        ArrayList<String> all = new ArrayList<String>();
        InputStream foldersFileStream = null;
        String dotFilesUrl = baseUrl + "/" + ".files";
        NutsVersion versionString = NutsVersion.of((String)"0.5.5", (NutsSession)this.session);
        try {
            this.session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", NutsPath.of((String)baseUrl, (NutsSession)this.session).toCompressedForm()});
            foldersFileStream = NutsInputStreamMonitor.of((NutsSession)this.session).setSource(dotFilesUrl).create();
            List<String> splitted = StringTokenizerUtils.split(CoreIOUtils.loadString(foldersFileStream, true, this.session), "\n\r");
            for (String s : splitted) {
                int y;
                if ((s = s.trim()).length() <= 0) continue;
                if (s.startsWith("#")) {
                    if (!all.isEmpty() || !(s = s.substring(1).trim()).startsWith("version=")) continue;
                    versionString = NutsVersion.of((String)s.substring("version=".length()).trim(), (NutsSession)this.session);
                    continue;
                }
                if (versionString.compareTo("0.5.7") < 0) {
                    if (files) {
                        all.add(s);
                        continue;
                    }
                    break;
                }
                if (s.endsWith("/")) {
                    y = (s = s.substring(0, s.length() - 1)).lastIndexOf(47);
                    if (y > 0) {
                        s = s.substring(y + 1);
                    }
                    if (s.length() <= 0 || s.equals("..") || !folders) continue;
                    if (!s.endsWith("/")) {
                        s = s + "/";
                    }
                    all.add(s);
                    continue;
                }
                if (!files) continue;
                y = s.lastIndexOf(47);
                if (y > 0) {
                    s = s.substring(y + 1);
                }
                all.add(s);
            }
        }
        catch (UncheckedIOException | NutsIOException ex) {
            NutsLoggerOp.of(DotfilefsPath.class, (NutsSession)this.session).level(Level.FINE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to navigate : file not found {0}", (Object[])new Object[]{dotFilesUrl}));
        }
        if (versionString.compareTo("0.5.7") < 0 && folders) {
            String[] foldersFileContent = null;
            String dotFolderUrl = baseUrl + "/" + ".folder";
            try (InputStream stream = NutsInputStreamMonitor.of((NutsSession)this.session).setSource(dotFolderUrl).create();){
                foldersFileContent = (String[])StringTokenizerUtils.split(CoreIOUtils.loadString(stream, true, this.session), "\n\r").stream().map(x -> x.trim()).filter(x -> x.length() > 0).toArray(String[]::new);
            }
            catch (IOException | UncheckedIOException | NutsIOException ex) {
                NutsLoggerOp.of(DotfilefsPath.class, (NutsSession)this.session).level(Level.FINE).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to navigate : file not found {0}", (Object[])new Object[]{dotFolderUrl}));
            }
            if (foldersFileContent != null) {
                for (String folder : foldersFileContent) {
                    if (!folder.endsWith("/")) {
                        folder = folder + "/";
                    }
                    all.add(folder);
                }
            }
        }
        return all;
    }

    public boolean isLocal(NutsPath basePath) {
        return this.ref.isLocal();
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final DotfilefsPath p;

        public MyPathFormat(DotfilefsPath p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            NutsTextBuilder sb = NutsTextBuilder.of((NutsSession)this.p.getSession());
            sb.append((Object)"html", NutsTextStyle.primary1());
            sb.append((Object)":", NutsTextStyle.separator());
            sb.append((Object)this.p.ref);
            return sb.build();
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }

    public static class DotfilefsFactory
    implements NutsPathFactory {
        private NutsWorkspace ws;

        public DotfilefsFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            if (path.startsWith(DotfilefsPath.PREFIX)) {
                return NutsSupported.of((int)10, () -> new HtmlfsPath(path, session));
            }
            return null;
        }
    }
}

