/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.util.Objects;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupported;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;

public class ClassLoaderPath
extends URLPath {
    private final String path;
    private final ClassLoader loader;

    public ClassLoaderPath(String path, ClassLoader loader, NutsSession session) {
        super(loader.getResource(path.substring("classpath://".length())), session, true);
        this.path = path;
        this.loader = loader;
        if (!path.startsWith("classpath://")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid classpath url format: %s", (Object[])new Object[]{path}));
        }
    }

    @Override
    public String toString() {
        return this.path;
    }

    @Override
    public String getName(NutsPath basePath) {
        return URLPath.getURLName(this.path);
    }

    @Override
    public String getLocation(NutsPath basePath) {
        if (this.url != null) {
            return super.getLocation(basePath);
        }
        return this.path.substring("classpath:/".length());
    }

    @Override
    public String getProtocol(NutsPath basePath) {
        return "classpath";
    }

    @Override
    protected NutsPath rebuildURLPath(String other) {
        return NutsPath.of((NutsPathSPI)new ClassLoaderPath(other, this.loader, this.getSession()), (NutsSession)this.getSession());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderPath that = (ClassLoaderPath)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.loader, that.loader);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.path, this.loader);
    }

    public static class ClasspathFactory
    implements NutsPathFactory {
        NutsWorkspace ws;

        public ClasspathFactory(NutsWorkspace ws) {
            this.ws = ws;
        }

        public NutsSupported<NutsPathSPI> createPath(String path, NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(this.ws, session);
            try {
                if (path.startsWith("classpath:")) {
                    return NutsSupported.of((int)10, () -> new ClassLoaderPath(path, classLoader, session));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

