/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;

public abstract class AbstractPathSPIAdapter
implements NutsPathSPI {
    protected final NutsSession session;
    protected NutsPath ref;

    protected AbstractPathSPIAdapter(NutsPath ref, NutsSession session) {
        this.session = session;
        this.ref = ref;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPathSPIAdapter urlPath = (AbstractPathSPIAdapter)o;
        return Objects.equals(this.ref, urlPath.ref);
    }

    public String toString() {
        return this.ref.toString();
    }

    public NutsStream<NutsPath> list(NutsPath basePath) {
        return this.ref.list();
    }

    public NutsFormatSPI formatter(NutsPath basePath) {
        return new MyPathFormat(this);
    }

    public String getName(NutsPath basePath) {
        return this.ref.getName();
    }

    public String getProtocol(NutsPath basePath) {
        return this.ref.getProtocol();
    }

    public NutsPath resolve(NutsPath basePath, String path) {
        return this.ref.resolve(path);
    }

    public NutsPath resolve(NutsPath basePath, NutsPath path) {
        return this.ref.resolve(path);
    }

    public NutsPath resolveSibling(NutsPath basePath, String path) {
        return this.ref.resolveSibling(path);
    }

    public NutsPath resolveSibling(NutsPath basePath, NutsPath path) {
        return this.ref.resolveSibling(path);
    }

    public NutsPath toCompressedForm(NutsPath basePath) {
        return null;
    }

    public URL toURL(NutsPath basePath) {
        return this.ref.toURL();
    }

    public Path toFile(NutsPath basePath) {
        return this.ref.toFile();
    }

    public boolean isSymbolicLink(NutsPath basePath) {
        return false;
    }

    public boolean isOther(NutsPath basePath) {
        return false;
    }

    public boolean isDirectory(NutsPath basePath) {
        return this.ref.isDirectory();
    }

    public boolean isRegularFile(NutsPath basePath) {
        return this.ref.isRegularFile();
    }

    public boolean exists(NutsPath basePath) {
        return this.ref.exists();
    }

    public long getContentLength(NutsPath basePath) {
        return this.ref.getContentLength();
    }

    public String getContentEncoding(NutsPath basePath) {
        return this.ref.getContentEncoding();
    }

    public String getContentType(NutsPath basePath) {
        return this.ref.getContentType();
    }

    public String getLocation(NutsPath basePath) {
        return this.ref.getLocation();
    }

    public InputStream getInputStream(NutsPath basePath) {
        return this.ref.getInputStream();
    }

    public OutputStream getOutputStream(NutsPath basePath) {
        return this.ref.getOutputStream();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void delete(NutsPath basePath, boolean recurse) {
        this.ref.delete(recurse);
    }

    public void mkdir(boolean parents, NutsPath basePath) {
        this.ref.delete(parents);
    }

    public Instant getLastModifiedInstant(NutsPath basePath) {
        return this.ref.getLastModifiedInstant();
    }

    public Instant getLastAccessInstant(NutsPath basePath) {
        return this.ref.getLastAccessInstant();
    }

    public Instant getCreationInstant(NutsPath basePath) {
        return this.ref.getCreationInstant();
    }

    public NutsPath getParent(NutsPath basePath) {
        return this.ref.getParent();
    }

    public NutsPath toAbsolute(NutsPath basePath, NutsPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return basePath.toAbsolute();
    }

    public NutsPath normalize(NutsPath basePath) {
        return basePath.normalize();
    }

    public boolean isAbsolute(NutsPath basePath) {
        return this.ref.isAbsolute();
    }

    public String owner(NutsPath basePath) {
        return this.ref.owner();
    }

    public String group(NutsPath basePath) {
        return this.ref.group();
    }

    public Set<NutsPathPermission> getPermissions(NutsPath basePath) {
        return this.ref.getPermissions();
    }

    public void setPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        this.ref.setPermissions(permissions);
    }

    public void addPermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        this.ref.addPermissions(permissions);
    }

    public void removePermissions(NutsPath basePath, NutsPathPermission ... permissions) {
        this.ref.removePermissions(permissions);
    }

    public boolean isName(NutsPath basePath) {
        return this.ref.isName();
    }

    public int getPathCount(NutsPath basePath) {
        return this.ref.getPathCount();
    }

    public boolean isRoot(NutsPath basePath) {
        return this.ref.isRoot();
    }

    public NutsPath getRoot(NutsPath basePath) {
        if (this.isRoot(basePath)) {
            return basePath;
        }
        return this.ref.getRoot();
    }

    public NutsStream<NutsPath> walk(NutsPath basePath, int maxDepth, NutsPathOption[] options) {
        return this.ref.walk(maxDepth, options);
    }

    public NutsPath subpath(NutsPath basePath, int beginIndex, int endIndex) {
        return this.ref.subpath(beginIndex, endIndex);
    }

    public String[] getItems(NutsPath basePath) {
        return this.ref.getItems();
    }

    public void moveTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        this.ref.moveTo(other, new NutsPathOption[0]);
    }

    public void copyTo(NutsPath basePath, NutsPath other, NutsPathOption ... options) {
        this.ref.copyTo(other, new NutsPathOption[0]);
    }

    public void walkDfs(NutsPath basePath, NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        this.ref.walkDfs(visitor, maxDepth, options);
    }

    public NutsPath toRelativePath(NutsPath basePath, NutsPath parentPath) {
        String parent;
        String child = basePath.getLocation();
        if (child.startsWith(parent = parentPath.getLocation())) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            return NutsPath.of((String)child, (NutsSession)this.session);
        }
        return null;
    }

    private static class MyPathFormat
    implements NutsFormatSPI {
        private final AbstractPathSPIAdapter p;

        public MyPathFormat(AbstractPathSPIAdapter p) {
            this.p = p;
        }

        public NutsString asFormattedString() {
            NutsTextBuilder sb = NutsTextBuilder.of((NutsSession)this.p.getSession());
            sb.append((Object)this.p.ref);
            return sb.build();
        }

        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }
    }
}

