/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPathStreamMetadata;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.NutsWorkspaceLocationManager;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.io.path.DirectoryScanner;
import net.thevpc.nuts.runtime.standalone.io.path.NutsCompressedPath;
import net.thevpc.nuts.runtime.standalone.io.path.NutsPathBase;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NutsPathSPIHelper;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.standalone.util.reflect.NutsUseDefaultUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceVarExpansionFunction;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;
import net.thevpc.nuts.spi.NutsFormatSPI;
import net.thevpc.nuts.spi.NutsPathSPI;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class NutsPathFromSPI
extends NutsPathBase {
    private final NutsPathSPI base;
    private String[] items;

    public NutsPathFromSPI(NutsPathSPI base) {
        super(base.getSession());
        this.base = base;
    }

    public String getContentEncoding() {
        return this.base.getContentEncoding((NutsPath)this);
    }

    public String getContentType() {
        return this.base.getContentType((NutsPath)this);
    }

    public String getName() {
        String n = this.base.getName((NutsPath)this);
        if (n == null) {
            String loc = this.getLocation();
            return loc == null ? "" : URLPath.getURLName(loc);
        }
        return n;
    }

    public String getLocation() {
        return this.base.getLocation((NutsPath)this);
    }

    public NutsPath resolve(String other) {
        if (NutsBlankable.isBlank((String)other)) {
            return this;
        }
        return this.base.resolve((NutsPath)this, other);
    }

    public NutsPath resolve(NutsPath other) {
        return this.base.resolve((NutsPath)this, other);
    }

    public NutsPath resolveSibling(String other) {
        if (NutsBlankable.isBlank((String)other)) {
            return this.getParent();
        }
        return this.base.resolveSibling((NutsPath)this, other);
    }

    public NutsPath resolveSibling(NutsPath other) {
        return this.base.resolveSibling((NutsPath)this, other);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readAllBytes() {
        long len = this.getContentLength();
        int readSize = 1024;
        if (len < 0L) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[readSize];
            try (InputStream is = this.getInputStream();){
                int count = 0;
                boolean offset = false;
                while ((count = is.read(buffer, 0, readSize)) > 0) {
                    bos.write(buffer, 0, count);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to read file %s", (Object[])new Object[]{this}), (Throwable)e);
            }
        }
        int ilen = (int)len;
        if (len > 0x7FFFFFF7L) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"file is too large %s", (Object[])new Object[]{this}));
        }
        byte[] buffer = new byte[ilen];
        try (InputStream is = this.getInputStream();){
            int count = 0;
            int offset = 0;
            while ((count = is.read(buffer, offset, ilen - offset)) > 0) {
                offset += count;
            }
            if (offset < ilen) {
                throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"premature read stop %s", (Object[])new Object[]{this}));
            }
            if (is.read() >= 0) {
                throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"invalid %s", (Object[])new Object[]{this}));
            }
            byte[] byArray = buffer;
            return byArray;
        }
        catch (IOException e) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to read file %s", (Object[])new Object[]{this}), (Throwable)e);
        }
    }

    public NutsPath writeBytes(byte[] bytes) {
        try (OutputStream os = this.getOutputStream();){
            os.write(bytes);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), NutsMessage.cstyle((String)"unable to write to %s", (Object[])new Object[]{this}));
        }
        return this;
    }

    public String getProtocol() {
        String n = this.base.getProtocol((NutsPath)this);
        if (n == null) {
            String ts = this.base.toString();
            int i = ts.indexOf(58);
            if (i >= 0) {
                return ts.substring(0, i);
            }
            return null;
        }
        return n;
    }

    public NutsPath toCompressedForm() {
        NutsPath n = this.base.toCompressedForm((NutsPath)this);
        if (n == null) {
            return new NutsCompressedPath(this);
        }
        return this;
    }

    public URL toURL() {
        return this.base.toURL((NutsPath)this);
    }

    public Path toFile() {
        return this.base.toFile((NutsPath)this);
    }

    public NutsStream<NutsPath> list() {
        NutsStream p = this.base.list((NutsPath)this);
        if (p != null) {
            return p;
        }
        return NutsStream.ofEmpty((NutsSession)this.getSession());
    }

    public InputStream getInputStream() {
        return InputStreamMetadataAwareImpl.of(this.base.getInputStream((NutsPath)this), this.getStreamMetadata());
    }

    public OutputStream getOutputStream() {
        return this.base.getOutputStream((NutsPath)this);
    }

    public NutsPath deleteTree() {
        this.base.delete((NutsPath)this, true);
        return this;
    }

    public NutsPath delete(boolean recurse) {
        this.base.delete((NutsPath)this, recurse);
        return this;
    }

    public NutsPath mkdir(boolean parents) {
        this.base.mkdir(parents, (NutsPath)this);
        return this;
    }

    public NutsPath mkdirs() {
        this.base.mkdir(true, (NutsPath)this);
        return this;
    }

    public NutsPath mkdir() {
        this.base.mkdir(false, (NutsPath)this);
        return this;
    }

    public NutsPath expandPath(Function<String, String> resolver) {
        NutsSession session = this.getSession();
        resolver = new EffectiveResolver(resolver, session);
        String s = StringPlaceHolderParser.replaceDollarPlaceHolders(this.toString(), resolver);
        if (s.length() > 0 && s.startsWith("~")) {
            NutsWorkspaceLocationManager locations = session.locations();
            if (s.equals("~~")) {
                NutsPath nutsHome = locations.getHomeLocation(NutsStoreLocation.CONFIG);
                return nutsHome.normalize();
            }
            if (s.startsWith("~~") && s.length() > 2 && (s.charAt(2) == '/' || s.charAt(2) == '\\')) {
                NutsPath nutsHome = locations.getHomeLocation(NutsStoreLocation.CONFIG);
                return nutsHome.resolve(s.substring(3)).normalize();
            }
            if (s.equals("~")) {
                return NutsPath.ofUserHome((NutsSession)session);
            }
            if (s.startsWith("~") && s.length() > 1 && (s.charAt(1) == '/' || s.charAt(1) == '\\')) {
                return NutsPath.ofUserHome((NutsSession)session).resolve(s.substring(2));
            }
            return NutsPath.of((String)s, (NutsSession)session);
        }
        return NutsPath.of((String)s, (NutsSession)session);
    }

    public NutsPath mkParentDirs() {
        NutsPath p = this.getParent();
        if (p != null) {
            p.mkdir(true);
        }
        return this;
    }

    public boolean isOther() {
        return this.base.isOther((NutsPath)this);
    }

    public boolean isSymbolicLink() {
        return this.base.isSymbolicLink((NutsPath)this);
    }

    public boolean isDirectory() {
        return this.base.isDirectory((NutsPath)this);
    }

    public boolean isRegularFile() {
        return this.base.isRegularFile((NutsPath)this);
    }

    public boolean isRemote() {
        return !this.base.isLocal((NutsPath)this);
    }

    public boolean isLocal() {
        return this.base.isLocal((NutsPath)this);
    }

    public boolean exists() {
        return this.base.exists((NutsPath)this);
    }

    public long getContentLength() {
        return this.base.getContentLength((NutsPath)this);
    }

    public Instant getLastModifiedInstant() {
        return this.base.getLastModifiedInstant((NutsPath)this);
    }

    public Instant getLastAccessInstant() {
        return this.base.getLastAccessInstant((NutsPath)this);
    }

    public Instant getCreationInstant() {
        return this.base.getCreationInstant((NutsPath)this);
    }

    public NutsPath getParent() {
        return this.base.getParent((NutsPath)this);
    }

    public boolean isAbsolute() {
        return this.base.isAbsolute((NutsPath)this);
    }

    public NutsPath normalize() {
        return this.base.normalize((NutsPath)this);
    }

    public NutsPath toAbsolute() {
        return this.toAbsolute((NutsPath)null);
    }

    public NutsPath toAbsolute(String rootPath) {
        return this.toAbsolute(rootPath == null ? null : NutsPath.of((String)rootPath, (NutsSession)this.getSession()));
    }

    public NutsPath toAbsolute(NutsPath rootPath) {
        if (this.base.isAbsolute((NutsPath)this)) {
            return this;
        }
        return this.base.toAbsolute((NutsPath)this, rootPath);
    }

    public NutsPath toRelativePath(NutsPath parentPath) {
        return this.base.toRelativePath((NutsPath)this, parentPath);
    }

    public String owner() {
        return this.base.owner((NutsPath)this);
    }

    public String group() {
        return this.base.group((NutsPath)this);
    }

    public Set<NutsPathPermission> getPermissions() {
        return this.base.getPermissions((NutsPath)this);
    }

    public NutsPath setPermissions(NutsPathPermission ... permissions) {
        this.base.setPermissions((NutsPath)this, permissions);
        return this;
    }

    public NutsPath addPermissions(NutsPathPermission ... permissions) {
        this.base.addPermissions((NutsPath)this, permissions);
        return this;
    }

    public NutsPath removePermissions(NutsPathPermission ... permissions) {
        this.base.removePermissions((NutsPath)this, permissions);
        return this;
    }

    public boolean isName() {
        return this.base.isName((NutsPath)this);
    }

    public int getPathCount() {
        return this.base.getPathCount((NutsPath)this);
    }

    public boolean isRoot() {
        return this.base.isRoot((NutsPath)this);
    }

    public NutsStream<NutsPath> walk(int maxDepth, NutsPathOption[] options) {
        NutsPathOption[] options1;
        NutsPathOption[] nutsPathOptionArray = options1 = options == null ? new NutsPathOption[]{} : (NutsPathOption[])Arrays.stream(options).filter(Objects::isNull).distinct().toArray(NutsPathOption[]::new);
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        if (NutsUseDefaultUtils.isUseDefault(this.base.getClass(), "walk", NutsPath.class, Integer.TYPE, NutsPathOption[].class)) {
            return NutsPathSPIHelper.walk(this.getSession(), this, maxDepth, options1);
        }
        return this.base.walk((NutsPath)this, maxDepth, options);
    }

    public NutsPath subpath(int beginIndex, int endIndex) {
        return this.base.subpath((NutsPath)this, beginIndex, endIndex);
    }

    public String getItem(int index) {
        return this.getItems()[index];
    }

    public String[] getItems() {
        if (this.items == null) {
            this.items = this.base.getItems((NutsPath)this);
        }
        return this.items == null ? new String[]{} : this.items;
    }

    public void moveTo(NutsPath other, NutsPathOption ... options) {
        this.base.moveTo((NutsPath)this, other, new NutsPathOption[0]);
    }

    public void copyTo(NutsPath other, NutsPathOption ... options) {
        this.base.copyTo((NutsPath)this, other, options);
    }

    public NutsPath getRoot() {
        return this.base.getRoot((NutsPath)this);
    }

    public NutsPath walkDfs(NutsTreeVisitor<NutsPath> visitor, NutsPathOption ... options) {
        return this.walkDfs(visitor, Integer.MAX_VALUE, options);
    }

    public NutsPath walkDfs(NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        if (NutsUseDefaultUtils.isUseDefault(this.base.getClass(), "walkDfs", NutsPath.class, NutsTreeVisitor.class, Integer.TYPE, NutsPathOption[].class)) {
            NutsPathSPIHelper.walkDfs(this.getSession(), this, visitor, maxDepth, options);
        } else {
            this.base.walkDfs((NutsPath)this, visitor, maxDepth, options);
        }
        return this;
    }

    public NutsStream<NutsPath> walkGlob(NutsPathOption ... options) {
        return new DirectoryScanner(this, this.getSession()).stream();
    }

    public NutsStreamMetadata getStreamMetadata() {
        return new NutsPathStreamMetadata((NutsPath)this);
    }

    @Override
    public NutsFormat formatter() {
        NutsFormatSPI fspi = null;
        if (!NutsUseDefaultUtils.isUseDefault(this.base.getClass(), "formatter", NutsPath.class)) {
            fspi = this.base.formatter((NutsPath)this);
        }
        if (fspi != null) {
            final NutsFormatSPI finalFspi = fspi;
            return new DefaultFormatBase<NutsFormat>(this.getSession(), "path"){

                @Override
                public void print(NutsPrintStream out) {
                    finalFspi.print(out);
                }

                public boolean configureFirst(NutsCommandLine commandLine) {
                    return finalFspi.configureFirst(commandLine);
                }

                public int getSupportLevel(NutsSupportLevelContext context) {
                    return 10;
                }
            };
        }
        return super.formatter();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.base);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NutsPathFromSPI that = (NutsPathFromSPI)o;
        return Objects.equals(this.base, that.base);
    }

    public String toString() {
        return this.base.toString();
    }

    private static class EffectiveResolver
    implements Function<String, String> {
        NutsWorkspaceVarExpansionFunction fallback;
        Function<String, String> resolver;
        NutsSession session;

        public EffectiveResolver(Function<String, String> resolver, NutsSession session) {
            this.session = session;
            this.resolver = resolver;
            this.fallback = new NutsWorkspaceVarExpansionFunction(session);
        }

        @Override
        public String apply(String s) {
            String v;
            if (this.resolver != null && (v = this.resolver.apply(s)) != null) {
                return v;
            }
            return this.fallback.apply(s);
        }
    }
}

