/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public abstract class NutsPathBase
implements NutsPath {
    private final NutsSession session;
    private String userKind;

    public NutsPathBase(NutsSession session) {
        if (session == null) {
            throw new IllegalArgumentException("invalid session");
        }
        this.session = session;
    }

    public String getBaseName() {
        String n = this.getName();
        int i = n.indexOf(46);
        if (i < 0) {
            return n;
        }
        if (i == n.length() - 1) {
            return n;
        }
        return n.substring(0, i);
    }

    public String getLastExtension() {
        String n = this.getName();
        int i = n.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return n.substring(i + 1);
    }

    public String getFullExtension() {
        String n = this.getName();
        int i = n.indexOf(46);
        if (i < 0) {
            return "";
        }
        return n.substring(i + 1);
    }

    public boolean isURL() {
        return this.asURL() != null;
    }

    public boolean isFile() {
        return this.asFile() != null;
    }

    public URL asURL() {
        try {
            return this.toURL();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Path asFile() {
        try {
            return this.toFile();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsPath delete() {
        return this.delete(false);
    }

    public Stream<String> lines() {
        final BufferedReader br = new BufferedReader(new InputStreamReader(this.getInputStream()));
        Iterator<String> sourceIterator = new Iterator<String>(){
            String line = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                boolean hasNext = false;
                try {
                    try {
                        this.line = br.readLine();
                    }
                    catch (IOException e) {
                        throw new NutsIOException(NutsPathBase.this.session, (Throwable)e);
                    }
                    boolean bl = hasNext = this.line != null;
                    return bl;
                }
                finally {
                    if (!hasNext) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            throw new NutsIOException(NutsPathBase.this.session, (Throwable)e);
                        }
                    }
                }
            }

            @Override
            public String next() {
                return this.line;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(sourceIterator, 16), false);
    }

    public List<String> head(int count) {
        return this.lines().limit(count).collect(Collectors.toList());
    }

    public List<String> tail(int count) {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getInputStream()));
        try {
            String line;
            int count0 = 0;
            while ((line = br.readLine()) != null) {
                lines.add(line);
                if (++count0 <= count) continue;
                lines.remove();
            }
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
        return lines;
    }

    public String getUserKind() {
        return this.userKind;
    }

    public NutsPathBase setUserKind(String userKind) {
        this.userKind = userKind;
        return this;
    }

    public NutsString toNutsString() {
        return NutsTexts.of((NutsSession)this.session).ofPlain(this.toString());
    }

    public NutsFormat formatter() {
        return (NutsFormat)new PathFormat(this).setSession(this.getSession());
    }

    public int hashCode() {
        return Objects.hash(this.userKind, this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NutsPathBase that = (NutsPathBase)o;
        return Objects.equals(this.userKind, that.userKind) && Objects.equals(this.toString(), this.toString());
    }

    public NutsStream<NutsPath> walk() {
        return this.walk(Integer.MAX_VALUE, new NutsPathOption[0]);
    }

    public NutsStream<NutsPath> walk(NutsPathOption ... options) {
        return this.walk(Integer.MAX_VALUE, options);
    }

    public NutsStream<NutsPath> walk(int maxDepth) {
        return this.walk(maxDepth <= 0 ? Integer.MAX_VALUE : maxDepth, new NutsPathOption[0]);
    }

    public Writer getWriter() {
        return new BufferedWriter(new OutputStreamWriter(this.getOutputStream()));
    }

    public Reader getReader() {
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    public boolean isHttp() {
        if (!this.isURL()) {
            return false;
        }
        String s = this.toString();
        return s.startsWith("http://") || s.startsWith("https://");
    }

    private static class PathFormat
    extends DefaultFormatBase<NutsFormat> {
        private final NutsPathBase p;

        public PathFormat(NutsPathBase p) {
            super(p.session, "path");
            this.p = p;
        }

        @Override
        public void print(NutsPrintStream out) {
            out.print((NutsString)NutsTexts.of((NutsSession)this.p.session).ofStyled(this.p.toNutsString(), NutsTextStyle.path()));
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }

        public int getSupportLevel(NutsSupportLevelContext context) {
            return 10;
        }
    }
}

