/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefaultStreamMetadata;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.NutsStreamMetadata;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeVisitor;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.io.path.NutsPathBase;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamMetadataAwareImpl;
import net.thevpc.nuts.runtime.standalone.io.util.URLBuilder;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class NutsCompressedPath
extends NutsPathBase {
    private final String compressedForm;
    private final NutsString formattedCompressedForm;
    private final NutsPath base;

    public NutsCompressedPath(NutsPath base) {
        super(base.getSession());
        this.base = base;
        this.compressedForm = NutsCompressedPath.compressUrl(base.toString());
        this.formattedCompressedForm = NutsTexts.of((NutsSession)base.getSession()).ofStyled(this.compressedForm, NutsTextStyle.path());
    }

    public NutsCompressedPath(NutsPath base, String compressedForm, NutsString formattedCompressedForm) {
        super(base.getSession());
        this.compressedForm = compressedForm;
        this.formattedCompressedForm = formattedCompressedForm;
        this.base = base;
    }

    public static String compressUrl(String path) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            URL u = null;
            try {
                u = new URL(path);
            }
            catch (MalformedURLException e) {
                return path;
            }
            return URLBuilder.buildURLString(u.getProtocol(), u.getAuthority(), u.getPath() != null ? NutsCompressedPath.compressPath(u.getPath(), 0, 2) : null, u.getQuery() != null ? "?..." : null, u.getRef() != null ? "#..." : null);
        }
        return NutsCompressedPath.compressPath(path);
    }

    public static String compressPath(String path) {
        return NutsCompressedPath.compressPath(path, 2, 2);
    }

    public static String compressPath(String path, int left, int right) {
        int interr;
        String p = System.getProperty("user.home");
        if ((path.startsWith("http://") || path.startsWith("https://")) && (interr = path.indexOf(63)) > 0) {
            path = path.substring(0, interr) + "?...";
        }
        if (path.startsWith(p + File.separator)) {
            path = "~" + path.substring(p.length());
        } else {
            int x;
            if (path.startsWith("http://")) {
                x = path.indexOf(47, "http://".length() + 1);
                if (x <= 0) {
                    return path;
                }
                return path.substring(0, x) + NutsCompressedPath.compressPath(path.substring(x), 0, right);
            }
            if (path.startsWith("https://")) {
                x = path.indexOf(47, "https://".length() + 1);
                if (x <= 0) {
                    return path;
                }
                return path.substring(0, x) + NutsCompressedPath.compressPath(path.substring(x), 0, right);
            }
        }
        ArrayList<String> a = new ArrayList<String>(Arrays.asList(path.split("[\\\\/]")));
        int min = left + right + 1;
        if (a.size() > 0 && ((String)a.get(0)).equals("")) {
            ++left;
            ++min;
        }
        if (a.size() > min) {
            a.add(left, "...");
            int len = a.size() - right - left - 1;
            for (int i = 0; i < len; ++i) {
                a.remove(left + 1);
            }
        }
        return String.join((CharSequence)"/", a);
    }

    public String getContentEncoding() {
        return this.base.getContentEncoding();
    }

    public String getContentType() {
        return this.base.getContentType();
    }

    public String getName() {
        return this.base.getName();
    }

    public String getLocation() {
        return this.base.getLocation();
    }

    public NutsPath resolve(String other) {
        return this.base.resolve(other).toCompressedForm();
    }

    public NutsPath resolve(NutsPath other) {
        return this.base.resolve(other).toCompressedForm();
    }

    public NutsPath resolveSibling(String other) {
        return this.base.resolveSibling(other).toCompressedForm();
    }

    public NutsPath resolveSibling(NutsPath other) {
        return this.base.resolveSibling(other).toCompressedForm();
    }

    public byte[] readAllBytes() {
        return this.base.readAllBytes();
    }

    public NutsPath writeBytes(byte[] bytes) {
        return this.base.writeBytes(bytes);
    }

    public String getProtocol() {
        return this.base.getProtocol();
    }

    public NutsPath toCompressedForm() {
        return this;
    }

    public URL toURL() {
        return this.base.toURL();
    }

    public Path toFile() {
        return this.base.toFile();
    }

    public NutsStream<NutsPath> list() {
        return this.base.list();
    }

    public InputStream getInputStream() {
        InputStream is = this.base.getInputStream();
        NutsStreamMetadata m = NutsStreamMetadata.of((Object)is);
        NutsStreamMetadata m2 = new NutsDefaultStreamMetadata(m).setUserKind(this.getUserKind());
        return InputStreamMetadataAwareImpl.of(is, m2);
    }

    public OutputStream getOutputStream() {
        return this.base.getOutputStream();
    }

    public NutsPath deleteTree() {
        return this.base.deleteTree();
    }

    public NutsPath delete(boolean recurse) {
        return this.base.delete(recurse);
    }

    public NutsPath mkdir(boolean parents) {
        return this.base.mkdir(parents);
    }

    public NutsPath mkdirs() {
        return this.base.mkdirs();
    }

    public NutsPath mkdir() {
        return this.base.mkdir();
    }

    public NutsPath expandPath(Function<String, String> resolver) {
        return this.base.expandPath(resolver).toCompressedForm();
    }

    public NutsPath mkParentDirs() {
        return this.base.mkParentDirs();
    }

    public boolean isOther() {
        return this.base.isOther();
    }

    public boolean isSymbolicLink() {
        return this.base.isSymbolicLink();
    }

    public boolean isDirectory() {
        return this.base.isDirectory();
    }

    public boolean isRegularFile() {
        return this.base.isRegularFile();
    }

    public boolean isRemote() {
        return this.base.isRemote();
    }

    public boolean isLocal() {
        return this.base.isLocal();
    }

    public boolean exists() {
        return this.base.exists();
    }

    public long getContentLength() {
        return this.base.getContentLength();
    }

    public Instant getLastModifiedInstant() {
        return this.base.getLastModifiedInstant();
    }

    public Instant getLastAccessInstant() {
        return this.base.getLastAccessInstant();
    }

    public Instant getCreationInstant() {
        return this.base.getCreationInstant();
    }

    public NutsPath getParent() {
        return this.base.getParent();
    }

    public boolean isAbsolute() {
        return this.base.isAbsolute();
    }

    public NutsPath normalize() {
        return this.base.normalize();
    }

    public NutsPath toAbsolute() {
        return this.toAbsolute((NutsPath)null);
    }

    public NutsPath toAbsolute(String basePath) {
        return this.base.toAbsolute(basePath).toCompressedForm();
    }

    public NutsPath toAbsolute(NutsPath basePath) {
        if (this.base.isAbsolute()) {
            return this;
        }
        return basePath.toAbsolute(basePath).toCompressedForm();
    }

    public NutsPath toRelativePath(NutsPath basePath) {
        return this.base.toRelativePath(basePath);
    }

    public String owner() {
        return this.base.owner();
    }

    public String group() {
        return this.base.group();
    }

    public Set<NutsPathPermission> getPermissions() {
        return this.base.getPermissions();
    }

    public NutsPath setPermissions(NutsPathPermission ... permissions) {
        this.base.setPermissions(permissions);
        return this;
    }

    public NutsPath addPermissions(NutsPathPermission ... permissions) {
        this.base.addPermissions(permissions);
        return this;
    }

    public NutsPath removePermissions(NutsPathPermission ... permissions) {
        this.base.removePermissions(permissions);
        return this;
    }

    public boolean isName() {
        return this.base.isName();
    }

    public int getPathCount() {
        return this.base.getPathCount();
    }

    public boolean isRoot() {
        return this.base.isRoot();
    }

    public NutsStream<NutsPath> walk(int maxDepth, NutsPathOption[] options) {
        return this.base.walk(maxDepth, options);
    }

    public NutsPath subpath(int beginIndex, int endIndex) {
        return this.base.subpath(beginIndex, endIndex).toCompressedForm();
    }

    public String getItem(int index) {
        return this.base.getItem(index);
    }

    public String[] getItems() {
        return this.base.getItems();
    }

    public void moveTo(NutsPath other, NutsPathOption ... options) {
        this.base.moveTo(other, new NutsPathOption[0]);
    }

    public void copyTo(NutsPath other, NutsPathOption ... options) {
        this.base.copyTo(other, new NutsPathOption[0]);
    }

    public NutsPath getRoot() {
        return this.base.getRoot();
    }

    public NutsPath walkDfs(NutsTreeVisitor<NutsPath> visitor, NutsPathOption ... options) {
        this.base.walkDfs(visitor, options);
        return this;
    }

    public NutsPath walkDfs(NutsTreeVisitor<NutsPath> visitor, int maxDepth, NutsPathOption ... options) {
        this.base.walkDfs(visitor, maxDepth, options);
        return this;
    }

    public NutsStream<NutsPath> walkGlob(NutsPathOption ... options) {
        return this.base.walkGlob(options);
    }

    public String toString() {
        return String.valueOf(this.compressedForm);
    }

    @Override
    public NutsFormat formatter() {
        return (NutsFormat)new MyPathFormat(this).setSession(this.getSession());
    }

    public NutsStreamMetadata getStreamMetadata() {
        return this.base.getStreamMetadata();
    }

    private static class MyPathFormat
    extends DefaultFormatBase<NutsFormat> {
        private final NutsCompressedPath p;

        public MyPathFormat(NutsCompressedPath p) {
            super(p.getSession(), "path");
            this.p = p;
        }

        public NutsString asFormattedString() {
            return NutsTexts.of((NutsSession)this.p.base.getSession()).ofStyled(this.p.compressedForm, NutsTextStyle.path());
        }

        @Override
        public void print(NutsPrintStream out) {
            out.print(this.asFormattedString());
        }

        public boolean configureFirst(NutsCommandLine commandLine) {
            return false;
        }

        public int getSupportLevel(NutsSupportLevelContext context) {
            return 10;
        }
    }
}

