/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStream;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;

public class DirectoryScanner {
    private NutsPath initialPattern;
    private PathPart[] parts;
    private NutsSession session;

    public DirectoryScanner(NutsPath pattern, NutsSession session) {
        this.initialPattern = pattern.toAbsolute().normalize();
        this.session = session;
        this.parts = DirectoryScanner.buildParts(this.initialPattern);
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static boolean containsWildcard(String name) {
        char[] patternChars;
        for (char c : patternChars = name.toCharArray()) {
            if (c != '*' && c != '?') continue;
            return true;
        }
        return false;
    }

    private static PathPart[] buildParts(NutsPath initialPattern) {
        ArrayList<PathPart> parts = new ArrayList<PathPart>();
        NutsPath h = initialPattern;
        while (h != null) {
            String name = h.getName();
            if (DirectoryScanner.containsWildcard(name)) {
                if (name.contains("**")) {
                    parts.add(0, new SubPathWildCardPathPart(name));
                } else {
                    parts.add(0, new NameWildCardPathPart(name));
                }
            } else {
                parts.add(0, new PlainPathPart(name));
            }
            NutsPath p = h.getParent();
            if (p == h) {
                h = null;
                continue;
            }
            h = p;
        }
        return parts.toArray(new PathPart[0]);
    }

    public String toString() {
        return this.initialPattern.toString();
    }

    public NutsPath[] toArray() {
        return (NutsPath[])this.stream().toArray(NutsPath[]::new);
    }

    public NutsStream<NutsPath> stream() {
        return this.stream(null, this.parts, 0);
    }

    private NutsStream<NutsPath> stream(NutsPath r, PathPart[] parts, int from) {
        for (int i = from; i < parts.length; ++i) {
            if (parts[i] instanceof PlainPathPart) {
                if (r == null) {
                    r = this.initialPattern.getRoot();
                }
                if ((r = r == null ? NutsPath.of((String)((PlainPathPart)parts[i]).value, (NutsSession)this.session) : r.resolve(((PlainPathPart)parts[i]).value)).exists()) continue;
                return NutsStream.ofEmpty((NutsSession)this.session);
            }
            if (parts[i] instanceof NameWildCardPathPart) {
                NameWildCardPathPart w = (NameWildCardPathPart)parts[i];
                if (r == null) {
                    r = this.initialPattern.getRoot();
                }
                if (r == null) {
                    return NutsStream.ofEmpty((NutsSession)this.session);
                }
                NutsStream t = r.list().filter(x -> w.matchesName(x.getName()), "getName");
                if (parts.length - i - 1 == 0) {
                    return t;
                }
                int i0 = i;
                NutsFunction f = NutsFunction.of(x -> this.stream((NutsPath)x, parts, i0 + 1), (String)"subStream");
                return t.flatMap(f);
            }
            if (parts[i] instanceof SubPathWildCardPathPart) {
                SubPathWildCardPathPart w = (SubPathWildCardPathPart)parts[i];
                if (r == null) {
                    r = this.initialPattern.getRoot();
                }
                NutsStream<NutsPath> t = new SubPathWildCardPathPartIterator(w, r).stream();
                if (parts.length - i - 1 == 0) {
                    return t;
                }
                int i0 = i;
                NutsFunction f = NutsFunction.of(x -> this.stream((NutsPath)x, parts, i0 + 1), (String)"subStream");
                return t.flatMap(f).distinct();
            }
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{parts[i]}));
        }
        if (r == null) {
            return NutsStream.ofSingleton((Object)this.initialPattern.getRoot(), (NutsSession)this.session);
        }
        return NutsStream.ofSingleton((Object)r, (NutsSession)this.session);
    }

    private class SubPathWildCardPathPartIterator
    implements Iterator<NutsPath> {
        private final Stack<NutsPath> stack = new Stack();
        private final SubPathWildCardPathPart w;
        NutsPath last;
        NutsPath root;

        public SubPathWildCardPathPartIterator(SubPathWildCardPathPart w, NutsPath root) {
            this.stack.push(root);
            this.w = w;
            this.root = root;
        }

        @Override
        public boolean hasNext() {
            this.last = this.next0();
            return this.last != null;
        }

        @Override
        public NutsPath next() {
            return this.last;
        }

        public NutsPath next0() {
            while (!this.stack.isEmpty()) {
                NutsPath pop = this.stack.pop();
                NutsPath[] t = (NutsPath[])pop.list().toArray(NutsPath[]::new);
                for (int i = t.length - 1; i >= 0; --i) {
                    this.stack.push(t[i]);
                }
                if (!this.w.matchesSubPath(pop.toRelativePath(this.root))) continue;
                return pop;
            }
            return null;
        }

        public NutsStream<NutsPath> stream() {
            return NutsStream.of((Iterator)this, (NutsSession)DirectoryScanner.this.session);
        }
    }

    private static class SubPathWildCardPathPart
    extends PathPart {
        String value;
        Pattern pattern;

        public SubPathWildCardPathPart(String value) {
            this.value = value;
            this.pattern = GlobUtils.glob(value, "/\\");
        }

        public boolean matchesSubPath(NutsPath subPath) {
            return this.pattern.matcher(subPath.toString()).matches();
        }

        public String toString() {
            return "Path{" + this.value + '}';
        }
    }

    private static class NameWildCardPathPart
    extends PathPart {
        String value;
        Pattern pattern;

        public NameWildCardPathPart(String value) {
            this.value = value;
            this.pattern = GlobUtils.glob(value, "/\\");
        }

        public boolean matchesName(String name) {
            return this.pattern.matcher(name).matches();
        }

        public String toString() {
            return "Name{" + this.value + '}';
        }
    }

    private static class PlainPathPart
    extends PathPart {
        String value;

        public PlainPathPart(String value) {
            this.value = value;
        }

        public String toString() {
            return "Plain{" + this.value + '}';
        }
    }

    private static class PathPart {
        private PathPart() {
        }
    }
}

