/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.path.NutsPathFromSPI;
import net.thevpc.nuts.runtime.standalone.io.path.spi.FilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigManager;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.spi.NutsPathFactory;
import net.thevpc.nuts.spi.NutsPathSPI;
import net.thevpc.nuts.spi.NutsPaths;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsPaths
implements NutsPaths {
    private final NutsWorkspace ws;

    public DefaultNutsPaths(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsPath createPath(String path, NutsSession session) {
        this.checkSession(session);
        return this.createPath(path, null, session);
    }

    public NutsPath createPath(File path, NutsSession session) {
        this.checkSession(session);
        if (path == null) {
            return null;
        }
        return this.createPath(new FilePath(path.toPath(), session), session);
    }

    public NutsPath createPath(Path path, NutsSession session) {
        this.checkSession(session);
        if (path == null) {
            return null;
        }
        return this.createPath(new FilePath(path, session), session);
    }

    public NutsPath createPath(URL path, NutsSession session) {
        this.checkSession(session);
        if (path == null) {
            return null;
        }
        return this.createPath(new URLPath(path, session), session);
    }

    public NutsPath createPath(String path, ClassLoader classLoader, NutsSession session) {
        this.checkSession(session);
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        NutsPath p = this.getModel(session).resolve(path, session, classLoader);
        if (p == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to resolve path from %s", (Object[])new Object[]{path}));
        }
        return p;
    }

    public NutsPath createPath(NutsPathSPI path, NutsSession session) {
        this.checkSession(session);
        if (path == null) {
            return null;
        }
        return new NutsPathFromSPI(path);
    }

    public NutsPaths addPathFactory(NutsPathFactory pathFactory, NutsSession session) {
        this.getModel(session).addPathFactory(pathFactory);
        return this;
    }

    public NutsPaths removePathFactory(NutsPathFactory pathFactory, NutsSession session) {
        this.getModel(session).removePathFactory(pathFactory);
        return this;
    }

    private void checkSession(NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
    }

    private DefaultNutsWorkspaceConfigModel getModel(NutsSession session) {
        return ((DefaultNutsWorkspaceConfigManager)session.config()).getModel();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

