/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.ask;

import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsQuestion;
import net.thevpc.nuts.NutsQuestionParser;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUserCancelException;
import net.thevpc.nuts.runtime.standalone.app.cmdline.DefaultNutsArgument;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;

public class DefaultNutsResponseParser<T>
implements NutsQuestionParser<T> {
    private final NutsSession session;
    private final Class<T> type;

    public DefaultNutsResponseParser(NutsSession session, Class<T> type) {
        this.session = session;
        this.type = type;
    }

    public T parse(Object response, T defaultValue, NutsQuestion<T> question) {
        if (response == null || response instanceof String && response.toString().length() == 0) {
            response = defaultValue;
        }
        if ("cancel!".equals(response)) {
            throw new NutsUserCancelException(this.session);
        }
        if (response == null) {
            return null;
        }
        if (this.type.isInstance(response)) {
            return (T)response;
        }
        if (this.type.isEnum()) {
            String s = String.valueOf(response).trim();
            return CoreEnumUtils.parseEnumString(s, this.type, false);
        }
        switch (this.type.getName()) {
            case "java.lang.String": {
                return (T)String.valueOf(response);
            }
            case "int": 
            case "java.lang.Integer": {
                return (T)Integer.valueOf(Integer.parseInt(String.valueOf(response)));
            }
            case "long": 
            case "java.lang.Long": {
                return (T)Long.valueOf(Long.parseLong(String.valueOf(response)));
            }
            case "float": 
            case "java.lang.Float": {
                return (T)Float.valueOf(Float.parseFloat(String.valueOf(response)));
            }
            case "double": 
            case "java.lang.Double": {
                return (T)Double.valueOf(Double.parseDouble(String.valueOf(response)));
            }
            case "boolean": 
            case "java.lang.Boolean": {
                String sReponse;
                DefaultNutsArgument a;
                if (!(response instanceof String)) {
                    response = String.valueOf(response);
                }
                if (!(a = new DefaultNutsArgument(sReponse = response.toString(), '=', NutsElements.of((NutsSession)this.session))).toElement().isBoolean()) {
                    throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"invalid response %s", (Object[])new Object[]{sReponse}));
                }
                return (T)Boolean.valueOf(a.toElement().getBoolean());
            }
        }
        throw new NutsUnsupportedArgumentException(this.session, NutsMessage.cstyle((String)"unsupported type %s", (Object[])new Object[]{this.type.getName()}));
    }
}

