/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;

public class SimpleHttpClient {
    private URL url;
    private long timeout = -1L;
    private boolean headerRead = false;
    private long contentLength;
    private String contentType;
    private String contentEncoding;
    private Instant lastModified;
    private int connectTimeout = 5000;
    private int readTimeout = 5000;
    private NutsSession session;

    public SimpleHttpClient(URL url, NutsSession session) {
        this.url = url;
        this.session = session;
    }

    public SimpleHttpClient(String url, NutsSession session) {
        try {
            this.url = new URL(url);
            this.session = session;
        }
        catch (MalformedURLException e) {
            throw new NutsIOException(session, (Throwable)e);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public SimpleHttpClient setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    private void tryReadHeader() {
        if (!this.headerRead) {
            this.readHeader();
            this.headerRead = true;
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public SimpleHttpClient setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public SimpleHttpClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    private void readHeader() {
        NutsPath info = NutsPath.of((URL)this.url, (NutsSession)this.session);
        this.contentEncoding = info.getContentEncoding();
        this.contentType = info.getContentType();
        this.contentLength = info.getContentLength();
        this.lastModified = info.getLastModifiedInstant();
    }

    public long getContentLength() {
        this.tryReadHeader();
        return this.contentLength;
    }

    public String getContentType() {
        this.tryReadHeader();
        return this.contentType;
    }

    public String getContentEncoding() {
        this.tryReadHeader();
        return this.contentEncoding;
    }

    public Instant getLastModifiedInstant() {
        this.tryReadHeader();
        return this.lastModified;
    }

    public URL getURL() {
        return this.url;
    }

    public URLConnection prepareConnection() {
        try {
            URLConnection conn = null;
            conn = this.url.openConnection();
            if (this.connectTimeout > 0 || this.readTimeout > 0) {
                if (this.connectTimeout > 0) {
                    conn.setConnectTimeout(this.connectTimeout);
                }
                if (this.readTimeout > 0) {
                    conn.setReadTimeout(this.readTimeout);
                }
            }
            return conn;
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }

    public InputStream openStream() {
        try {
            if (this.connectTimeout > 0 || this.readTimeout > 0) {
                URLConnection conn = this.prepareConnection();
                return conn.getInputStream();
            }
            return this.url.openStream();
        }
        catch (IOException ex) {
            throw new NutsIOException(this.session, (Throwable)ex);
        }
    }
}

