/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.installer;

import java.io.IOException;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.io.util.UnzipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsInstallerComponent;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class ZipInstallerComponent
implements NutsInstallerComponent {
    public int getSupportLevel(NutsSupportLevelContext ctx) {
        NutsDefinition def = (NutsDefinition)ctx.getConstraints(NutsDefinition.class);
        if (def != null && def.getDescriptor() != null && "zip".equals(def.getDescriptor().getPackaging())) {
            return 10;
        }
        return -1;
    }

    public void install(NutsExecutionContext executionContext) {
        DefaultNutsDefinition nutsDefinition = (DefaultNutsDefinition)executionContext.getDefinition();
        NutsPath installFolder = executionContext.getSession().locations().getStoreLocation(nutsDefinition.getId(), NutsStoreLocation.APPS);
        String skipRoot = (String)executionContext.getExecutorProperties().get("unzip-skip-root");
        try {
            ZipUtils.unzip(executionContext.getSession(), nutsDefinition.getFile().toString(), installFolder.toString(), new UnzipOptions().setSkipRoot("true".equalsIgnoreCase(skipRoot)));
        }
        catch (IOException ex) {
            throw new NutsIOException(executionContext.getSession(), (Throwable)ex);
        }
        nutsDefinition.setInstallInformation(NutsWorkspaceExt.of(executionContext.getSession()).getInstalledRepository().getInstallInformation(nutsDefinition.getId(), executionContext.getExecSession()));
        if (executionContext.getExecutorArguments().length > 0) {
            executionContext.getSession().exec().addCommand(executionContext.getExecutorArguments()).setSession(executionContext.getExecSession()).setEnv(executionContext.getExecutorProperties()).setDirectory(installFolder.toString()).getResult();
        }
    }

    public void update(NutsExecutionContext executionContext) {
    }

    public void uninstall(NutsExecutionContext executionContext, boolean deleteData) {
    }
}

