/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.installer;

import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionEntries;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIterator;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsInstallerComponent;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class CommandForIdNutsInstallerComponent
implements NutsInstallerComponent {
    private String getNutsVersion(NutsExecutionContext executionContext) {
        NutsDescriptor descriptor = executionContext.getDefinition().getDescriptor();
        if (descriptor.isApplication()) {
            for (NutsIterator dependency : descriptor.getDependencies()) {
                if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
                return dependency.toId().getVersion().getValue();
            }
        }
        for (NutsDependency dependency : executionContext.getDefinition().getDependencies()) {
            if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
            return dependency.toId().getVersion().getValue();
        }
        return null;
    }

    public void install(NutsExecutionContext executionContext) {
        NutsWorkspaceUtils.of(executionContext.getSession()).checkReadOnly();
        NutsDescriptor descriptor = executionContext.getDefinition().getDescriptor();
        if (descriptor.isApplication()) {
            DefaultNutsDefinition def2 = new DefaultNutsDefinition(executionContext.getDefinition(), executionContext.getSession()).setInstallInformation(new DefaultNutsInstallInfo(executionContext.getDefinition().getInstallInformation()).setInstallStatus(executionContext.getDefinition().getInstallInformation().getInstallStatus().withInstalled(true)));
            executionContext.getSession().exec().setSession(executionContext.getExecSession()).setCommand((NutsDefinition)def2).addCommand(new String[]{"--nuts-exec-mode=install"}).addExecutorOptions(new String[]{"--nuts-auto-install=false"}).addCommand(executionContext.getArguments()).setExecutionType(executionContext.getSession().boot().getBootOptions().getExecutionType()).setFailFast(true).run();
        }
    }

    public void update(NutsExecutionContext executionContext) {
        NutsWorkspaceUtils.of(executionContext.getSession()).checkReadOnly();
        NutsDescriptor descriptor = executionContext.getDefinition().getDescriptor();
        if (descriptor.isApplication()) {
            DefaultNutsDefinition def2 = new DefaultNutsDefinition(executionContext.getDefinition(), executionContext.getSession()).setInstallInformation(new DefaultNutsInstallInfo(executionContext.getDefinition().getInstallInformation()).setInstallStatus(executionContext.getDefinition().getInstallInformation().getInstallStatus().withInstalled(true)));
            executionContext.getSession().exec().setCommand((NutsDefinition)def2).addCommand(new String[]{"--nuts-exec-mode=update", "--yes"}).addExecutorOptions(new String[0]).addCommand(executionContext.getArguments()).setFailFast(true).run();
        }
    }

    public void uninstall(NutsExecutionContext executionContext, boolean deleteData) {
        NutsSession session = executionContext.getExecSession();
        NutsWorkspaceUtils.of(executionContext.getSession()).checkReadOnly();
        NutsId id = executionContext.getDefinition().getId();
        if ("jar".equals(executionContext.getDefinition().getDescriptor().getPackaging())) {
            NutsExecutionEntry[] executionEntries;
            for (NutsExecutionEntry executionEntry : executionEntries = NutsExecutionEntries.of((NutsSession)session).parse(executionContext.getDefinition().getFile())) {
                if (!executionEntry.isApp()) continue;
                int r = session.exec().addCommand(new String[]{id.getLongName(), "--nuts-exec-mode=uninstall", "--yes"}).addCommand(executionContext.getArguments()).getResult();
                if (r != 0) {
                    session.out().printf((Object)("installation exited with code : " + r + " %n"));
                }
                return;
            }
        }
    }

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        return 10;
    }
}

