/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.util;

import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigApi;

public class NutsIdUtils {
    public static void checkValidEffectiveId(NutsId id, NutsSession session) {
        if (id == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to evaluate effective null id", (Object[])new Object[0]));
        }
        if (id.toString().contains("${")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to evaluate effective id %s", (Object[])new Object[]{id}));
        }
    }

    public static NutsId createContentFaceId(NutsId id, NutsDescriptor desc, NutsSession session) {
        Map q = id.getProperties();
        q.put("packaging", NutsUtilStrings.trim((String)desc.getPackaging()));
        q.put("face", "content");
        return id.builder().setProperties(q).build();
    }

    public static String getPath(NutsId id, String ext, char sep) {
        StringBuilder sb = new StringBuilder();
        sb.append(id.getGroupId().replace('.', sep));
        sb.append(sep);
        sb.append(id.getArtifactId());
        sb.append(sep);
        sb.append(id.getVersion().toString());
        sb.append(sep);
        String name = id.getArtifactId() + "-" + id.getVersion().getValue();
        sb.append(name);
        sb.append(ext);
        return sb.toString();
    }

    public static boolean isApiId(NutsId id) {
        return "net.thevpc.nuts:nuts".equals(id.getShortName());
    }

    public static boolean isRuntimeId(NutsId id) {
        return "net.thevpc.nuts:nuts-runtime".equals(id.getShortName());
    }

    public static NutsId apiId(String apiVersion, NutsSession session) {
        if (NutsBlankable.isBlank((String)apiVersion)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid version", (Object[])new Object[0]));
        }
        if (apiVersion.equals(session.getWorkspace().getApiVersion().toString())) {
            return session.getWorkspace().getApiId();
        }
        return NutsId.of((String)("net.thevpc.nuts:nuts#" + apiVersion), (NutsSession)session);
    }

    public static NutsId runtimeId(String runtimeVersion, NutsSession session) {
        if (NutsBlankable.isBlank((String)runtimeVersion)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid version", (Object[])new Object[0]));
        }
        if (runtimeVersion.equals(session.getWorkspace().getApiVersion().toString())) {
            return session.getWorkspace().getApiId();
        }
        return NutsId.of((String)("net.thevpc.nuts:nuts-runtime#" + runtimeVersion), (NutsSession)session);
    }

    public static NutsId findRuntimeForApi(String apiVersion, NutsSession session) {
        NutsWorkspaceConfigApi c;
        if (NutsBlankable.isBlank((String)apiVersion)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid version", (Object[])new Object[0]));
        }
        if (apiVersion.equals(session.getWorkspace().getApiVersion().toString())) {
            return session.getWorkspace().getRuntimeId();
        }
        NutsPath apiBoot = session.locations().getStoreLocation(NutsIdUtils.apiId(apiVersion, session), NutsStoreLocation.CONFIG).resolve("nuts-api-boot-config.json");
        if (apiBoot.isRegularFile() && !NutsBlankable.isBlank((String)(c = (NutsWorkspaceConfigApi)((Object)NutsElements.of((NutsSession)session).setSession(session).json().parse(apiBoot, NutsWorkspaceConfigApi.class))).getRuntimeId())) {
            return NutsId.of((String)c.getRuntimeId(), (NutsSession)session);
        }
        NutsId foundRT = (NutsId)session.search().addId("net.thevpc.nuts:nuts-runtime").setLatest(true).setTargetApiVersion(NutsVersion.of((String)apiVersion, (NutsSession)session)).setSession(session.copy().setFetchStrategy(NutsFetchStrategy.OFFLINE)).getResultIds().first();
        if (foundRT == null && session.getFetchStrategy() != NutsFetchStrategy.OFFLINE) {
            foundRT = (NutsId)session.search().addId("net.thevpc.nuts:nuts-runtime").setLatest(true).setTargetApiVersion(NutsVersion.of((String)apiVersion, (NutsSession)session)).setSession(session).getResultIds().first();
        }
        return foundRT;
    }
}

