/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.format;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyleType;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.dependency.NutsDependencyScopes;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.QueryStringParser;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringMapParser;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsIdFormat
extends DefaultFormatBase<NutsIdFormat>
implements NutsIdFormat {
    private boolean omitRepository;
    private boolean omitGroup;
    private boolean omitImportedGroup;
    private boolean omitProperties;
    private boolean highlightImportedGroup;
    private Set<String> omittedProperties = new HashSet<String>();
    private NutsId id;

    public DefaultNutsIdFormat(NutsSession session) {
        super(session, "id-format");
    }

    @Override
    public NutsIdFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    public boolean isOmitRepository() {
        return this.omitRepository;
    }

    public NutsIdFormat setOmitRepository(boolean value) {
        this.omitRepository = value;
        return this;
    }

    public boolean isOmitGroupId() {
        return this.omitGroup;
    }

    public NutsIdFormat setOmitGroupId(boolean value) {
        this.omitGroup = value;
        return this;
    }

    public boolean isOmitImportedGroupId() {
        return this.omitImportedGroup;
    }

    public NutsIdFormat setOmitImportedGroupId(boolean value) {
        this.omitImportedGroup = value;
        return this;
    }

    public boolean isOmitOtherProperties() {
        return this.omitProperties;
    }

    public NutsIdFormat setOmitOtherProperties(boolean value) {
        this.omitProperties = value;
        return this;
    }

    public boolean isOmitFace() {
        return this.isOmitProperty("face");
    }

    public NutsIdFormat setOmitFace(boolean value) {
        return this.setOmitProperty("face", value);
    }

    public boolean isHighlightImportedGroupId() {
        return this.highlightImportedGroup;
    }

    public NutsIdFormat setHighlightImportedGroupId(boolean value) {
        this.highlightImportedGroup = value;
        return this;
    }

    public boolean isOmitClassifier() {
        return this.isOmitProperty("classifier");
    }

    public NutsIdFormat setOmitClassifier(boolean value) {
        return this.setOmitProperty("classifier", value);
    }

    public String[] getOmitProperties() {
        return this.omittedProperties.toArray(new String[0]);
    }

    public boolean isOmitProperty(String name) {
        return this.omittedProperties.contains(name);
    }

    public NutsIdFormat setOmitProperty(String name, boolean value) {
        if (value) {
            this.omittedProperties.add(name);
        } else {
            this.omittedProperties.remove(name);
        }
        return this;
    }

    public NutsId getValue() {
        return this.id;
    }

    public NutsIdFormat setValue(NutsId id) {
        this.id = id;
        return this;
    }

    @Override
    public NutsString format() {
        this.checkSession();
        if (this.id == null) {
            return this.isNtf() ? NutsTexts.of((NutsSession)this.getSession()).ofStyled("<null>", NutsTextStyle.of((NutsTextStyleType)NutsTextStyleType.BOOLEAN)) : NutsTexts.of((NutsSession)this.getSession()).ofPlain("<null>");
        }
        Map queryMap = this.id.getProperties();
        String scope = (String)queryMap.remove("scope");
        String optional = (String)queryMap.remove("optional");
        String classifier = (String)queryMap.remove("classifier");
        String exclusions = (String)queryMap.remove("exclusions");
        String repo = (String)queryMap.remove("repo");
        NutsIdBuilder idBuilder = this.id.builder();
        if (this.isOmitOtherProperties()) {
            idBuilder.setProperties(new LinkedHashMap());
        }
        if (this.isOmitFace()) {
            idBuilder.setProperty("face", null);
        }
        this.id = idBuilder.build();
        NutsTextBuilder sb = NutsTexts.of((NutsSession)this.getSession()).builder();
        if (!this.isOmitGroupId() && !NutsBlankable.isBlank((String)this.id.getGroupId())) {
            boolean importedGroup2 = "net.thevpc.nuts".equals(this.id.getGroupId());
            boolean importedGroup = this.getSession().imports().getAllImports().contains(this.id.getGroupId());
            if (!importedGroup || !this.isOmitImportedGroupId()) {
                if (importedGroup || importedGroup2) {
                    sb.append((Object)this.id.getGroupId(), NutsTextStyle.pale());
                } else {
                    sb.append((Object)this.id.getGroupId());
                }
                sb.append((Object)":", NutsTextStyle.separator());
            }
        }
        sb.append((Object)this.id.getArtifactId(), NutsTextStyle.primary1());
        if (!NutsBlankable.isBlank((String)this.id.getVersion().getValue())) {
            sb.append((Object)"#", NutsTextStyle.separator());
            sb.append((Object)this.id.getVersion());
        }
        boolean firstQ = true;
        if (!NutsBlankable.isBlank((String)classifier)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"classifier", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)this._encode(classifier));
        }
        if (!NutsDependencyScopes.isDefaultScope(scope)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"scope", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)this._encode(scope));
        }
        if (!NutsBlankable.isBlank((String)optional) && !"false".equalsIgnoreCase(optional)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"optional", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)this._encode(optional));
        }
        if (!this.isOmitRepository() && !NutsBlankable.isBlank((String)this.id.getRepository())) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"repo", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)this._encode(this.id.getRepository()), NutsTextStyle.pale());
        }
        for (Map.Entry<String, String> e : CoreFilterUtils.toMap(this.id.getCondition()).entrySet()) {
            String kk = e.getKey();
            String kv = e.getValue();
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)this._encode(kk), NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)this._encode(kv));
        }
        if (!NutsBlankable.isBlank((String)exclusions)) {
            if (firstQ) {
                sb.append((Object)"?", NutsTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NutsTextStyle.separator());
            }
            sb.append((Object)"exclusions", NutsTextStyle.keyword((int)2)).append((Object)"=", NutsTextStyle.separator());
            sb.append((Object)this._encode(exclusions), NutsTextStyle.warn());
        }
        if (!NutsBlankable.isBlank((String)this.id.getPropertiesQuery())) {
            TreeSet otherKeys = new TreeSet(queryMap.keySet());
            for (String k : otherKeys) {
                String v2 = (String)queryMap.get(k);
                if (v2 == null) continue;
                if (firstQ) {
                    sb.append((Object)"?", NutsTextStyle.separator());
                    firstQ = false;
                } else {
                    sb.append((Object)"&", NutsTextStyle.separator());
                }
                sb.append((Object)k, NutsTextStyle.pale());
                sb.append((Object)"=", NutsTextStyle.separator());
                sb.append((Object)this._encode(v2));
            }
        }
        if (this.isNtf()) {
            return sb.immutable();
        }
        return NutsTexts.of((NutsSession)this.getSession()).ofPlain(sb.filteredText());
    }

    private String _encode(String s) {
        return QueryStringParser.QPARSER.encode(s, false, StringMapParser.QuoteType.SIMPLE);
    }

    @Override
    public void print(NutsPrintStream out) {
        out.print(this.format());
    }

    @Override
    public String toString() {
        return "NutsIdFormat{omitRepository=" + this.omitRepository + ", omitGroup=" + this.omitGroup + ", omitImportedGroup=" + this.omitImportedGroup + ", omitProperties=" + this.omitProperties + ", highlightImportedGroup=" + this.highlightImportedGroup + ", omittedProperties=" + this.omittedProperties + ", id=" + this.id + '}';
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--omit-env": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitOtherProperties(val);
                }
                return true;
            }
            case "--omit-face": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitFace(val);
                }
                return true;
            }
            case "--omit-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitGroupId(val);
                }
                return true;
            }
            case "--omit-imported-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitImportedGroupId(val);
                }
                return true;
            }
            case "--omit-repo": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitRepository(val);
                }
                return true;
            }
            case "--highlight-imported-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setHighlightImportedGroupId(val);
                }
                return true;
            }
        }
        return false;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

