/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.AbstractIdFilter;
import net.thevpc.nuts.runtime.standalone.util.Simplifiable;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutstVersionIdFilter
extends AbstractIdFilter
implements NutsIdFilter,
Simplifiable<NutsIdFilter> {
    private final NutsVersionFilter filter;

    public NutstVersionIdFilter(NutsVersionFilter filter, NutsSession session) {
        super(session, NutsFilterOp.CONVERT);
        this.filter = filter;
    }

    public boolean acceptSearchId(NutsSearchId sid, NutsSession session) {
        return this.filter == null ? true : this.filter.acceptSearchId(sid, session);
    }

    public boolean acceptId(NutsId other, NutsSession session) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.acceptVersion(other.getVersion(), session);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.filter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutstVersionIdFilter other = (NutstVersionIdFilter)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public NutsIdFilter simplify() {
        NutsVersionFilter f2 = CoreFilterUtils.simplify(this.filter);
        if (f2 == null) {
            return null;
        }
        if (f2 == this.filter) {
            return this;
        }
        return new NutstVersionIdFilter(f2, this.getSession());
    }

    public String toString() {
        return String.valueOf(this.filter);
    }
}

