/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.id.filter.AbstractIdFilter;
import net.thevpc.nuts.runtime.standalone.util.Simplifiable;

public class NutsIdIdFilter
extends AbstractIdFilter
implements NutsIdFilter,
Simplifiable<NutsIdFilter> {
    private NutsLogger LOG;
    private final NutsId filter;

    public NutsIdIdFilter(NutsId filter, NutsSession session) {
        super(session, NutsFilterOp.CUSTOM);
        this.filter = filter;
    }

    public boolean acceptSearchId(NutsSearchId sid, NutsSession session) {
        return this.filter == null || this.acceptId(sid.getId(session), session);
    }

    public boolean acceptId(NutsId id, NutsSession session) {
        if (this.filter == null) {
            return true;
        }
        if (this.LOG == null) {
            this.LOG = NutsLogger.of(NutsIdIdFilter.class, (NutsSession)session);
        }
        if (id.getShortName().equals(this.filter.getShortName())) {
            if (!this.filter.getVersion().filter().acceptVersion(id.getVersion(), session)) {
                return false;
            }
            Map e = this.filter.getProperties();
            Map m = id.getProperties();
            for (Map.Entry v : e.entrySet()) {
                if (Objects.equals(v.getValue(), m.get(v.getKey()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.filter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsIdIdFilter other = (NutsIdIdFilter)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public NutsIdFilter simplify() {
        if (this.filter == null) {
            return null;
        }
        return this;
    }

    public String toString() {
        return String.valueOf(this.filter);
    }
}

