/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.id.filter.AbstractIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsExprIdFilter;
import net.thevpc.nuts.runtime.standalone.util.Simplifiable;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsIdFilterAnd
extends AbstractIdFilter
implements NutsIdFilter,
Simplifiable<NutsIdFilter>,
NutsExprIdFilter {
    private NutsIdFilter[] children;

    public NutsIdFilterAnd(NutsSession session, NutsIdFilter ... all) {
        super(session, NutsFilterOp.AND);
        ArrayList<NutsIdFilter> valid = new ArrayList<NutsIdFilter>();
        if (all != null) {
            for (NutsIdFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.children = valid.toArray(new NutsIdFilter[0]);
    }

    public NutsIdFilter[] getChildren() {
        return Arrays.copyOf(this.children, this.children.length);
    }

    public boolean acceptId(NutsId id, NutsSession session) {
        if (this.children.length == 0) {
            return true;
        }
        for (NutsIdFilter filter : this.children) {
            if (filter.acceptId(id, session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsIdFilter simplify() {
        return CoreFilterUtils.simplifyFilterAnd(this.getSession(), NutsIdFilter.class, this, (NutsFilter[])this.children);
    }

    @Override
    public String toExpr() {
        StringBuilder sb = new StringBuilder();
        if (this.children.length == 0) {
            return "true";
        }
        if (this.children.length > 1) {
            sb.append("(");
        }
        for (NutsIdFilter id : this.children) {
            String expr;
            if (sb.length() > 0) {
                sb.append(" && ");
            }
            if (id instanceof NutsExprIdFilter) {
                NutsExprIdFilter b = (NutsExprIdFilter)id;
                expr = b.toExpr();
                if (NutsBlankable.isBlank((String)expr)) {
                    return null;
                }
            } else {
                return null;
            }
            sb.append("(").append(expr).append("')");
        }
        if (this.children.length > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return String.join((CharSequence)" and ", Arrays.asList(this.children).stream().map(x -> "(" + x.toString() + ")").collect(Collectors.toList()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Arrays.deepHashCode(this.children);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsIdFilterAnd other = (NutsIdFilterAnd)obj;
        return Arrays.deepEquals(this.children, other.children);
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return this.children;
    }
}

