/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;

public class NutsExecExtensionFilter
extends AbstractDescriptorFilter {
    private NutsId apiId;

    public NutsExecExtensionFilter(NutsSession session, NutsId apiId) {
        super(session, NutsFilterOp.CUSTOM);
        this.apiId = apiId;
    }

    public boolean acceptDescriptor(NutsDescriptor other, NutsSession session) {
        if (other.getIdType() != NutsIdType.EXTENSION) {
            return false;
        }
        for (NutsDependency dependency : other.getDependencies()) {
            if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
            if (this.apiId == null) {
                return true;
            }
            return this.apiId.getVersion().equals(dependency.toId().getVersion());
        }
        return false;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }

    public String toString() {
        if (this.apiId == null) {
            return "extension";
        }
        return "extension(" + this.apiId.getVersion() + ")";
    }
}

