/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.Objects;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.id.filter.AbstractIdFilter;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.Simplifiable;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;

public class NutsDescriptorIdFilter
extends AbstractIdFilter
implements NutsIdFilter,
Simplifiable<NutsIdFilter> {
    private NutsLogger LOG;
    private final NutsDescriptorFilter filter;

    public NutsDescriptorIdFilter(NutsDescriptorFilter filter, NutsSession session) {
        super(session, NutsFilterOp.CONVERT);
        this.filter = filter;
    }

    public boolean acceptSearchId(NutsSearchId sid, NutsSession session) {
        return this.filter == null ? true : this.filter.acceptSearchId(sid, session);
    }

    public boolean acceptId(NutsId id, NutsSession session) {
        NutsDescriptor descriptor;
        block7: {
            if (this.filter == null) {
                return true;
            }
            if (this.LOG == null) {
                this.LOG = NutsLogger.of(MavenRepositoryFolderHelper.class, (NutsSession)session);
            }
            descriptor = null;
            try {
                descriptor = session.fetch().setId(id).setSession(session).getResultDescriptor();
                if (CoreNutsUtils.isEffectiveId(descriptor.getId())) break block7;
                NutsDescriptor nutsDescriptor = null;
                try {
                    nutsDescriptor = NutsWorkspaceExt.of(session.getWorkspace()).resolveEffectiveDescriptor(descriptor, session);
                }
                catch (Exception ex) {
                    this.LOG.with().session(session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to resolve effective desc {0} for {1}", (Object[])new Object[]{descriptor.getId(), id}));
                }
                descriptor = nutsDescriptor;
            }
            catch (Exception ex) {
                if (this.LOG.isLoggable(Level.FINER)) {
                    this.LOG.with().session(session).level(Level.FINER).verb(NutsLogVerb.FAIL).log(NutsMessage.jstyle((String)"unable to fetch descriptor for {0} : {1}", (Object[])new Object[]{id, ex}));
                }
                return false;
            }
        }
        return this.filter.acceptDescriptor(descriptor, session);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.filter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorIdFilter other = (NutsDescriptorIdFilter)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public NutsIdFilter simplify() {
        NutsDescriptorFilter f2 = CoreFilterUtils.simplify(this.filter);
        if (f2 == null) {
            return null;
        }
        if (f2 == this.filter) {
            return this;
        }
        return new NutsDescriptorIdFilter(f2, this.getSession());
    }

    public String toString() {
        return String.valueOf(this.filter);
    }
}

