/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;

public class NutsDescriptorFlagsIdFilter
extends AbstractDescriptorFilter {
    private final Set<NutsDescriptorFlag> flags = new LinkedHashSet<NutsDescriptorFlag>();

    public NutsDescriptorFlagsIdFilter(NutsSession session, NutsDescriptorFlag ... flags) {
        super(session, NutsFilterOp.CUSTOM);
        for (NutsDescriptorFlag flag : flags) {
            if (flag == null) continue;
            this.flags.add(flag);
        }
    }

    public boolean acceptDescriptor(NutsDescriptor other, NutsSession session) {
        Set available = other.getFlags();
        for (NutsDescriptorFlag flag : this.flags) {
            if (available.contains(flag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (this.flags.isEmpty()) {
            return null;
        }
        return this;
    }

    public String toString() {
        if (this.flags.isEmpty()) {
            return "any";
        }
        if (this.flags.size() == 1) {
            return "hasFlag(" + this.flags.toArray(new NutsDescriptorFlag[0])[0].id() + ")";
        }
        return "hasFlags(" + this.flags.stream().map(NutsDescriptorFlag::id).collect(Collectors.joining(",")) + ")";
    }
}

