/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.List;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFilters;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsDefaultVersionIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsDescriptorIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterAnd;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterFalse;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterNone;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterOr;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterParser;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdFilterTrue;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsPatternIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutstVersionIdFilter;
import net.thevpc.nuts.runtime.standalone.io.util.NutsInstallStatusIdFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class InternalNutsIdFilters
extends InternalNutsTypedFilters<NutsIdFilter>
implements NutsIdFilters {
    public InternalNutsIdFilters(NutsSession session) {
        super(session, NutsIdFilter.class);
    }

    public NutsIdFilter always() {
        this.checkSession();
        return new NutsIdFilterTrue(this.getSession());
    }

    public NutsIdFilter not(NutsFilter other) {
        return new NutsIdFilterNone(this.getSession(), (NutsIdFilter)other);
    }

    public NutsIdFilter never() {
        this.checkSession();
        return new NutsIdFilterFalse(this.getSession());
    }

    public NutsIdFilter byDefaultVersion(Boolean defaultVersion) {
        if (defaultVersion == null) {
            return this.always();
        }
        return new NutsDefaultVersionIdFilter(this.getSession(), defaultVersion);
    }

    public NutsIdFilter byInstallStatus(NutsInstallStatusFilter installStatus) {
        return new NutsInstallStatusIdFilter(this.getSession(), installStatus);
    }

    public NutsIdFilter byName(String ... names) {
        this.checkSession();
        if (names == null || names.length == 0) {
            return this.always();
        }
        NutsPatternIdFilter f = null;
        for (String wildcardId : names) {
            f = f == null ? new NutsPatternIdFilter(this.getSession(), NutsId.of((String)wildcardId, (NutsSession)this.getSession())) : f.or(new NutsPatternIdFilter(this.getSession(), NutsId.of((String)wildcardId, (NutsSession)this.getSession())));
        }
        return f;
    }

    public NutsIdFilter as(NutsFilter a) {
        this.checkSession();
        if (a instanceof NutsIdFilter) {
            return (NutsIdFilter)a;
        }
        if (a instanceof NutsDescriptorFilter) {
            return new NutsDescriptorIdFilter((NutsDescriptorFilter)a, this.getSession());
        }
        if (a instanceof NutsVersionFilter) {
            return new NutstVersionIdFilter((NutsVersionFilter)a, this.getSession());
        }
        return null;
    }

    public NutsIdFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsIdFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a IdFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsIdFilter all(NutsFilter ... others) {
        List<NutsIdFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsIdFilter)all.get(0);
        }
        return new NutsIdFilterAnd(this.getSession(), all.toArray(new NutsIdFilter[0]));
    }

    public NutsIdFilter any(NutsFilter ... others) {
        List<NutsIdFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsIdFilter)all.get(0);
        }
        return new NutsIdFilterOr(this.getSession(), all.toArray(new NutsIdFilter[0]));
    }

    public NutsIdFilter none(NutsFilter ... others) {
        List<NutsIdFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsIdFilterNone(this.getSession(), all.toArray(new NutsIdFilter[0]));
    }

    public NutsIdFilter parse(String expression) {
        return (NutsIdFilter)new NutsIdFilterParser(expression, this.getSession()).parse();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

