/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;

public class BootAPINutsDescriptorFilter
extends AbstractDescriptorFilter {
    private final NutsVersion bootApiVersion;

    public BootAPINutsDescriptorFilter(NutsSession session, NutsVersion bootApiVersion) {
        super(session, NutsFilterOp.CUSTOM);
        this.bootApiVersion = bootApiVersion;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        for (NutsDependency dependency : descriptor.getDependencies()) {
            if (!dependency.getSimpleName().equals("net.thevpc.nuts:nuts")) continue;
            return this.bootApiVersion.filter().acceptVersion(dependency.getVersion(), session);
        }
        return false;
    }

    public String toString() {
        return "BootAPI(" + this.bootApiVersion + ')';
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return this;
    }
}

