/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsIdParser
implements NutsIdParser {
    public static final Pattern NUTS_ID_PATTERN = Pattern.compile("^(?<group>[a-zA-Z0-9_.${}*-]+)(:(?<artifact>[a-zA-Z0-9_.${}*-]+))?(#(?<version>[^?]+))?(\\?(?<query>.+))?$");
    private NutsSession session;
    private boolean lenient = false;
    private boolean acceptBlank = true;

    public DefaultNutsIdParser(NutsSession session) {
        this.session = session;
    }

    public boolean isAcceptBlank() {
        return this.acceptBlank;
    }

    public NutsIdParser setAcceptBlank(boolean acceptBlank) {
        this.acceptBlank = acceptBlank;
        return this;
    }

    public NutsIdParser setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsId parse(String nutsId) {
        if (NutsBlankable.isBlank((String)nutsId)) {
            if (this.isAcceptBlank()) {
                return null;
            }
            throw new NutsParseException(this.session, NutsMessage.plain((String)"blank id"));
        }
        Matcher m = NUTS_ID_PATTERN.matcher(nutsId);
        if (m.find()) {
            NutsIdBuilder builder = NutsIdBuilder.of((NutsSession)this.session);
            String group = m.group("group");
            String artifact = m.group("artifact");
            builder.setArtifactId(artifact);
            builder.setVersion(m.group("version"));
            builder.setProperties(m.group("query"));
            if (artifact == null) {
                artifact = group;
                group = null;
            }
            builder.setArtifactId(artifact);
            builder.setGroupId(group);
            return builder.build();
        }
        if (!this.isLenient()) {
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"invalid id format : %s", (Object[])new Object[]{nutsId}));
        }
        return null;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

