/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.id.DefaultNutsId;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.QueryStringParser;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsIdBuilder
implements NutsIdBuilder {
    private transient NutsSession session;
    private String groupId;
    private String artifactId;
    private String classifier;
    private NutsVersion version;
    private NutsEnvConditionBuilder condition;
    private transient QueryStringParser propertiesQuery = new QueryStringParser(true, (name, value) -> {
        if (name != null) {
            switch (name) {
                case "version": {
                    this.setVersion(value);
                    return true;
                }
                case "classifier": {
                    this.setClassifier(value);
                    return true;
                }
                case "os": {
                    this.condition.setOs(CoreStringUtils.parseAndTrimToDistinctArray(value));
                    return true;
                }
                case "arch": {
                    this.condition.setArch(CoreStringUtils.parseAndTrimToDistinctArray(value));
                    return true;
                }
                case "platform": {
                    this.condition.setPlatform(CoreStringUtils.parseAndTrimToDistinctArray(value));
                    return true;
                }
                case "osdist": {
                    this.condition.setOsDist(CoreStringUtils.parseAndTrimToDistinctArray(value));
                    return true;
                }
                case "desktop": {
                    this.condition.setDesktopEnvironment(CoreStringUtils.parseAndTrimToDistinctArray(value));
                    return true;
                }
            }
        }
        return false;
    });

    public DefaultNutsIdBuilder(NutsSession session) {
        this.session = session;
        this.condition = NutsEnvConditionBuilder.of((NutsSession)session);
    }

    public DefaultNutsIdBuilder(NutsId id, NutsSession session) {
        this.session = session;
        this.condition = NutsEnvConditionBuilder.of((NutsSession)session);
        this.setGroupId(id.getGroupId());
        this.setArtifactId(id.getArtifactId());
        this.setVersion(id.getVersion());
        this.setClassifier(id.getClassifier());
        this.setCondition(id.getCondition());
        this.setProperties(id.getPropertiesQuery());
    }

    public DefaultNutsIdBuilder(String groupId, String artifactId, NutsVersion version, String classifier, String propertiesQuery, NutsEnvCondition condition, NutsSession session) {
        Map<Object, Object> properties;
        this.session = session;
        this.condition = NutsEnvConditionBuilder.of((NutsSession)session);
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = version == null ? NutsVersion.of((String)"", (NutsSession)session) : version;
        this.setCondition(condition);
        String c0 = NutsUtilStrings.trimToNull((String)classifier);
        String c1 = null;
        Map<Object, Object> map = properties = propertiesQuery == null ? new LinkedHashMap() : QueryStringParser.parseMap(propertiesQuery, session);
        if (!properties.isEmpty()) {
            c1 = (String)properties.remove("classifier");
        }
        if (c0 == null && c1 != null) {
            c0 = NutsUtilStrings.trimToNull((String)c1);
        }
        this.classifier = c0;
        this.setProperties(properties);
    }

    public NutsIdBuilder setAll(NutsId id) {
        if (id == null) {
            this.clear();
        } else {
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setProperties(id.getPropertiesQuery());
        }
        return this;
    }

    public NutsIdBuilder clear() {
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion((NutsVersion)null);
        this.setProperties("");
        return this;
    }

    public NutsIdBuilder setAll(NutsIdBuilder id) {
        if (id == null) {
            this.clear();
        } else {
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setProperties(id.getPropertiesQuery());
        }
        return this;
    }

    public NutsIdBuilder setGroupId(String value) {
        this.groupId = NutsUtilStrings.trimToNull((String)value);
        return this;
    }

    public NutsIdBuilder setRepository(String value) {
        return this.setProperty("repo", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setVersion(NutsVersion value) {
        this.version = value == null ? NutsVersion.of((String)"", (NutsSession)this.session) : value;
        return this;
    }

    public NutsIdBuilder setVersion(String value) {
        this.version = NutsVersion.of((String)value, (NutsSession)this.session);
        return this;
    }

    public DefaultNutsIdBuilder setArtifactId(String value) {
        this.artifactId = NutsUtilStrings.trimToNull((String)value);
        return this;
    }

    public String getFace() {
        String s = this.getProperties().get("face");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getPackaging() {
        String s = this.getProperties().get("packaging");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public NutsIdBuilder setFace(String value) {
        return this.setProperty("face", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setFaceContent() {
        return this.setFace("content");
    }

    public NutsIdBuilder setFaceDescriptor() {
        return this.setFace("descriptor");
    }

    public String getClassifier() {
        return this.classifier;
    }

    public NutsIdBuilder setClassifier(String value) {
        this.classifier = NutsUtilStrings.trimToNull((String)value);
        return this;
    }

    public NutsIdBuilder setPackaging(String value) {
        return this.setProperty("packaging", NutsUtilStrings.trimToNull((String)value));
    }

    public NutsIdBuilder setCondition(NutsEnvCondition c) {
        if (c == null) {
            this.setProperty("os", null);
            this.setProperty("osdist", null);
            this.setProperty("arch", null);
            this.setProperty("platform", null);
            this.setProperty("desktop", null);
            this.setProperty("profile", null);
        } else {
            this.setProperty("os", CoreStringUtils.joinAndTrimToNull(c.getOs()));
            this.setProperty("osdist", CoreStringUtils.joinAndTrimToNull(c.getOsDist()));
            this.setProperty("arch", CoreStringUtils.joinAndTrimToNull(c.getArch()));
            this.setProperty("platform", CoreStringUtils.joinAndTrimToNull(c.getPlatform()));
            this.setProperty("desktop", CoreStringUtils.joinAndTrimToNull(c.getDesktopEnvironment()));
            this.setProperty("profile", CoreStringUtils.joinAndTrimToNull(c.getProfile()));
        }
        return this;
    }

    public NutsEnvConditionBuilder getCondition() {
        return NutsEnvConditionBuilder.of((NutsSession)this.session).setOs(CoreStringUtils.parseAndTrimToDistinctArray(this.getProperties().get("os"))).setArch(CoreStringUtils.parseAndTrimToDistinctArray(this.getProperties().get("arch"))).setOsDist(CoreStringUtils.parseAndTrimToDistinctArray(this.getProperties().get("osdist"))).setPlatform(CoreStringUtils.parseAndTrimToDistinctArray(this.getProperties().get("platform"))).setDesktopEnvironment(CoreStringUtils.parseAndTrimToDistinctArray(this.getProperties().get("desktop")));
    }

    public NutsIdBuilder setCondition(NutsEnvConditionBuilder c) {
        if (c == null) {
            return this.setCondition((NutsEnvCondition)null);
        }
        return this.setCondition(c.build());
    }

    public NutsIdBuilder setProperty(String property, String value) {
        switch (property) {
            case "os": {
                this.condition.setOs(CoreStringUtils.parseAndTrimToDistinctArray(value));
                break;
            }
            case "osdist": {
                this.condition.setOsDist(CoreStringUtils.parseAndTrimToDistinctArray(value));
                break;
            }
            case "arch": {
                this.condition.setArch(CoreStringUtils.parseAndTrimToDistinctArray(value));
                break;
            }
            case "platform": {
                this.condition.setPlatform(CoreStringUtils.parseAndTrimToDistinctArray(value));
                break;
            }
            case "desktop": {
                this.condition.setDesktopEnvironment(CoreStringUtils.parseAndTrimToDistinctArray(value));
                break;
            }
            case "classifier": {
                this.setClassifier(value);
                break;
            }
            default: {
                this.propertiesQuery.setProperty(property, value);
            }
        }
        return this;
    }

    public NutsIdBuilder setProperties(Map<String, String> queryMap) {
        this.propertiesQuery.clear();
        for (Map.Entry<String, String> e : queryMap.entrySet()) {
            this.setProperty(e.getKey(), e.getValue());
        }
        return this;
    }

    public NutsIdBuilder addProperties(Map<String, String> queryMap) {
        this.propertiesQuery.addProperties(queryMap);
        return this;
    }

    public NutsIdBuilder setProperties(String propertiesQuery) {
        this.propertiesQuery.setProperties(propertiesQuery, this.session);
        return this;
    }

    public NutsIdBuilder addProperties(String propertiesQuery) {
        this.propertiesQuery.addProperties(propertiesQuery, this.session);
        return this;
    }

    public String getPropertiesQuery() {
        return QueryStringParser.formatPropertiesQuery(this.getProperties());
    }

    public Map<String, String> getProperties() {
        Map<String, String> m = this.propertiesQuery.getProperties();
        return m;
    }

    public String getRepository() {
        return NutsUtilStrings.trimToNull((String)this.getProperties().get("repo"));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getFullName() {
        if (NutsBlankable.isBlank((String)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getShortName() {
        if (NutsBlankable.isBlank((String)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getLongName() {
        StringBuilder sb = new StringBuilder();
        if (!NutsBlankable.isBlank((String)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(NutsUtilStrings.trim((String)this.artifactId));
        NutsVersion v = this.getVersion();
        if (!v.isBlank()) {
            sb.append("#");
            sb.append(v);
        }
        if (!NutsBlankable.isBlank((String)this.classifier)) {
            sb.append("?");
            sb.append("classifier=");
            sb.append(this.classifier);
        }
        return sb.toString();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NutsBlankable.isBlank((String)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(NutsUtilStrings.trim((String)this.artifactId));
        NutsVersion v = this.getVersion();
        if (!v.isBlank()) {
            sb.append("#");
            sb.append(v);
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NutsBlankable.isBlank((String)this.classifier)) {
            m.put("classifier", this.classifier);
        }
        m.putAll(CoreFilterUtils.toMap(this.condition.build()));
        for (Map.Entry<String, String> e : this.propertiesQuery.getProperties().entrySet()) {
            if (m.containsKey(e.getKey())) continue;
            m.put(e.getKey(), e.getValue());
        }
        if (!m.isEmpty()) {
            sb.append("?").append(QueryStringParser.formatPropertiesQuery(m));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsIdBuilder nutsId = (DefaultNutsIdBuilder)o;
        if (!Objects.equals(this.groupId, nutsId.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, nutsId.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.version, nutsId.version)) {
            return false;
        }
        if (!Objects.equals(this.classifier, nutsId.classifier)) {
            return false;
        }
        return Objects.equals(this.propertiesQuery, nutsId.propertiesQuery);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.propertiesQuery != null ? this.propertiesQuery.hashCode() : 0);
        return result;
    }

    public NutsIdBuilder apply(Function<String, String> properties) {
        this.setGroupId(CoreNutsUtils.applyStringProperties(this.getGroupId(), properties));
        this.setArtifactId(CoreNutsUtils.applyStringProperties(this.getArtifactId(), properties));
        this.setVersion(CoreNutsUtils.applyStringProperties(this.getVersion().getValue(), properties));
        this.setClassifier(CoreNutsUtils.applyStringProperties(this.getClassifier(), properties));
        this.setProperties(CoreNutsUtils.applyMapProperties(this.getProperties(), properties));
        return this;
    }

    public NutsIdBuilder omitImportedGroupId() {
        String g = this.getGroupId();
        if (g != null && g.length() > 0 && this.session.imports().isImportedGroupId(g)) {
            this.setGroupId(null);
        }
        return this;
    }

    public NutsId build() {
        return new DefaultNutsId(this.groupId, this.artifactId, this.version, this.classifier, this.propertiesQuery.getPropertiesQuery(), this.condition.build(), this.session);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

