/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.id.DefaultNutsIdBuilder;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsIdIdFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.QueryStringParser;

public class DefaultNutsId
implements NutsId {
    public static final long serialVersionUID = 1L;
    private final String groupId;
    private final String artifactId;
    private final String classifier;
    private final NutsVersion version;
    private final String properties;
    private final NutsEnvCondition condition;
    private transient NutsSession session;

    public DefaultNutsId(String groupId, String artifactId, NutsVersion version, String classifier, Map<String, String> properties, NutsEnvCondition condition, NutsSession session) {
        this.session = session;
        this.groupId = NutsUtilStrings.trimToNull((String)groupId);
        this.artifactId = NutsUtilStrings.trimToNull((String)artifactId);
        this.version = version == null ? NutsVersion.of((String)"", (NutsSession)session) : version;
        String c0 = NutsUtilStrings.trimToNull((String)classifier);
        String c1 = null;
        if (properties != null) {
            c1 = properties.remove("classifier");
        }
        if (c0 == null && c1 != null) {
            c0 = NutsUtilStrings.trimToNull((String)c1);
        }
        this.classifier = c0;
        if (condition == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"condition cannot be null", (Object[])new Object[0]));
        }
        this.condition = condition;
        this.properties = QueryStringParser.formatSortedPropertiesQuery(properties, session);
    }

    public DefaultNutsId(String groupId, String artifactId, NutsVersion version, String classifier, String properties, NutsEnvCondition condition, NutsSession session) {
        this(groupId, artifactId, version, classifier, new QueryStringParser(true, null).setProperties(properties, session).getProperties(), condition, session);
    }

    public NutsFormat formatter() {
        return NutsIdFormat.of((NutsSession)this.session).setValue((NutsId)this);
    }

    public boolean isNull() {
        return false;
    }

    public boolean isBlank() {
        return this.toString().isEmpty();
    }

    public boolean equalsShortId(NutsId other) {
        if (other == null) {
            return false;
        }
        return NutsUtilStrings.trim((String)this.artifactId).equals(NutsUtilStrings.trim((String)other.getArtifactId())) && NutsUtilStrings.trim((String)this.groupId).equals(NutsUtilStrings.trim((String)other.getGroupId()));
    }

    public boolean isLongId() {
        if (NutsBlankable.isBlank((String)this.properties)) {
            return true;
        }
        HashMap<String, String> m = new HashMap<String, String>(this.getProperties());
        m.remove("classifier");
        return m.isEmpty();
    }

    public boolean isShortId() {
        return NutsBlankable.isBlank((String)this.properties) && NutsBlankable.isBlank((NutsBlankable)this.version) && NutsBlankable.isBlank((String)this.classifier);
    }

    public boolean equalsLongId(NutsId other) {
        if (other == null) {
            return false;
        }
        return NutsUtilStrings.trim((String)this.artifactId).equals(NutsUtilStrings.trim((String)other.getArtifactId())) && NutsUtilStrings.trim((String)this.groupId).equals(NutsUtilStrings.trim((String)other.getGroupId())) && Objects.equals(this.version == null || this.version.isBlank() ? null : this.version, other.getVersion() == null || other.getVersion().isBlank() ? null : other.getVersion()) && Objects.equals(this.getClassifier(), other.getClassifier());
    }

    public String getFace() {
        String s = this.getProperties().get("face");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getClassifier() {
        String s = this.getProperties().get("classifier");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getPackaging() {
        String s = this.getProperties().get("packaging");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public NutsEnvCondition getCondition() {
        return this.condition;
    }

    public String getPropertiesQuery() {
        return this.properties;
    }

    public Map<String, String> getProperties() {
        return QueryStringParser.parseMap(this.properties, this.session);
    }

    public String getRepository() {
        String s = this.getProperties().get("repo");
        return NutsUtilStrings.trimToNull((String)s);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public NutsId getShortId() {
        return new DefaultNutsId(this.groupId, this.artifactId, (NutsVersion)null, null, "", NutsEnvConditionBuilder.of((NutsSession)this.session).build(), this.session);
    }

    public NutsId getLongId() {
        return new DefaultNutsId(this.groupId, this.artifactId, this.version, this.classifier, "", NutsEnvConditionBuilder.of((NutsSession)this.session).build(), this.session);
    }

    public String getShortName() {
        if (NutsBlankable.isBlank((String)this.groupId)) {
            return NutsUtilStrings.trim((String)this.artifactId);
        }
        return NutsUtilStrings.trim((String)this.groupId) + ":" + NutsUtilStrings.trim((String)this.artifactId);
    }

    public String getLongName() {
        StringBuilder sb = new StringBuilder();
        if (!NutsBlankable.isBlank((String)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(NutsUtilStrings.trim((String)this.artifactId));
        NutsVersion v = this.getVersion();
        if (!v.isBlank()) {
            sb.append("#");
            sb.append(v);
        }
        if (!NutsBlankable.isBlank((String)this.classifier)) {
            sb.append("?");
            sb.append("classifier=");
            sb.append(this.classifier);
        }
        return sb.toString();
    }

    public String getFullName() {
        return this.toString();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public NutsVersion getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!NutsBlankable.isBlank((String)this.groupId)) {
            sb.append(this.groupId).append(":");
        }
        sb.append(NutsUtilStrings.trim((String)this.artifactId));
        NutsVersion v = this.getVersion();
        if (!v.isBlank()) {
            sb.append("#");
            sb.append(v);
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NutsBlankable.isBlank((String)this.classifier)) {
            m.put("classifier", this.classifier);
        }
        m.putAll(CoreFilterUtils.toMap(this.condition));
        for (Map.Entry<String, String> e : QueryStringParser.parseMap(this.properties, this.session).entrySet()) {
            if (m.containsKey(e.getKey())) continue;
            m.put(e.getKey(), e.getValue());
        }
        if (!m.isEmpty()) {
            sb.append("?").append(QueryStringParser.formatPropertiesQuery(m));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsId nutsId = (DefaultNutsId)o;
        if (!Objects.equals(this.groupId, nutsId.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, nutsId.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.version, nutsId.version)) {
            return false;
        }
        if (!Objects.equals(this.classifier, nutsId.classifier)) {
            return false;
        }
        return Objects.equals(this.properties, nutsId.properties);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public NutsDependency toDependency() {
        Map<String, String> properties = this.getProperties();
        String exc = properties.get("exclusions");
        if (exc == null) {
            exc = "";
        }
        ArrayList<NutsId> a = new ArrayList<NutsId>();
        for (String s : exc.split("[;,]")) {
            NutsId n = NutsId.of((String)s, (NutsSession)this.session);
            if (n == null) continue;
            a.add(n);
        }
        return NutsDependencyBuilder.of((NutsSession)this.session).setRepository(this.getRepository()).setArtifactId(this.getArtifactId()).setGroupId(this.getGroupId()).setClassifier(this.getClassifier()).setVersion(this.getVersion()).setScope(properties.get("scope")).setOptional(properties.get("optional")).setExclusions(a.toArray(new NutsId[0])).setProperties(properties).build();
    }

    public NutsIdBuilder builder() {
        return new DefaultNutsIdBuilder(this, this.session);
    }

    public int compareTo(NutsId o2) {
        int x = NutsUtilStrings.trim((String)this.getGroupId()).compareTo(NutsUtilStrings.trim((String)o2.getGroupId()));
        if (x != 0) {
            return x;
        }
        x = NutsUtilStrings.trim((String)this.getArtifactId()).compareTo(NutsUtilStrings.trim((String)o2.getArtifactId()));
        if (x != 0) {
            return x;
        }
        x = this.getVersion().compareTo(o2.getVersion());
        if (x != 0) {
            return x;
        }
        x = NutsUtilStrings.trim((String)this.getClassifier()).compareTo(NutsUtilStrings.trim((String)o2.getClassifier()));
        return -x;
    }

    public NutsIdFilter filter() {
        return new NutsIdIdFilter(this, this.session);
    }

    public NutsId compatNewer() {
        return this.builder().setVersion(this.getVersion().compatNewer()).build();
    }

    public NutsId compatOlder() {
        return this.builder().setVersion(this.getVersion().compatOlder()).build();
    }
}

