/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.xml;

import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NutsXmlUtils {
    public static String createElementName(String name) {
        if (name == null) {
            name = "";
        }
        if ((name = name.trim()).isEmpty()) {
            name = "node";
        }
        if (Character.isDigit(name.charAt(0))) {
            name = "_" + name;
        }
        if (name.toLowerCase().startsWith("xml")) {
            name = "_" + name;
        }
        char[] r = name.toCharArray();
        for (int i = 0; i < r.length; ++i) {
            char c = r[i];
            if (Character.isDigit(c) || Character.isLetter(c) || c == '_' || c == '-' || c == '.') continue;
            r[i] = 95;
        }
        return new String(r);
    }

    public static Document createDocument(NutsSession session) {
        return NutsXmlUtils.createDocumentBuilder(false, session).newDocument();
    }

    public static DocumentBuilder createDocumentBuilder(boolean safe, final NutsSession session) {
        DocumentBuilder b;
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        if (safe) {
            documentFactory.setExpandEntityReferences(false);
            NutsXmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces-j/features.html#external-general-entities", false);
            NutsXmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces2-j/features.html#external-general-entities", false);
            NutsXmlUtils.setLenientFeature(documentFactory, "http://xml.org/sax/features/external-general-entities", false);
            NutsXmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", false);
            NutsXmlUtils.setLenientFeature(documentFactory, "http://xml.org/sax/features/external-parameter-entities", false);
            NutsXmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", false);
            NutsXmlUtils.setLenientFeature(documentFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentFactory.setXIncludeAware(false);
            documentFactory.setValidating(false);
        }
        try {
            b = documentFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
        b.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                NutsLoggerOp.of(NutsXmlUtils.class, (NutsSession)session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"{0}", (Object[])new Object[]{exception}));
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                NutsLoggerOp.of(NutsXmlUtils.class, (NutsSession)session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"{0}", (Object[])new Object[]{exception}));
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                NutsLoggerOp.of(NutsXmlUtils.class, (NutsSession)session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"{0}", (Object[])new Object[]{exception}));
            }
        });
        return b;
    }

    private static void setLenientFeature(DocumentBuilderFactory dbFactory, String s, boolean b) {
        try {
            dbFactory.setFeature(s, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String documentToString(Document document, NutsSession session) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        NutsXmlUtils.writeDocument(document, new StreamResult(b), true, true, session);
        return new String(b.toByteArray());
    }

    public static String elementToString(Element elem, NutsSession session) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            Document d = NutsXmlUtils.createDocument(session);
            elem = (Element)d.importNode(elem, true);
            d.appendChild(elem);
            NutsXmlUtils.writeDocument(d, new StreamResult(b), true, false, session);
            return new String(b.toByteArray());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeDocument(Document document, StreamResult writer, boolean compact, boolean headerDeclaration, NutsSession session) {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        if (!compact) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        document.setXmlStandalone(false);
        transformer.setOutputProperty("standalone", "no");
        if (!headerDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        DOMSource domSource = new DOMSource(document);
        try {
            transformer.transform(domSource, writer);
        }
        catch (TransformerException ex) {
            throw new NutsIOException(session, (Throwable)ex);
        }
    }
}

