/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.xml;

import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Supplier;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.runtime.standalone.format.xml.NutsXmlUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NutsElementFactoryXmlElement
implements NutsElementMapper<Node> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V runWithDoc(NutsElementFactoryContext context, Supplier<V> impl, Document doc) {
        Stack<Document> docs = (Stack<Document>)context.getProperties().get(Document.class.getName());
        if (docs == null) {
            docs = new Stack<Document>();
            context.getProperties().put(Document.class.getName(), docs);
            try {
                docs.push(doc != null ? doc : NutsXmlUtils.createDocument(context.getSession()));
                V v = impl.get();
                return v;
            }
            finally {
                docs.pop();
            }
        }
        if (docs.isEmpty() || doc != null) {
            try {
                docs.push(doc != null ? doc : NutsXmlUtils.createDocument(context.getSession()));
                V v = impl.get();
                return v;
            }
            finally {
                docs.pop();
            }
        }
        return impl.get();
    }

    public Node createObject(NutsElement elem, Type typeOfResult, NutsElementFactoryContext context) {
        return NutsElementFactoryXmlElement.runWithDoc(context, () -> this.createObject0(elem, typeOfResult, context), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node createObject0(NutsElement elem, Type typeOfResult, NutsElementFactoryContext context) {
        if (context.getProperties().get(Document.class.getName()) == null || !(context.getProperties().get(Document.class.getName()) instanceof Stack)) {
            Stack<Document> docs = new Stack<Document>();
            context.getProperties().put(Document.class.getName(), docs);
            try {
                docs.push(NutsXmlUtils.createDocument(context.getSession()));
                Node node = this.createObject(elem, typeOfResult, context);
                return node;
            }
            finally {
                docs.pop();
            }
        }
        Stack docs = (Stack)context.getProperties().get(Document.class.getName());
        if (docs.isEmpty()) {
            try {
                docs.push(NutsXmlUtils.createDocument(context.getSession()));
                Node node = this.createObject(elem, typeOfResult, context);
                return node;
            }
            finally {
                docs.pop();
            }
        }
        Document doc = (Document)((Stack)context.getProperties().get(Document.class.getName())).peek();
        switch (elem.type()) {
            case NULL: {
                Element e = doc.createElement("null");
                return e;
            }
            case STRING: {
                Element e = doc.createElement("string");
                String s = elem.asPrimitive().getString();
                if (this.isComplexString(s)) {
                    e.setTextContent(s);
                } else {
                    e.setAttribute("value", s);
                }
                return e;
            }
            case BOOLEAN: {
                return doc.createElement(String.valueOf(elem.asPrimitive().getBoolean()));
            }
            case BYTE: {
                Element e = doc.createElement("byte");
                e.setAttribute("value", String.valueOf(elem.asPrimitive().getByte()));
                return e;
            }
            case SHORT: {
                Element e = doc.createElement("short");
                e.setAttribute("value", String.valueOf(elem.asPrimitive().getShort()));
                return e;
            }
            case INTEGER: {
                Element e = doc.createElement("int");
                e.setAttribute("value", String.valueOf(elem.asPrimitive().getInt()));
                return e;
            }
            case LONG: {
                Element e = doc.createElement("long");
                e.setAttribute("value", String.valueOf(elem.asPrimitive().getLong()));
                return e;
            }
            case FLOAT: {
                Element e = doc.createElement("float");
                e.setAttribute("value", String.valueOf(elem.asPrimitive().getFloat()));
                return e;
            }
            case DOUBLE: {
                Element e = doc.createElement("double");
                e.setAttribute("value", String.valueOf(elem.asPrimitive().getDouble()));
                return e;
            }
            case INSTANT: {
                Element e = doc.createElement("instant");
                e.setAttribute("value", elem.asPrimitive().getInstant().toString());
                return e;
            }
            case ARRAY: {
                Element e = doc.createElement("array");
                int count = 0;
                for (NutsElement attribute : elem.asArray().children()) {
                    Node c = this.createObject(attribute, (Type)((Object)Element.class), context);
                    if (c == null) continue;
                    e.appendChild(c);
                    ++count;
                }
                return e;
            }
            case OBJECT: {
                Element obj = doc.createElement("object");
                block26: for (NutsElementEntry ne : elem.asObject().children()) {
                    Element ev;
                    boolean complexKey;
                    NutsElementType kt = ne.getKey().type();
                    boolean bl = complexKey = kt == NutsElementType.ARRAY || kt == NutsElementType.OBJECT || kt == NutsElementType.STRING && this.isComplexString(ne.getKey().asPrimitive().getString());
                    if (complexKey) {
                        Element entry = doc.createElement("entry");
                        Element ek = (Element)this.createObject(ne.getKey(), (Type)((Object)NutsElement.class), context);
                        ek.setAttribute("entry-key", null);
                        entry.appendChild(ek);
                        ev = (Element)this.createObject(ne.getValue(), (Type)((Object)NutsElement.class), context);
                        ev.setAttribute("entry-value", null);
                        entry.appendChild(ev);
                        obj.appendChild(entry);
                        continue;
                    }
                    String tagName = ne.getKey().type() == NutsElementType.BOOLEAN ? ne.getKey().asPrimitive().getString() : ne.getKey().type().id();
                    Element entryElem = doc.createElement(tagName);
                    if (ne.getKey().type() != NutsElementType.BOOLEAN && ne.getKey().type() != NutsElementType.NULL) {
                        entryElem.setAttribute("key", ne.getKey().asPrimitive().getString());
                    }
                    switch (ne.getValue().type()) {
                        case ARRAY: 
                        case OBJECT: {
                            ev = (Element)this.createObject(ne.getValue(), (Type)((Object)NutsElement.class), context);
                            ev.setAttribute("entry-value", null);
                            entryElem.appendChild(ev);
                            obj.appendChild(entryElem);
                            continue block26;
                        }
                        case NULL: {
                            entryElem.setAttribute("value-type", ne.getValue().type().id());
                            obj.appendChild(entryElem);
                            continue block26;
                        }
                        case STRING: {
                            entryElem.setAttribute("value", ne.getValue().asPrimitive().getString());
                            obj.appendChild(entryElem);
                            continue block26;
                        }
                    }
                    entryElem.setAttribute("value", ne.getValue().asPrimitive().getString());
                    entryElem.setAttribute("value-type", ne.getValue().type().id());
                    obj.appendChild(entryElem);
                }
                return obj;
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    public NutsElement createElement(String type, String value, NutsElementFactoryContext context) {
        NutsElements f = NutsElements.of((NutsSession)context.getSession());
        switch (type) {
            case "null": {
                return f.ofNull();
            }
            case "number": {
                return context.objectToElement((Object)value, Number.class);
            }
            case "boolean": {
                return context.objectToElement((Object)value, Boolean.class);
            }
            case "true": {
                return f.ofTrue();
            }
            case "false": {
                return f.ofTrue();
            }
            case "byte": {
                return context.objectToElement((Object)value, Byte.class);
            }
            case "short": {
                return context.objectToElement((Object)value, Short.class);
            }
            case "int": {
                return context.objectToElement((Object)value, Integer.class);
            }
            case "long": {
                return context.objectToElement((Object)value, Long.class);
            }
            case "float": {
                return context.objectToElement((Object)value, Float.class);
            }
            case "double": {
                return context.objectToElement((Object)value, Double.class);
            }
            case "char": {
                return context.objectToElement((Object)value, Character.class);
            }
            case "string": {
                return context.objectToElement((Object)value, String.class);
            }
            case "nuts-string": {
                return context.objectToElement((Object)value, NutsString.class);
            }
            case "instant": {
                return context.objectToElement((Object)value, Instant.class);
            }
            case "date": {
                return context.objectToElement((Object)value, Date.class);
            }
            case "file": {
                return context.objectToElement((Object)value, File.class);
            }
            case "path": {
                return context.objectToElement((Object)value, Path.class);
            }
        }
        throw new IllegalArgumentException("unsupported");
    }

    public boolean isSimpleObject(NutsObjectElement obj) {
        for (NutsElementEntry attribute : obj.children()) {
            NutsElementType tt = attribute.getKey().type();
            if (tt != NutsElementType.OBJECT && tt != NutsElementType.ARRAY) continue;
            return false;
        }
        return true;
    }

    private boolean isComplexString(String string) {
        return string.contains("\n") || string.length() > 120;
    }

    private String resolveValue(Element e) {
        String value1 = e.getAttribute("value");
        String value2 = e.getTextContent();
        if (value2 == null) {
            return value1;
        }
        if (value1 == null) {
            return value2;
        }
        return value1 + value2;
    }

    public Object destruct(Node node, Type typeOfSrc, NutsElementFactoryContext context) {
        if (node instanceof Attr) {
            Attr at = (Attr)node;
            return new AbstractMap.SimpleEntry<String, Object>(at.getName(), context.destruct((Object)at.getValue(), String.class));
        }
        if (node instanceof CDATASection) {
            CDATASection d = (CDATASection)node;
            return d.getWholeText();
        }
        if (node instanceof Text) {
            Text d = (Text)node;
            return d.getWholeText();
        }
        Element element = (Element)node;
        NodeInfo ni = new NodeInfo(element);
        switch (ni.type) {
            case "object": {
                HashSet<String> visited = new HashSet<String>();
                boolean map = true;
                ArrayList<AbstractMap.SimpleEntry<String, String>> all = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                NamedNodeMap attrs = element.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr n = (Attr)attrs.item(i);
                    String string = n.getName();
                    String v = n.getValue();
                    if (map && visited.contains(string)) {
                        map = false;
                    } else {
                        visited.add(string);
                    }
                    all.add(new AbstractMap.SimpleEntry<String, String>(string, v));
                }
                if (map) {
                    LinkedHashMap m = new LinkedHashMap();
                    for (Map.Entry entry : all) {
                        m.put(entry.getKey(), entry.getValue());
                    }
                    return m;
                }
                return all;
            }
            case "array": {
                ArrayList<NutsElement> obj = new ArrayList<NutsElement>();
                NodeList attrs = element.getChildNodes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node n = attrs.item(i);
                    obj.add(this.createElement(n, typeOfSrc, context));
                }
                return obj;
            }
            case "boolean": {
                return context.destruct((Object)this.resolveValue(element), Boolean.class);
            }
            case "byte": {
                return context.destruct((Object)this.resolveValue(element), Byte.class);
            }
            case "short": {
                return context.destruct((Object)this.resolveValue(element), Short.class);
            }
            case "int": {
                return context.destruct((Object)this.resolveValue(element), Integer.class);
            }
            case "long": {
                return context.destruct((Object)this.resolveValue(element), Long.class);
            }
            case "float": {
                return context.destruct((Object)this.resolveValue(element), Float.class);
            }
            case "double": {
                return context.destruct((Object)this.resolveValue(element), Double.class);
            }
            case "char": {
                return context.destruct((Object)this.resolveValue(element), Character.class);
            }
            case "string": {
                return context.destruct((Object)this.resolveValue(element), String.class);
            }
            case "instant": {
                return context.destruct((Object)this.resolveValue(element), Instant.class);
            }
            case "date": {
                return context.destruct((Object)this.resolveValue(element), Date.class);
            }
            case "file": {
                return context.destruct((Object)this.resolveValue(element), File.class);
            }
            case "path": {
                return context.destruct((Object)this.resolveValue(element), Path.class);
            }
        }
        throw new IllegalArgumentException("unsupported");
    }

    public NutsElement createElement(Node node, Type typeOfSrc, NutsElementFactoryContext context) {
        NutsElements elements = NutsElements.of((NutsSession)context.getSession()).setSession(context.getSession());
        if (node instanceof Attr) {
            Attr at = (Attr)node;
            return elements.ofObject().set(at.getName(), context.objectToElement((Object)at.getValue(), String.class)).build();
        }
        if (node instanceof CDATASection) {
            CDATASection d = (CDATASection)node;
            return elements.ofString(d.getWholeText());
        }
        if (node instanceof Text) {
            Text d = (Text)node;
            return elements.ofString(d.getWholeText());
        }
        Element element = (Element)node;
        NodeInfo ni = new NodeInfo(element);
        switch (ni.type) {
            case "object": {
                NutsObjectElementBuilder obj = elements.ofObject();
                NamedNodeMap attrs = element.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr n = (Attr)attrs.item(i);
                    obj.set(n.getName(), context.objectToElement((Object)n.getValue(), null));
                }
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Element e;
                    Node n = children.item(i);
                    if (n instanceof Element) {
                        e = (Element)n;
                        NodeInfo ni2 = new NodeInfo(e);
                        obj.set(ni2.name, this.createElement(ni2.type, ni2.value, context));
                        continue;
                    }
                    if (!(n instanceof Text)) continue;
                    e = this.createElement(n, (Type)((Object)Text.class), context);
                    obj.set("content", (NutsElement)e);
                }
                return obj.build();
            }
            case "array": {
                NutsArrayElementBuilder obj = elements.ofArray();
                NodeList attrs = element.getChildNodes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node n = attrs.item(i);
                    obj.add(this.createElement(n, typeOfSrc, context));
                }
                return obj.build();
            }
            case "boolean": {
                return context.objectToElement((Object)this.resolveValue(element), Boolean.class);
            }
            case "byte": {
                return context.objectToElement((Object)this.resolveValue(element), Byte.class);
            }
            case "short": {
                return context.objectToElement((Object)this.resolveValue(element), Short.class);
            }
            case "int": {
                return context.objectToElement((Object)this.resolveValue(element), Integer.class);
            }
            case "long": {
                return context.objectToElement((Object)this.resolveValue(element), Long.class);
            }
            case "float": {
                return context.objectToElement((Object)this.resolveValue(element), Float.class);
            }
            case "double": {
                return context.objectToElement((Object)this.resolveValue(element), Double.class);
            }
            case "char": {
                return context.objectToElement((Object)this.resolveValue(element), Character.class);
            }
            case "string": {
                return context.objectToElement((Object)this.resolveValue(element), String.class);
            }
            case "instant": {
                return context.objectToElement((Object)this.resolveValue(element), Instant.class);
            }
            case "date": {
                return context.objectToElement((Object)this.resolveValue(element), Date.class);
            }
            case "file": {
                return context.objectToElement((Object)this.resolveValue(element), File.class);
            }
            case "path": {
                return context.objectToElement((Object)this.resolveValue(element), Path.class);
            }
        }
        throw new IllegalArgumentException("unsupported");
    }

    private static class NodeInfo {
        String type;
        String name;
        String value;

        public NodeInfo(Element e) {
            String name0 = e.getAttribute("name");
            String string = this.name = name0 == null ? e.getTagName() : name0;
            this.type = e.getAttribute("type") != null ? e.getAttribute("type") : (name0 != null ? e.getTagName() : "string");
            this.value = e.getAttribute("value");
        }
    }
}

