/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.xml;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCodeHighlighter;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.xml.NutsXmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSearchFormatXml
extends DefaultSearchFormatBase {
    private boolean compact;
    private String rootName = "root";
    private NutsCodeHighlighter codeFormat;
    NutsTexts txt;

    public DefaultSearchFormatXml(NutsSession session, NutsPrintStream writer, NutsFetchDisplayOptions options) {
        super(session, writer, NutsContentType.XML, options);
        this.txt = NutsTexts.of((NutsSession)session);
        this.codeFormat = NutsTexts.of((NutsSession)session).setSession(session).getCodeHighlighter("xml");
    }

    public String getRootName() {
        return this.rootName;
    }

    public void start() {
        NutsTextBuilder builder = NutsTexts.of((NutsSession)this.getSession()).builder();
        NutsSession session = this.getSession();
        builder.append(this.codeFormat.tokenToText("<?", "separator", this.txt, session));
        builder.append(this.codeFormat.tokenToText("xml", "name", this.txt, session));
        builder.append((Object)" ");
        builder.append(this.codeFormat.tokenToText("version", "attribute", this.txt, session));
        builder.append(this.codeFormat.tokenToText("=", "separator", this.txt, session));
        builder.append(this.codeFormat.tokenToText("\"1.0\"", "string", this.txt, session));
        builder.append((Object)" ");
        builder.append(this.codeFormat.tokenToText("encoding", "attribute", this.txt, session));
        builder.append(this.codeFormat.tokenToText("=", "separator", this.txt, session));
        builder.append(this.codeFormat.tokenToText("?>", "separator", this.txt, session));
        builder.append((Object)"\n");
        builder.append(this.codeFormat.tokenToText("<", "separator", this.txt, session));
        builder.append(this.codeFormat.tokenToText(this.rootName, "name", this.txt, session));
        builder.append(this.codeFormat.tokenToText(">", "separator", this.txt, session));
        this.getWriter().println(builder.toString());
    }

    public void next(Object object, long index) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        Element xmlElement = (Element)NutsElements.of((NutsSession)this.getSession()).convert(object, Element.class);
        Document doc = NutsXmlUtils.createDocument(this.getSession());
        doc.adoptNode(xmlElement);
        doc.appendChild(xmlElement);
        NutsXmlUtils.writeDocument(doc, new StreamResult(pw), this.compact, false, this.getSession());
        pw.flush();
        this.getWriter().print((NutsString)this.codeFormat.stringToText(bos.toString(), this.txt, this.getSession()));
    }

    public void complete(long count) {
        NutsTextBuilder builder = NutsTexts.of((NutsSession)this.getSession()).builder();
        NutsSession session = this.getSession();
        builder.append(this.codeFormat.tokenToText("</", "separator", this.txt, session));
        builder.append(this.codeFormat.tokenToText(this.rootName, "name", this.txt, session));
        builder.append(this.codeFormat.tokenToText(">", "separator", this.txt, session));
        this.getWriter().println(builder.toString());
        this.getWriter().flush();
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        if (this.getDisplayOptions().configureFirst(cmd)) {
            return true;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--compact": {
                boolean val = cmd.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.compact = val;
                }
                return true;
            }
            case "--root-name": {
                String val = cmd.nextString(new String[0]).getValue().getString();
                if (enabled) {
                    this.rootName = val;
                }
                return true;
            }
        }
        return false;
    }
}

