/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.format.tree.XNodeFormatter;

public class XNode {
    NutsString key;
    Object value;
    NutsString title;
    NutsSession session;
    NutsWorkspace ws;
    XNodeFormatter format;

    public static XNode root(Object destructedObject, NutsString title, NutsSession session, XNodeFormatter format) {
        return new XNode(null, destructedObject, (NutsString)(destructedObject instanceof List || destructedObject instanceof Map || destructedObject instanceof Map.Entry ? title : null), session, format);
    }

    public static XNode node(Object destructedObject, NutsSession session, XNodeFormatter format) {
        return new XNode(null, destructedObject, null, session, format);
    }

    public static XNode entryNode(NutsString key, Object destructedObject, NutsSession session, XNodeFormatter format) {
        return new XNode(key, destructedObject, null, session, format);
    }

    public XNode(NutsString key, Object destructedObject, NutsString title, NutsSession session, XNodeFormatter format) {
        this.value = destructedObject instanceof Map && ((Map)destructedObject).size() == 1 ? ((Map)destructedObject).entrySet().toArray()[0] : (destructedObject instanceof NutsObjectElement && ((NutsObjectElement)destructedObject).size() == 1 ? ((NutsObjectElement)destructedObject).children().toArray()[0] : destructedObject);
        this.key = key;
        this.title = title;
        this.session = session;
        this.ws = session.getWorkspace();
        this.format = format;
    }

    public String toString() {
        return this.toNutsString().toString();
    }

    public NutsString toNutsString() {
        NutsString keyAsElement = this.format.stringValue(this.key, this.session);
        NutsString[] p = this.format.getMultilineArray(keyAsElement, this.value, this.session);
        if (p != null) {
            return keyAsElement;
        }
        NutsString _title = this.resolveTitle();
        NutsString titleOrValueAsElement = null;
        titleOrValueAsElement = this.getChildren() == null || this.getChildren().isEmpty() ? this.format.stringValue(_title != null ? _title : this.value, this.session) : this.format.stringValue(_title, this.session);
        if (this.key == null) {
            return titleOrValueAsElement;
        }
        if (XNode.isList(this.value) || XNode.isMap(this.value)) {
            return NutsTexts.of((NutsSession)this.session).builder().append((Object)keyAsElement);
        }
        return NutsTexts.of((NutsSession)this.session).builder().append((Object)keyAsElement).append((Object)"=").append((Object)titleOrValueAsElement);
    }

    private NutsString resolveTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (XNode.isList(this.value)) {
            return null;
        }
        if (XNode.isMapEntry(this.value)) {
            if (this.value instanceof Map.Entry) {
                return this.format.stringValue(((Map.Entry)this.value).getKey(), this.session);
            }
            return this.format.stringValue(((NutsElementEntry)this.value).getKey(), this.session);
        }
        if (XNode.isMap(this.value)) {
            // empty if block
        }
        return null;
    }

    public List getChildren() {
        if (this.value instanceof Map.Entry) {
            Object v = ((Map.Entry)this.value).getValue();
            return this.getAsList(v);
        }
        if (this.value instanceof NutsElementEntry) {
            NutsElement v = ((NutsElementEntry)this.value).getValue();
            return this.getAsList(v);
        }
        if (XNode.isList(this.value) || XNode.isMap(this.value)) {
            return this.getAsList(this.value);
        }
        return null;
    }

    private static boolean isList(Object value) {
        if (value instanceof List) {
            return true;
        }
        return value instanceof NutsArrayElement;
    }

    private static boolean isMapEntry(Object value) {
        if (value instanceof Map.Entry) {
            return true;
        }
        return value instanceof NutsElementEntry;
    }

    private static boolean isMap(Object value) {
        if (value instanceof Map) {
            return true;
        }
        return value instanceof NutsObjectElement;
    }

    private List getAsList(Object value) {
        if (value instanceof List) {
            return ((List)value).stream().map(me -> XNode.node(me, this.session, this.format)).collect(Collectors.toList());
        }
        if (value instanceof NutsArrayElement) {
            return ((NutsArrayElement)value).stream().map(me -> XNode.node(me, this.session, this.format)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            Map m = (Map)value;
            ArrayList<XNode> all = new ArrayList<XNode>();
            for (Map.Entry me2 : m.entrySet()) {
                NutsString keyStr = this.format.stringValue(me2.getKey(), this.session);
                NutsString[] map = this.format.getMultilineArray(keyStr, me2.getValue(), this.session);
                if (map == null) {
                    all.add(XNode.entryNode(keyStr, me2.getValue(), this.session, this.format));
                    continue;
                }
                all.add(XNode.entryNode(keyStr, NutsElements.of((NutsSession)this.session).toElement(Arrays.asList(map)), this.session, this.format));
            }
            return all;
        }
        if (value instanceof NutsObjectElement) {
            NutsObjectElement m = (NutsObjectElement)value;
            ArrayList<XNode> all = new ArrayList<XNode>();
            for (NutsElementEntry me3 : m) {
                NutsString keyStr = this.format.stringValue(me3.getKey(), this.session);
                NutsString[] map = this.format.getMultilineArray(keyStr, me3.getValue(), this.session);
                if (map == null) {
                    all.add(XNode.entryNode(keyStr, me3.getValue(), this.session, this.format));
                    continue;
                }
                all.add(XNode.entryNode(keyStr, NutsElements.of((NutsSession)this.session).toElement(Arrays.asList(map)), this.session, this.format));
            }
            return all;
        }
        return Arrays.asList(XNode.node(value, this.session, this.format));
    }
}

