/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tree;

import java.util.AbstractMap;
import java.util.ArrayList;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeFormat;
import net.thevpc.nuts.NutsTreeNodeFormat;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.NutsIdFormatHelper;
import net.thevpc.nuts.runtime.standalone.format.tree.XNode;

public class DefaultSearchFormatTree
extends DefaultSearchFormatBase {
    private Object lastObject;
    NutsTreeNodeFormat nutsTreeNodeFormat = new NutsTreeNodeFormat(){

        public NutsString format(Object o, int depth, NutsSession session) {
            NutsIdFormatHelper fid = NutsIdFormatHelper.of(o, DefaultSearchFormatTree.this.getSession());
            if (fid != null) {
                return fid.getSingleColumnRow(DefaultSearchFormatTree.this.getDisplayOptions());
            }
            if (o instanceof XNode) {
                return ((XNode)o).toNutsString();
            }
            return NutsTexts.of((NutsSession)DefaultSearchFormatTree.this.getSession()).builder().append(o).immutable();
        }
    };

    public DefaultSearchFormatTree(NutsSession session, NutsPrintStream writer, NutsFetchDisplayOptions options) {
        super(session, writer, NutsContentType.TREE, options);
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        return this.getDisplayOptions().configureFirst(commandLine);
    }

    public void start() {
    }

    public void next(Object object, long index) {
        if (index > 0L) {
            this.formatElement(this.lastObject, index - 1L, false);
        }
        this.lastObject = object;
    }

    public void complete(long count) {
        if (count > 0L) {
            this.formatElement(this.lastObject, count - 1L, true);
        }
    }

    public void formatElement(Object object, long index, boolean last) {
        NutsTreeFormat tree = NutsTreeFormat.of((NutsSession)this.getSession());
        ArrayList<String> options = new ArrayList<String>();
        options.add("--omit-root");
        if (!last) {
            options.add("--infinite");
        }
        tree.configure(false, options.toArray(new String[0]));
        tree.setNodeFormat(this.nutsTreeNodeFormat);
        tree.setValue(new AbstractMap.SimpleEntry<String, Object>("ROOT", object));
        tree.println(this.getWriter());
        this.getWriter().flush();
    }
}

