/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tree;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsPositionType;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTreeFormat;
import net.thevpc.nuts.NutsTreeLinkFormat;
import net.thevpc.nuts.NutsTreeModel;
import net.thevpc.nuts.NutsTreeNodeFormat;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.tree.AsciiTreeLinkFormat;
import net.thevpc.nuts.runtime.standalone.format.tree.NutsElementTreeModel;
import net.thevpc.nuts.runtime.standalone.format.tree.SpaceTreeLinkFormat;
import net.thevpc.nuts.runtime.standalone.format.tree.UnicodeTreeLinkFormat;
import net.thevpc.nuts.runtime.standalone.format.tree.XNode;
import net.thevpc.nuts.runtime.standalone.format.tree.XNodeFormatter;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsTreeFormat
extends DefaultFormatBase<NutsTreeFormat>
implements NutsTreeFormat {
    public static final NutsTreeLinkFormat LINK_ASCII_FORMATTER = new AsciiTreeLinkFormat();
    public static final NutsTreeLinkFormat LINK_SPACE_FORMATTER = new SpaceTreeLinkFormat();
    public static final NutsTreeLinkFormat LINK_UNICODE_FORMATTER = new UnicodeTreeLinkFormat();
    private NutsString rootName;
    private Map<String, String> multilineProperties = new HashMap<String, String>();
    public final NutsTreeNodeFormat TO_STRING_FORMATTER = new NutsTreeNodeFormat(){

        public NutsString format(Object o, int depth, NutsSession session) {
            return NutsTexts.of((NutsSession)session).builder().append(o).immutable();
        }
    };
    private NutsTreeNodeFormat formatter;
    private NutsTreeLinkFormat linkFormatter;
    private Object tree;
    private boolean omitRoot = false;
    private boolean infinite = false;
    private boolean omitEmptyRoot = true;
    private XNodeFormatter xNodeFormatter = new XNodeFormatter(){

        @Override
        public NutsString[] getMultilineArray(NutsString key, Object value, NutsSession session) {
            return DefaultNutsTreeFormat.this.getMultilineArray(key, value);
        }

        @Override
        public NutsString stringValue(Object o, NutsSession session) {
            return DefaultNutsTreeFormat.this.getNodeFormat().format(o, -1, session);
        }
    };

    public DefaultNutsTreeFormat(NutsSession session) {
        super(session, "tree-format");
        this.formatter = this.TO_STRING_FORMATTER;
        this.linkFormatter = CorePlatformUtils.SUPPORTS_UTF_ENCODING ? LINK_UNICODE_FORMATTER : LINK_ASCII_FORMATTER;
    }

    public DefaultNutsTreeFormat(NutsSession ws, NutsTreeModel tree) {
        this(ws, tree, null, null);
    }

    public DefaultNutsTreeFormat(NutsSession ws, NutsTreeModel tree, NutsTreeNodeFormat formatter, NutsTreeLinkFormat linkFormatter) {
        super(ws, "tree");
        if (formatter == null) {
            formatter = this.TO_STRING_FORMATTER;
        }
        if (linkFormatter == null) {
            linkFormatter = LINK_ASCII_FORMATTER;
        }
        if (tree == null) {
            throw new NullPointerException("Null Tree");
        }
        this.formatter = formatter;
        this.linkFormatter = linkFormatter;
        this.tree = tree;
    }

    public NutsTreeNodeFormat getNodeFormat() {
        return this.formatter;
    }

    public DefaultNutsTreeFormat setNodeFormat(NutsTreeNodeFormat formatter) {
        if (formatter == null) {
            formatter = this.TO_STRING_FORMATTER;
        }
        this.formatter = formatter;
        return this;
    }

    public NutsTreeLinkFormat getLinkFormat() {
        return this.linkFormatter;
    }

    public DefaultNutsTreeFormat setLinkFormat(NutsTreeLinkFormat linkFormatter) {
        if (linkFormatter == null) {
            linkFormatter = LINK_ASCII_FORMATTER;
        }
        this.linkFormatter = linkFormatter;
        return this;
    }

    public NutsTreeModel getModel() {
        this.checkSession();
        if (this.tree instanceof NutsTreeModel) {
            return (NutsTreeModel)this.tree;
        }
        Object destructredObject = NutsElements.of((NutsSession)this.getSession()).setNtf(true).setIndestructibleFormat().destruct(this.tree);
        return new NutsElementTreeModel(XNode.root(destructredObject, this.rootName, this.getSession(), this.xNodeFormatter));
    }

    public DefaultNutsTreeFormat setValue(Object value) {
        this.tree = value;
        return this;
    }

    public boolean isEffectiveOmitRoot() {
        NutsTreeModel tree = this.getModel();
        return this.isOmitRoot() || this.omitEmptyRoot && (tree.getRoot() == null || tree.getRoot().toString().isEmpty());
    }

    public boolean isOmitRoot() {
        return this.omitRoot;
    }

    public void setOmitRoot(boolean hideRoot) {
        this.omitRoot = hideRoot;
    }

    @Override
    public String toString() {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        NutsPrintStream out = NutsPrintStream.of((OutputStream)b, (NutsSession)this.getSession());
        NutsTreeModel tree = this.getModel();
        this.print(tree, "", NutsPositionType.FIRST, tree.getRoot(), out, this.isEffectiveOmitRoot(), 0, false);
        out.flush();
        return b.toString();
    }

    @Override
    public void print(NutsPrintStream out) {
        NutsTreeModel tree = this.getModel();
        this.print(tree, "", NutsPositionType.FIRST, tree.getRoot(), out, this.isEffectiveOmitRoot(), 0, false);
        out.flush();
    }

    private boolean print(NutsTreeModel tree, String prefix, NutsPositionType type, Object o, NutsPrintStream out, boolean hideRoot, int depth, boolean prefixNewLine) {
        List children;
        this.checkSession();
        Object oValue = o;
        if (oValue instanceof XNode) {
            oValue = ((XNode)oValue).toNutsString();
        }
        if (!hideRoot) {
            if (prefixNewLine) {
                out.println();
            }
            out.print(prefix);
            out.print(this.linkFormatter.formatMain(type));
            out.print(this.formatter.format(oValue, depth, this.getSession()));
            out.flush();
            prefixNewLine = true;
        }
        if ((children = tree.getChildren(o)) == null) {
            children = Collections.EMPTY_LIST;
        }
        Iterator childrenIter = children.iterator();
        Object last = null;
        if (childrenIter.hasNext()) {
            last = childrenIter.next();
        }
        while (childrenIter.hasNext()) {
            Object c = last;
            last = childrenIter.next();
            prefixNewLine |= this.print(tree, prefix + this.linkFormatter.formatChild(type), NutsPositionType.CENTER, c, out, false, depth + 1, prefixNewLine);
        }
        if (last != null) {
            prefixNewLine |= this.print(tree, prefix + this.linkFormatter.formatChild(type), this.infinite && "".equals(prefix) ? NutsPositionType.CENTER : NutsPositionType.LAST, last, out, false, depth + 1, prefixNewLine);
        }
        return prefixNewLine;
    }

    private void print(NutsTreeModel tree, String prefix, NutsPositionType type, Object o, PrintWriter out, boolean hideRoot, int depth) {
        List children1;
        this.checkSession();
        boolean skipNewLine = true;
        if (!hideRoot) {
            out.print(prefix);
            out.print(this.linkFormatter.formatMain(type));
            out.print(this.formatter.format(o, depth, this.getSession()));
            skipNewLine = false;
            out.flush();
        }
        if ((children1 = tree.getChildren(o)) == null) {
            children1 = Collections.emptyList();
        }
        Iterator children = children1.iterator();
        Object last = null;
        if (children.hasNext()) {
            last = children.next();
        }
        while (children.hasNext()) {
            Object c = last;
            last = children.next();
            if (skipNewLine) {
                skipNewLine = false;
            } else {
                out.println();
            }
            this.print(tree, prefix + this.linkFormatter.formatChild(type), NutsPositionType.CENTER, c, out, false, depth + 1);
        }
        if (last != null) {
            if (skipNewLine) {
                skipNewLine = false;
            } else {
                out.println();
            }
            this.print(tree, prefix + this.linkFormatter.formatChild(type), this.infinite && "".equals(prefix) ? NutsPositionType.CENTER : NutsPositionType.LAST, last, out, false, depth + 1);
        }
        out.flush();
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--border": {
                a = cmdLine.nextString(new String[]{"--border"});
                if (enabled) {
                    switch (a.getValue().getString("")) {
                        case "simple": {
                            this.setLinkFormat(LINK_ASCII_FORMATTER);
                            break;
                        }
                        case "none": {
                            this.setLinkFormat(LINK_SPACE_FORMATTER);
                        }
                    }
                }
                return true;
            }
            case "--omit-root": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitRoot(val);
                }
                return true;
            }
            case "--infinite": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.infinite = val;
                }
                return true;
            }
            case "--multiline-property": {
                NutsArgument i = cmdLine.nextString(new String[0]);
                if (enabled) {
                    this.addMultilineProperty(i.getKey().getString(), i.getValue().getString());
                }
                return true;
            }
        }
        return false;
    }

    public Object getValue() {
        return this.tree;
    }

    public DefaultNutsTreeFormat addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    private NutsString[] getMultilineArray(NutsString key, Object value) {
        String sep = this.getMultilineSeparator(key);
        if (sep == null) {
            return null;
        }
        String[] vv = CoreStringUtils.stringValue(value).split(sep);
        if (vv.length == 0 || vv.length == 1) {
            return null;
        }
        return (NutsString[])Arrays.stream(vv).map(x -> NutsTexts.of((NutsSession)this.getSession()).toText(x)).toArray(NutsString[]::new);
    }

    private String getMultilineSeparator(NutsString key) {
        String sep = this.multilineProperties.get(key.toString());
        if (sep != null && sep.length() == 0) {
            sep = ":|;";
        }
        return sep;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

