/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.table;

import java.util.Arrays;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.NutsIdFormatHelper;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;

public class DefaultSearchFormatTable
extends DefaultSearchFormatBase {
    private NutsTableFormat table;
    private NutsMutableTableModel model;

    public DefaultSearchFormatTable(NutsSession session, NutsPrintStream writer, NutsFetchDisplayOptions options) {
        super(session, writer, NutsContentType.TABLE, options);
    }

    public NutsMutableTableModel getTableModel(NutsSession ws) {
        this.getTable(ws);
        return this.model;
    }

    public NutsTableFormat getTable(NutsSession ws) {
        if (this.table == null) {
            this.table = NutsTableFormat.of((NutsSession)ws);
            this.model = NutsMutableTableModel.of((NutsSession)ws);
            this.table.setValue((Object)this.model);
            if (this.getSession() != null && this.getSession().getOutputFormatOptions() != null) {
                for (String outputFormatOption : this.getSession().getOutputFormatOptions()) {
                    if (outputFormatOption == null) continue;
                    this.table.configure(true, NutsCommandLine.of((String)outputFormatOption, (NutsSession)ws));
                }
            }
        }
        return this.table;
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        return this.getDisplayOptions().configureFirst(cmd);
    }

    public void start() {
        this.getTableModel(this.getSession()).addHeaderCells(Arrays.stream(this.getDisplayOptions().getDisplayProperties()).map(x -> CoreEnumUtils.getEnumString(x)).toArray());
    }

    public void next(Object object, long index) {
        NutsIdFormatHelper fid = NutsIdFormatHelper.of(object, this.getSession());
        if (fid != null) {
            this.formatElement(fid, index);
        } else {
            this.getTableModel(this.getSession()).newRow().addCell(object);
        }
        this.getWriter().flush();
    }

    public void formatElement(NutsIdFormatHelper id, long index) {
        this.getTableModel(this.getSession()).newRow().addCells(id.getMultiColumnRow(this.getDisplayOptions()));
    }

    public void complete(long count) {
        this.getTable(this.getSession()).println(this.getWriter());
    }
}

