/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.table;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsMutableTableModel;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableCell;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsMutableTableModel
implements NutsMutableTableModel {
    private final Row header = new Row();
    private final List<Row> rows = new ArrayList<Row>();
    private NutsSession session;

    public DefaultNutsMutableTableModel(NutsSession session) {
        this.session = session;
    }

    public NutsMutableTableModel newRow() {
        this.rows.add(new Row());
        return this;
    }

    public NutsMutableTableModel clearHeader() {
        this.header.cells.clear();
        return this;
    }

    public NutsMutableTableModel addHeaderCells(Object ... values) {
        for (Object value : values) {
            this.addHeaderCell(value);
        }
        return this;
    }

    public NutsMutableTableModel addHeaderCell(Object value) {
        DefaultCell c = new DefaultCell();
        c.value = value;
        this.header.cells.add(c);
        return this;
    }

    public NutsMutableTableModel addRow(Object ... values) {
        this.newRow();
        this.addCells(values);
        return this;
    }

    public NutsMutableTableModel addCells(Object ... values) {
        for (Object value : values) {
            this.addCell(value);
        }
        return this;
    }

    public NutsMutableTableModel addCell(Object value) {
        if (this.rows.isEmpty()) {
            this.newRow();
        }
        DefaultCell c = new DefaultCell();
        c.value = value;
        this.rows.get((int)(this.rows.size() - 1)).cells.add(c);
        return this;
    }

    public int getColumnsCount() {
        int c = this.header.cells.size();
        for (Row row : this.rows) {
            c = Math.max(c, row.cells.size());
        }
        return c;
    }

    public Object getCellValue(int row, int column) {
        return this.rows.get((int)row).cells.get((int)column).value;
    }

    public int getCellColSpan(int row, int column) {
        return this.rows.get((int)row).cells.get((int)column).colspan;
    }

    public int getCellRowSpan(int row, int column) {
        return this.rows.get((int)row).cells.get((int)column).rowspan;
    }

    public Object getHeaderValue(int column) {
        return this.header.cells.get((int)column).value;
    }

    public int getHeaderColSpan(int column) {
        return this.header.cells.get((int)column).colspan;
    }

    public int getRowsCount() {
        return this.rows.size();
    }

    public NutsMutableTableModel setCellValue(int row, int column, Object value) {
        this.rows.get((int)row).cells.get((int)column).value = value;
        return this;
    }

    public NutsMutableTableModel setCellColSpan(int row, int column, int value) {
        this.rows.get((int)row).cells.get((int)column).colspan = value;
        return this;
    }

    public NutsMutableTableModel setCellRowSpan(int row, int column, int value) {
        this.rows.get((int)row).cells.get((int)column).rowspan = value;
        return this;
    }

    public NutsMutableTableModel setHeaderValue(int column, Object value) {
        this.header.cells.get((int)column).value = value;
        return this;
    }

    public NutsMutableTableModel setHeaderColSpan(int column, int value) {
        this.header.cells.get((int)column).colspan = value;
        return this;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public static class DefaultCell
    implements NutsTableCell {
        int colspan = 1;
        int rowspan = 1;
        int x;
        int y;
        Object value;

        public int getColspan() {
            return this.colspan;
        }

        public DefaultCell setColspan(int colspan) {
            this.colspan = colspan <= 0 ? 1 : colspan;
            return this;
        }

        public int getRowspan() {
            return this.rowspan;
        }

        public DefaultCell setRowspan(int rowspan) {
            this.rowspan = rowspan <= 0 ? 1 : rowspan;
            return this;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Object getValue() {
            return this.value;
        }

        public DefaultCell setValue(Object value) {
            this.value = value;
            return this;
        }

        public String toString() {
            return "Cell{" + this.x + "->" + (this.x + this.colspan) + ", " + this.y + "->" + (this.y + this.rowspan) + ", " + this.value + '}';
        }
    }

    public static class Row {
        List<DefaultCell> cells = new ArrayList<DefaultCell>();
    }
}

