/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.props;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPropertiesFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.ObjectOutputFormatWriterHelper;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.text.util.NutsTextUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsPropertiesFormat
extends DefaultFormatBase<NutsPropertiesFormat>
implements NutsPropertiesFormat {
    public static final String OPTION_MULTILINE_PROPERTY = "--multiline-property";
    private boolean sorted;
    private boolean compact;
    private boolean javaProps;
    private String rootName = "";
    private final boolean omitNull = true;
    private boolean escapeText = true;
    private String separator = " = ";
    private Object value;
    private Map<String, String> multilineProperties = new HashMap<String, String>();

    public DefaultNutsPropertiesFormat(NutsSession session) {
        super(session, "props-format");
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        NutsArgument a = commandLine.nextString(new String[]{OPTION_MULTILINE_PROPERTY});
        if (a != null) {
            NutsArgument i = NutsArgument.of((String)a.getValue().getString(), (NutsSession)this.getSession());
            if (i.isActive()) {
                this.addMultilineProperty(i.getKey().getString(), i.getValue().getString());
            }
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"--compact"});
        if (a != null) {
            if (a.isActive()) {
                this.compact = a.getBooleanValue();
            }
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"--props"});
        if (a != null) {
            if (a.isActive()) {
                this.javaProps = a.getBooleanValue();
            }
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"--escape-text"});
        if (a != null) {
            if (a.isActive()) {
                this.escapeText = a.getBooleanValue();
            }
            return true;
        }
        return false;
    }

    public DefaultNutsPropertiesFormat addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    public Map buildModel() {
        Object value = NutsElements.of((NutsSession)this.getSession()).setIndestructibleFormat().destruct(this.getValue());
        LinkedHashMap<NutsString, NutsString> map = new LinkedHashMap<NutsString, NutsString>();
        this.fillMap(NutsString.of((String)(this.rootName == null ? "" : this.rootName), (NutsSession)this.getSession()), value, map);
        return map;
    }

    private void fillMap(NutsString entryKey, Object entryValue, Map<NutsString, NutsString> map) {
        if (entryValue instanceof Map) {
            for (Map.Entry entry : ((Map)entryValue).entrySet()) {
                Object k = entry.getKey();
                NutsString ns = entryKey.isEmpty() ? this.stringValue(k) : entryKey.builder().append((Object)".").append((Object)this.stringValue(k));
                Object v = entry.getValue();
                this.fillMap(ns, v, map);
            }
        } else if (entryValue instanceof NutsObjectElement) {
            for (NutsElementEntry entry : (NutsObjectElement)entryValue) {
                NutsElement k = entry.getKey();
                NutsString ns = entryKey.isEmpty() ? this.stringValue(k) : entryKey.builder().append((Object)".").append((Object)this.stringValue(k));
                NutsElement v = entry.getValue();
                this.fillMap(ns, v, map);
            }
        } else if (entryValue instanceof List) {
            List objects = (List)entryValue;
            for (int i = 0; i < objects.size(); ++i) {
                NutsTextBuilder ns = entryKey.builder().append((Object)"[").append((Object)this.stringValue(i + 1)).append((Object)"]");
                this.fillMap((NutsString)ns, objects.get(i), map);
            }
        } else if (entryValue instanceof NutsArrayElement) {
            NutsArrayElement objects = (NutsArrayElement)entryValue;
            for (int i = 0; i < objects.size(); ++i) {
                NutsTextBuilder ns = entryKey.builder().append((Object)"[").append((Object)this.stringValue(i + 1)).append((Object)"]");
                this.fillMap((NutsString)ns, objects.get(i), map);
            }
        } else if (entryValue != null) {
            if (!entryKey.isEmpty()) {
                map.put(entryKey, this.stringValue(entryValue));
            } else {
                map.put(NutsString.of((String)"value", (NutsSession)this.getSession()), this.stringValue(entryValue));
            }
        }
    }

    public Map getModel() {
        return this.buildModel();
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public String getSeparator() {
        return this.separator;
    }

    public DefaultNutsPropertiesFormat setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public DefaultNutsPropertiesFormat setSorted(boolean sort) {
        this.sorted = sort;
        return this;
    }

    @Override
    public void print(NutsPrintStream w) {
        LinkedHashMap<Object, Object> mm;
        this.checkSession();
        NutsPrintStream out = this.getValidPrintStream(w);
        LinkedHashMap<Object, Object> model = this.buildModel();
        if (this.sorted) {
            mm = new LinkedHashMap<Object, Object>();
            ArrayList keys = new ArrayList(model.keySet());
            if (this.sorted) {
                keys.sort(null);
            }
            for (Object k : keys) {
                Object v = model.get(k);
                mm.put(k, v);
            }
        } else {
            mm = model;
        }
        if (this.javaProps) {
            CoreIOUtils.storeProperties(ObjectOutputFormatWriterHelper.explodeMap(mm), w.asPrintStream(), this.sorted, this.getSession());
        } else {
            this.printMap(out, (NutsString)NutsTexts.of((NutsSession)this.getSession()).ofBlank(), mm);
        }
    }

    private void printMap(NutsPrintStream out, NutsString prefix, Map<Object, Object> props) {
        int len = 1;
        for (Object extraKey : props.keySet()) {
            int x = this.stringValue(extraKey).textLength();
            if (x <= len) continue;
            len = x;
        }
        boolean first = true;
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.println();
            }
            this.printKeyValue(out, prefix, len, this.stringValue(e.getKey()), this.stringValue(e.getValue()));
        }
        out.flush();
    }

    private String getMultilineSeparator(NutsString key) {
        String sep = this.multilineProperties.get(key.filteredText());
        if (sep != null && sep.length() == 0) {
            sep = ":|;";
        }
        return sep;
    }

    private void printKeyValue(NutsPrintStream out, NutsString prefix, int len, NutsString key, NutsString value) {
        this.printKeyValue(out, prefix, len, this.getMultilineSeparator(key), key, value);
    }

    private void printKeyValue(NutsPrintStream out, NutsString prefix, int len, String fancySep, NutsString key, NutsString value) {
        NutsString formattedKey;
        NutsTexts txt = NutsTexts.of((NutsSession)this.getSession());
        if (prefix == null) {
            prefix = txt.ofBlank();
        }
        Object object = formattedKey = this.compact ? key : txt.builder().append((Object)key).append((Object)CoreStringUtils.fillString(' ', len - key.textLength()));
        if (fancySep != null) {
            NutsString cc = this.compact ? key : txt.ofPlain(CoreStringUtils.alignLeft("", len + 3));
            String[] split = value.toString().split(fancySep);
            if (split.length == 0) {
                out.print(prefix);
                out.print(formattedKey);
                out.print(this.separator);
            } else {
                for (int i = 0; i < split.length; ++i) {
                    String s = split[i];
                    if (i == 0) {
                        out.print(prefix);
                        if (prefix.isEmpty() || prefix.toString().endsWith("#")) {
                            out.print('\u001e');
                        }
                        out.printf("%s", new Object[]{formattedKey});
                        if (this.separator.isEmpty() || this.separator.startsWith("#")) {
                            out.print('\u001e');
                        }
                        out.print(this.separator);
                        out.print(s);
                        continue;
                    }
                    out.println();
                    out.printf("%s", new Object[]{cc});
                    out.print(s);
                }
            }
        } else {
            out.print(prefix);
            if (prefix.isEmpty() || prefix.toString().endsWith("#")) {
                out.print('\u001e');
            }
            out.printf("%s", new Object[]{txt.ofStyled(formattedKey, NutsTextStyle.primary3())});
            if (this.separator.isEmpty() || this.separator.startsWith("#")) {
                out.print('\u001e');
            }
            out.print(this.separator);
            out.print(value);
        }
    }

    private NutsString stringValue(Object o) {
        if (this.escapeText) {
            return NutsTextUtils.stringValueFormatted(o, this.escapeText, this.getSession());
        }
        return NutsTexts.of((NutsSession)this.getSession()).toText(o);
    }

    public Object getValue() {
        return this.value;
    }

    public NutsPropertiesFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

