/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.plain;

import java.util.ArrayList;
import java.util.Formattable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsContentTypeFormat;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPropertiesFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTableModel;
import net.thevpc.nuts.NutsTreeFormat;
import net.thevpc.nuts.NutsTreeModel;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.xml.NutsXmlUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NutsFormatPlain
extends DefaultFormatBase<NutsContentTypeFormat>
implements NutsContentTypeFormat {
    private final String rootName = "";
    private final List<String> extraConfig = new ArrayList<String>();
    private final Map<String, String> multilineProperties = new HashMap<String, String>();
    private Object value;
    private boolean compact;

    public NutsFormatPlain(NutsSession session) {
        super(session, NutsContentType.PLAIN.id() + "-format");
    }

    public Object getValue() {
        return this.value;
    }

    public NutsContentTypeFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        NutsArgument n = commandLine.peek();
        if (n != null) {
            boolean enabled = n.isActive();
            NutsArgument a = commandLine.nextString(new String[]{"--multiline-property"});
            if (a != null) {
                if (enabled) {
                    NutsArgument i = NutsArgument.of((String)a.getValue().getString(), (NutsSession)this.getSession());
                    this.extraConfig.add(a.getString());
                    this.addMultilineProperty(i.getKey().getString(), i.getValue().getString());
                }
            } else {
                a = commandLine.next();
                if (!a.isOption() || a.isActive()) {
                    this.extraConfig.add(a.getString());
                }
            }
            return true;
        }
        return false;
    }

    public NutsContentTypeFormat addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    private String getFormattedPrimitiveValue(NutsElement value) {
        switch (value.type()) {
            default: 
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid element type: %s", (Object[])new Object[]{value.type()}));
    }

    @Override
    public void print(NutsPrintStream w) {
        this.checkSession();
        Object value = this.getValue();
        NutsSession session = this.getSession();
        if (value instanceof NutsTableModel) {
            NutsTableFormat.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
        } else if (value instanceof NutsTreeModel) {
            NutsTreeFormat.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
        } else if (value instanceof Properties) {
            NutsPropertiesFormat.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
        } else if (value instanceof NutsElement) {
            NutsElements.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).setCompact(this.isCompact()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
        } else if (value instanceof Document) {
            NutsXmlUtils.writeDocument((Document)value, new StreamResult(w.asPrintStream()), false, true, this.getSession());
        } else if (value instanceof Element) {
            Element elem = (Element)value;
            Document doc = NutsXmlUtils.createDocument(this.getSession());
            doc.appendChild(doc.importNode(elem, true));
            NutsXmlUtils.writeDocument(doc, new StreamResult(w.asPrintStream()), false, false, this.getSession());
        } else {
            NutsElements element = NutsElements.of((NutsSession)session);
            Object newVal = element.setNtf(true).setIndestructibleFormat().destruct(value);
            Flags f = new Flags();
            this.collectFlags(newVal, f, 300);
            if (f.map) {
                if (f.msg || f.formattable) {
                    NutsTreeFormat.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
                } else if (f.elems) {
                    NutsElements.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
                } else {
                    NutsElements.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
                }
            } else if (f.list) {
                if (f.msg || f.formattable) {
                    NutsTableFormat.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
                } else if (f.elems) {
                    NutsElements.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
                } else {
                    NutsElements.of((NutsSession)session).setValue(value).setNtf(this.isNtf()).configure(true, this.extraConfig.toArray(new String[0])).print(w);
                }
            } else {
                NutsPrintStream out = this.getValidPrintStream(w);
                out.printf("%s", new Object[]{value});
                out.flush();
            }
        }
    }

    public void collectFlags(Object value, Flags flags, int depth) {
        if (depth < 0) {
            return;
        }
        if (value instanceof Map) {
            flags.map = true;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                this.collectFlags(entry.getKey(), flags, depth - 1);
                this.collectFlags(entry.getValue(), flags, depth - 1);
            }
        } else if (value instanceof List) {
            flags.list = true;
            Flags f2 = new Flags();
            for (Object entry : (List)value) {
                this.collectFlags(entry, f2, depth - 1);
            }
            if (f2.list || f2.map) {
                flags.map = true;
            }
            flags.elems |= f2.elems;
            flags.msg |= f2.msg;
            flags.primitives |= f2.primitives;
            flags.formattable |= f2.formattable;
        } else if (value instanceof Formattable) {
            flags.formattable = true;
        } else if (value instanceof NutsElement) {
            flags.elems = true;
            if (value instanceof NutsObjectElement) {
                flags.map = true;
            } else if (value instanceof NutsArrayElement) {
                flags.list = true;
            }
        } else if (value instanceof NutsMessage) {
            flags.msg = true;
        } else {
            flags.primitives = true;
        }
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    @Override
    public NutsFormatPlain setNtf(boolean ntf) {
        return (NutsFormatPlain)super.setNtf(ntf);
    }

    public boolean isCompact() {
        return this.compact;
    }

    public NutsFormatPlain setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    private static class Flags {
        boolean elems;
        boolean list;
        boolean map;
        boolean primitives;
        boolean msg;
        boolean formattable;

        private Flags() {
        }
    }
}

