/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.json;

import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsSession;

public class JsonStatus {
    public int countBraces;
    public int openBraces;
    public int openBrackets;
    public boolean openAntiSlash;
    public boolean openSimpleQuotes;
    public boolean openDoubleQuotes;
    public NutsSession session;

    public JsonStatus(NutsSession session) {
        this.session = session;
    }

    public boolean checkValid(boolean throwError) {
        if (!this.checkPartialValid(throwError)) {
            return false;
        }
        if (this.countBraces == 0) {
            if (throwError) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"not an object", (Object[])new Object[0]));
            }
            return false;
        }
        if (this.openBrackets > 0) {
            if (throwError) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unbalanced brackets", (Object[])new Object[0]));
            }
            return false;
        }
        if (this.openBraces > 0) {
            if (throwError) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unbalanced braces", (Object[])new Object[0]));
            }
            return false;
        }
        if (this.openAntiSlash && throwError) {
            throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unbalanced anti-slash", (Object[])new Object[0]));
        }
        if (this.openSimpleQuotes) {
            if (throwError) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unbalanced simple quotes", (Object[])new Object[0]));
            }
            return false;
        }
        if (this.openDoubleQuotes) {
            if (throwError) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unbalanced double quotes", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public boolean checkPartialValid(boolean throwError) {
        if (this.openBrackets < 0) {
            if (throwError) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unbalanced brackets", (Object[])new Object[0]));
            }
            return false;
        }
        if (this.openBraces < 0) {
            if (throwError) {
                throw new NutsParseException(this.session, NutsMessage.cstyle((String)"unbalanced braces", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }
}

