/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.json;

import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCodeHighlighter;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;

public class DefaultSearchFormatJson
extends DefaultSearchFormatBase {
    private boolean compact;
    NutsTexts txt;
    private NutsCodeHighlighter codeFormat;

    public DefaultSearchFormatJson(NutsSession session, NutsPrintStream writer, NutsFetchDisplayOptions options) {
        super(session, writer, NutsContentType.JSON, options);
        this.txt = NutsTexts.of((NutsSession)session);
        this.codeFormat = NutsTexts.of((NutsSession)session).setSession(session).getCodeHighlighter("json");
    }

    public void start() {
        this.getWriter().println((NutsString)this.codeFormat.tokenToText("[", "separator", this.txt, this.getSession()));
        this.getWriter().flush();
    }

    public void complete(long count) {
        this.getWriter().println((NutsString)this.codeFormat.tokenToText("]", "separator", this.txt, this.getSession()));
        this.getWriter().flush();
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        if (this.getDisplayOptions().configureFirst(cmd)) {
            return true;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--compact": {
                boolean val = cmd.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.compact = val;
                }
                return true;
            }
        }
        return false;
    }

    public void next(Object object, long index) {
        if (index > 0L) {
            this.getWriter().print(", ");
        } else {
            this.getWriter().print("  ");
        }
        String json = NutsElements.of((NutsSession)this.getSession()).json().setNtf(false).setValue(object).setCompact(this.isCompact()).format().filteredText();
        NutsText ee = this.codeFormat.stringToText(json, this.txt, this.getSession());
        this.getWriter().printf("%s%n", new Object[]{ee});
        this.getWriter().flush();
    }

    public boolean isCompact() {
        return this.compact;
    }
}

