/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionEntries;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsInstallInformation;
import net.thevpc.nuts.NutsInstallStatus;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryEvent;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.runtime.standalone.format.NutsDisplayProperty;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NutsInstalledRepository;
import net.thevpc.nuts.runtime.standalone.text.util.NutsTextUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigManagerExt;

public class NutsIdFormatHelper {
    private NutsLogger LOG;
    NutsId id;
    NutsInstallStatus installStatus = NutsInstallStatus.NONE;
    Boolean executable = null;
    Boolean executableApp = null;
    boolean fetched = false;
    boolean checkDependencies = false;
    NutsDefinition defFetched;
    NutsDefinition def;
    NutsDescriptor desc;
    NutsDependency dep;
    NutsSession session;
    Instant dte;
    String usr;
    char status_f;
    char status_e;
    char status_i;
    char status_s;
    char status_o;
    boolean built = false;
    boolean ntf = true;

    public static NutsIdFormatHelper of(Object object, NutsSession session) {
        if (object instanceof NutsId) {
            NutsId v = (NutsId)object;
            return new NutsIdFormatHelper(v, session);
        }
        if (object instanceof NutsDescriptor) {
            NutsDescriptor v = (NutsDescriptor)object;
            return new NutsIdFormatHelper(v, session);
        }
        if (object instanceof NutsDefinition) {
            NutsDefinition v = (NutsDefinition)object;
            return new NutsIdFormatHelper(v, session);
        }
        if (object instanceof NutsDependency) {
            NutsDependency v = (NutsDependency)object;
            return new NutsIdFormatHelper(v, session);
        }
        if (object instanceof NutsDependencyTreeNode) {
            NutsDependencyTreeNode v = (NutsDependencyTreeNode)object;
            return new NutsIdFormatHelper(v, session);
        }
        return null;
    }

    public NutsIdFormatHelper(NutsDependencyTreeNode id, NutsSession session) {
        this(null, null, null, id.getDependency(), session);
    }

    public NutsIdFormatHelper(NutsId id, NutsSession session) {
        this(id, null, null, null, session);
    }

    public NutsIdFormatHelper(NutsDescriptor desc, NutsSession session) {
        this(null, desc, null, null, session);
    }

    public NutsIdFormatHelper(NutsDefinition def, NutsSession session) {
        this(null, null, def, null, session);
    }

    public NutsIdFormatHelper(NutsDependency dep, NutsSession session) {
        this(null, null, null, dep, session);
    }

    private NutsIdFormatHelper(NutsId id, NutsDescriptor desc, NutsDefinition def, NutsDependency dep, NutsSession session) {
        this.LOG = NutsLogger.of(NutsIdFormatHelper.class, (NutsSession)session);
        if (id == null) {
            if (def != null) {
                id = def.getId();
            } else if (desc != null) {
                id = desc.getId();
            } else if (dep != null) {
                id = dep.toId();
            }
        }
        if (desc == null && def != null) {
            desc = def.getDescriptor();
        }
        this.session = session;
        this.id = id;
        this.def = def;
        this.dep = dep;
        this.desc = desc;
    }

    public String[] getMultiColumnRowStrings(NutsFetchDisplayOptions oo) {
        Object[] oa = this.getMultiColumnRow(oo);
        String[] ss = new String[oa.length];
        for (int i = 0; i < oa.length; ++i) {
            ss[i] = String.valueOf(oa[i]);
        }
        return ss;
    }

    public Object[] getMultiColumnRow(NutsFetchDisplayOptions oo) {
        NutsDisplayProperty[] a = oo.getDisplayProperties();
        Object[] b = new Object[a.length];
        for (int j = 0; j < b.length; ++j) {
            b[j] = this.buildMain(oo, a[j]);
        }
        return b;
    }

    private static FormatHelper getFormatHelper(NutsSession session) {
        FormatHelper h = (FormatHelper)session.env().getProperties().get(FormatHelper.class.getName());
        if (h != null) {
            return h;
        }
        FormatHelperResetListener h2 = (FormatHelperResetListener)session.env().getProperty(FormatHelperResetListener.class.getName());
        if (h2 == null) {
            h2 = new FormatHelperResetListener();
            session.events().addWorkspaceListener((NutsWorkspaceListener)h2);
        }
        h = new FormatHelper(session);
        session.env().setProperty(FormatHelper.class.getName(), (Object)h);
        return h;
    }

    public NutsString getSingleColumnRow(NutsFetchDisplayOptions oo) {
        NutsDisplayProperty[] a = oo.getDisplayProperties();
        NutsTexts txt = NutsTexts.of((NutsSession)this.session);
        NutsTextBuilder sb = txt.builder();
        for (int j = 0; j < a.length; ++j) {
            NutsString s = this.buildMain(oo, a[j]);
            int z = 0;
            switch (a[j]) {
                case INSTALL_DATE: {
                    z = 23;
                    break;
                }
                case REPOSITORY: {
                    z = NutsIdFormatHelper.getFormatHelper(this.session).maxRepoNameSize();
                    break;
                }
                case REPOSITORY_ID: {
                    z = 25;
                    break;
                }
                case INSTALL_USER: {
                    z = NutsIdFormatHelper.getFormatHelper(this.session).maxUserNameSize();
                }
            }
            int len = txt.builder().append((Object)s).textLength();
            if (j > 0) {
                sb.append((Object)Character.valueOf(' '));
            }
            sb.append((Object)s);
            if (len >= z) continue;
            char[] c = new char[z - len];
            Arrays.fill(c, ' ');
            sb.append((Object)new String(c));
        }
        return sb.immutable();
    }

    public NutsString buildMain(NutsFetchDisplayOptions oo, NutsDisplayProperty dp) {
        NutsSession ws = this.session;
        NutsTexts text = NutsTexts.of((NutsSession)ws);
        if (oo.isRequireDefinition()) {
            this.buildLong();
        }
        if (dp == null) {
            dp = NutsDisplayProperty.ID;
        }
        switch (dp) {
            case ID: {
                return oo.getIdFormat().setValue(this.id).setNtf(this.ntf).format();
            }
            case STATUS: {
                return this.getFormattedStatusString();
            }
            case FILE: {
                if (this.def != null && this.def.getContent() != null && this.def.getContent().getPath() != null) {
                    return text.toText((Object)this.def.getContent().getPath());
                }
                return text.ofStyled("missing-path", NutsTextStyle.error());
            }
            case FILE_NAME: {
                if (this.def != null && this.def.getContent() != null && this.def.getContent().getPath() != null) {
                    return text.ofPlain(this.def.getContent().getPath().getName());
                }
                return text.ofStyled("missing-file-name", NutsTextStyle.error());
            }
            case ARCH: {
                if (this.desc != null && this.desc.getCondition().getArch().length > 0) {
                    return this.keywordArr1(this.desc.getCondition().getArch());
                }
                return text.ofStyled("missing-arch", NutsTextStyle.error());
            }
            case NAME: {
                if (this.desc != null) {
                    return this.stringValue(this.desc.getName());
                }
                return text.ofStyled("missing-name", NutsTextStyle.error());
            }
            case OS: {
                if (this.desc != null && this.desc.getCondition().getOs().length > 0) {
                    return this.keywordArr2(this.desc.getCondition().getOs());
                }
                return text.ofStyled("missing-os", NutsTextStyle.error());
            }
            case OSDIST: {
                if (this.desc != null && this.desc.getCondition().getOsDist().length > 0) {
                    return this.keywordArr2(this.desc.getCondition().getOsDist());
                }
                return text.ofStyled("missing-osdist", NutsTextStyle.error());
            }
            case PACKAGING: {
                if (this.desc != null) {
                    return text.ofStyled(this.stringValue(this.desc.getPackaging()), NutsTextStyle.primary3());
                }
                return text.ofStyled("missing-packaging", NutsTextStyle.error());
            }
            case PLATFORM: {
                if (this.desc != null && this.desc.getCondition().getPlatform().length > 0) {
                    return this.keywordArr1(this.desc.getCondition().getPlatform());
                }
                return text.ofStyled("missing-platform", NutsTextStyle.error());
            }
            case PROFILE: {
                if (this.desc != null && this.desc.getCondition().getProfile().length > 0) {
                    return this.keywordArr1(this.desc.getCondition().getProfile());
                }
                return text.ofStyled("no-profile", NutsTextStyle.error());
            }
            case DESKTOP_ENVIRONMENT: {
                if (this.desc != null && this.desc.getCondition().getDesktopEnvironment().length > 0) {
                    return this.keywordArr1(this.desc.getCondition().getDesktopEnvironment());
                }
                return text.ofStyled("missing-desktop-environment", NutsTextStyle.error());
            }
            case INSTALL_DATE: {
                if (this.def != null && this.def.getInstallInformation() != null) {
                    return this.stringValue(this.def.getInstallInformation().getCreatedInstant());
                }
                return text.ofStyled("<null>", NutsTextStyle.pale());
            }
            case REPOSITORY: {
                String rname = null;
                if (this.def != null) {
                    NutsRepository r;
                    if (this.def.getRepositoryName() != null) {
                        rname = this.def.getRepositoryName();
                    }
                    if (this.def.getRepositoryUuid() != null && (r = this.session.repos().setSession(this.session.copy().setTransitive(Boolean.valueOf(false))).findRepositoryById(this.def.getRepositoryUuid())) != null) {
                        rname = r.getName();
                    }
                }
                if (rname == null && this.id != null) {
                    rname = this.id.getRepository();
                }
                return this.stringValue(rname);
            }
            case REPOSITORY_ID: {
                String ruuid = null;
                if (this.def != null && this.def.getRepositoryUuid() != null) {
                    ruuid = this.def.getRepositoryUuid();
                }
                if (ruuid == null && this.id != null) {
                    String p = this.id.getRepository();
                    NutsRepository r = this.session.repos().setSession(this.session.copy().setTransitive(Boolean.valueOf(false))).findRepositoryByName(p);
                    if (r != null) {
                        ruuid = r.getUuid();
                    }
                }
                return this.stringValue(ruuid);
            }
            case INSTALL_USER: {
                if (this.def != null && this.def.getInstallInformation() != null) {
                    return this.stringValue(this.def.getInstallInformation().getInstallUser());
                }
                return text.ofStyled("nobody", NutsTextStyle.error());
            }
            case CACHE_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(ws.locations().getStoreLocation(this.def.getId(), NutsStoreLocation.CACHE));
                }
                return text.ofStyled("<null>", NutsTextStyle.error());
            }
            case CONFIG_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(ws.locations().getStoreLocation(this.def.getId(), NutsStoreLocation.CONFIG));
                }
                return text.ofStyled("<null>", NutsTextStyle.error());
            }
            case LIB_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(ws.locations().getStoreLocation(this.def.getId(), NutsStoreLocation.LIB));
                }
                return text.ofStyled("<null>", NutsTextStyle.error());
            }
            case LOG_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(ws.locations().getStoreLocation(this.def.getId(), NutsStoreLocation.LOG));
                }
                return text.ofStyled("<null>", NutsTextStyle.error());
            }
            case TEMP_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(ws.locations().getStoreLocation(this.def.getId(), NutsStoreLocation.TEMP));
                }
                return text.ofStyled("<null>", NutsTextStyle.error());
            }
            case VAR_LOCATION: {
                if (this.def != null) {
                    return this.stringValue(ws.locations().getStoreLocation(this.def.getId(), NutsStoreLocation.VAR));
                }
                return text.ofStyled("<null>", NutsTextStyle.error());
            }
            case APPS_FOLDER: {
                if (this.def != null) {
                    return this.stringValue(ws.locations().getStoreLocation(this.def.getId(), NutsStoreLocation.APPS));
                }
                return text.ofStyled("<null>", NutsTextStyle.error());
            }
            case EXEC_ENTRY: {
                if (this.def != null && this.def.getContent() != null && this.def.getContent().getPath() != null) {
                    ArrayList<NutsTextPlain> results = new ArrayList<NutsTextPlain>();
                    for (NutsExecutionEntry entry : NutsExecutionEntries.of((NutsSession)this.session).parse(this.def.getContent().getFile())) {
                        if (entry.isDefaultEntry()) {
                            results.add(text.ofPlain(entry.getName()));
                            continue;
                        }
                        results.add(text.ofPlain(entry.getName()));
                    }
                    if (results.size() == 1) {
                        return (NutsString)results.get(0);
                    }
                    return text.builder().appendJoined((Object)text.ofPlain(","), results);
                }
                return text.ofStyled("<missing-class>", NutsTextStyle.error());
            }
            case INSTALL_FOLDER: {
                if (this.def != null && this.def.getInstallInformation() != null) {
                    return this.stringValue(this.def.getInstallInformation().getInstallFolder());
                }
                return text.ofStyled("<null>", NutsTextStyle.pale());
            }
            case LONG_STATUS: {
                ArrayList<Object> all = new ArrayList<Object>();
                if (this.def != null && this.def.getDescriptor().getIdType() != null) {
                    switch (this.def.getDescriptor().getIdType()) {
                        case REGULAR: {
                            all.add(text.ofPlain(this.def.getDescriptor().getIdType().id()));
                            break;
                        }
                        default: {
                            all.add(text.ofStyled(this.def.getDescriptor().getIdType().id(), NutsTextStyle.primary1()));
                        }
                    }
                }
                if (this.executableApp.booleanValue()) {
                    all.add(text.ofStyled("application", NutsTextStyle.primary5()));
                } else if (this.executable.booleanValue()) {
                    all.add(text.ofStyled("executable", NutsTextStyle.primary3()));
                } else {
                    all.add(text.ofStyled("library", NutsTextStyle.primary4()));
                }
                if (this.dep != null) {
                    NutsDependencyScope ss = CoreEnumUtils.parseEnumString(this.dep.getScope(), NutsDependencyScope.class, true);
                    if (this.dep.isOptional()) {
                        all.add(text.ofStyled("optional", NutsTextStyle.primary5()));
                    }
                    if (ss != null) {
                        all.add(text.ofStyled(NutsDependencyScope.API.id(), NutsTextStyle.primary5()));
                    }
                }
                return text.builder().appendJoined((Object)text.ofStyled(",", NutsTextStyle.pale()), all).build();
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)dp);
    }

    public NutsIdFormatHelper buildLong() {
        if (!this.built) {
            this.built = true;
            NutsWorkspace ws = this.session.getWorkspace();
            NutsInstalledRepository rr = NutsWorkspaceExt.of(ws).getInstalledRepository();
            this.installStatus = rr.getInstallStatus(this.id, this.session);
            NutsInstallInformation iif = rr.getInstallInformation(this.id, this.session);
            this.dte = iif == null ? null : iif.getCreatedInstant();
            this.usr = iif == null ? null : iif.getInstallUser();
            this.executable = null;
            this.executableApp = null;
            this.fetched = false;
            this.checkDependencies = false;
            this.defFetched = null;
            try {
                if (this.installStatus.isNonDeployed() || this.def == null) {
                    this.defFetched = this.session.fetch().setId(this.id).setSession(this.session.copy().setFetchStrategy(NutsFetchStrategy.OFFLINE)).setContent(true).setOptional(Boolean.valueOf(false)).setDependencies(this.checkDependencies).getResultDefinition();
                    this.fetched = true;
                } else {
                    this.fetched = true;
                }
            }
            catch (Exception ex) {
                this.LOG.with().session(this.session).level(Level.FINE).error((Throwable)ex).log(NutsMessage.jstyle((String)"failed to build id format for {0}", (Object[])new Object[]{this.id}));
            }
            if (this.def != null) {
                this.executable = this.def.getDescriptor().isExecutable();
                this.executableApp = this.def.getDescriptor().isApplication();
            } else if (this.defFetched != null) {
                this.executable = this.defFetched.getDescriptor().isExecutable();
                this.executableApp = this.defFetched.getDescriptor().isApplication();
            } else if (this.desc != null) {
                this.executable = this.desc.isExecutable();
                this.executableApp = this.desc.isApplication();
            }
            this.status_f = (char)(this.installStatus.isDefaultVersion() ? 73 : (this.installStatus.isInstalled() ? 105 : (this.installStatus.isRequired() ? 100 : (this.fetched ? 102 : 114))));
            if (this.def != null) {
                switch (this.def.getDescriptor().getIdType()) {
                    case API: {
                        this.status_e = (char)97;
                        break;
                    }
                    case RUNTIME: {
                        this.status_e = (char)114;
                        break;
                    }
                    case EXTENSION: {
                        this.status_e = (char)101;
                        break;
                    }
                    case COMPANION: {
                        this.status_e = (char)99;
                        break;
                    }
                    case REGULAR: {
                        this.status_e = (char)45;
                        break;
                    }
                    default: {
                        this.status_e = (char)63;
                    }
                }
            }
            this.status_i = this.buildComponentAppStatus();
            this.status_s = (char)45;
            this.status_o = (char)45;
            if (this.dep != null) {
                NutsDependencyScope ss = CoreEnumUtils.parseEnumString(this.dep.getScope(), NutsDependencyScope.class, true);
                if (ss != null) {
                    switch (ss) {
                        case API: {
                            this.status_s = (char)99;
                            break;
                        }
                        case IMPLEMENTATION: {
                            this.status_s = (char)105;
                            break;
                        }
                        case RUNTIME: {
                            this.status_s = (char)114;
                            break;
                        }
                        case SYSTEM: {
                            this.status_s = (char)115;
                            break;
                        }
                        case PROVIDED: {
                            this.status_s = (char)112;
                            break;
                        }
                        case TEST_API: 
                        case TEST_IMPLEMENTATION: 
                        case TEST_PROVIDED: 
                        case TEST_RUNTIME: 
                        case TEST_OTHER: {
                            this.status_s = (char)116;
                            break;
                        }
                        case IMPORT: {
                            this.status_s = (char)109;
                            break;
                        }
                        case OTHER: {
                            this.status_s = (char)79;
                            break;
                        }
                        default: {
                            this.status_s = (char)45;
                        }
                    }
                }
                if (this.dep.isOptional()) {
                    this.status_s = (char)111;
                }
            }
        }
        return this;
    }

    private char buildComponentAppStatus() {
        return (char)(this.executableApp != null ? (this.executableApp.booleanValue() ? 88 : (this.executable.booleanValue() ? 120 : 45)) : 46);
    }

    public NutsString getFormattedStatusString() {
        NutsTexts text = NutsTexts.of((NutsSession)this.session);
        if (this.dep != null) {
            return text.ofStyled("" + this.status_f + this.status_e + this.status_i + this.status_s, NutsTextStyle.primary3());
        }
        return text.ofStyled("" + this.status_f + this.status_e + this.status_i, NutsTextStyle.primary3());
    }

    public String getStatusString() {
        if (this.dep != null) {
            return "" + this.status_f + this.status_e + this.status_i + this.status_s;
        }
        return "" + this.status_f + this.status_e + this.status_i;
    }

    private NutsString keywordArr1(String[] any) {
        return this.keywordArr0(any, NutsTextStyle.primary1());
    }

    private NutsString keywordArr2(String[] any) {
        return this.keywordArr0(any, NutsTextStyle.primary3());
    }

    private NutsString keywordArr0(String[] any, NutsTextStyle style) {
        NutsTexts txt = NutsTexts.of((NutsSession)this.session);
        if (any == null || any.length == 0) {
            return txt.ofBlank();
        }
        if (any.length == 1) {
            return txt.builder().append((NutsText)txt.ofStyled(this.stringValue(any[0]), style)).immutable();
        }
        return txt.builder().append((Object)"[").appendJoined((Object)txt.ofPlain(","), (Collection)Arrays.stream(any).map(x -> txt.ofStyled(this.stringValue(x), style)).collect(Collectors.toList())).append((Object)"]").immutable();
    }

    private NutsString stringValue(Object any) {
        return NutsTextUtils.stringValueFormatted(any, false, this.session);
    }

    public static class FormatHelper {
        NutsSession session;
        private Integer maxRepoNameSize;
        private Integer maxUserNameSize;

        public FormatHelper(NutsSession session) {
            this.session = session;
        }

        public int maxRepoNameSize() {
            if (this.maxRepoNameSize != null) {
                return this.maxRepoNameSize;
            }
            int z = 0;
            Stack<NutsRepository> stack = new Stack<NutsRepository>();
            for (NutsRepository repository : this.session.repos().setSession(this.session).getRepositories()) {
                stack.push(repository);
            }
            while (!stack.isEmpty()) {
                NutsRepository r = (NutsRepository)stack.pop();
                int n = r.getName().length();
                if (n > z) {
                    z = n;
                }
                if (!r.config().isSupportedMirroring()) continue;
                for (NutsRepository repository : r.config().setSession(this.session).getMirrors()) {
                    stack.push(repository);
                }
            }
            this.maxRepoNameSize = z;
            return this.maxRepoNameSize;
        }

        public int maxUserNameSize() {
            if (this.maxUserNameSize != null) {
                return this.maxUserNameSize;
            }
            int z = "anonymous".length();
            NutsWorkspaceConfigManagerExt wc = NutsWorkspaceConfigManagerExt.of(this.session.config());
            NutsUserConfig[] users = wc.getModel().getStoredConfigSecurity().getUsers();
            if (users != null) {
                for (NutsUserConfig user : users) {
                    String s = user.getUser();
                    if (s == null) continue;
                    z = Math.max(s.length(), z);
                }
            }
            Stack<Object> stack = new Stack<Object>();
            for (NutsRepository repository : this.session.repos().getRepositories()) {
                stack.push(repository);
            }
            while (!stack.isEmpty()) {
                NutsRepository r = (NutsRepository)stack.pop();
                NutsRepositoryConfigManagerExt rc = NutsRepositoryConfigManagerExt.of(r.config());
                NutsUserConfig[] users1 = rc.getModel().getUsers(this.session);
                if (users1 != null) {
                    for (NutsUserConfig nutsUserConfig : users1) {
                        String s = nutsUserConfig.getUser();
                        if (s == null) continue;
                        z = Math.max(s.length(), z);
                    }
                }
                if (!r.config().isSupportedMirroring()) continue;
                for (NutsUserConfig nutsUserConfig : r.config().setSession(this.session).getMirrors()) {
                    stack.push(nutsUserConfig);
                }
            }
            this.maxUserNameSize = z;
            return this.maxUserNameSize;
        }
    }

    public static class FormatHelperResetListener
    implements NutsWorkspaceListener,
    NutsRepositoryListener {
        private void _onReset(NutsSession ws) {
            ws.env().setProperty(FormatHelper.class.getName(), null);
        }

        public void onAddRepository(NutsWorkspaceEvent event) {
            this._onReset(event.getSession());
        }

        public void onRemoveRepository(NutsWorkspaceEvent event) {
            this._onReset(event.getSession());
        }

        public void onReloadWorkspace(NutsWorkspaceEvent event) {
            this._onReset(event.getSession());
        }

        public void onCreateWorkspace(NutsWorkspaceEvent event) {
            this._onReset(event.getSession());
        }

        public void onUpdateProperty(NutsWorkspaceEvent event) {
        }

        public void onAddRepository(NutsRepositoryEvent event) {
            this._onReset(event.getSession());
        }

        public void onRemoveRepository(NutsRepositoryEvent event) {
            this._onReset(event.getSession());
        }

        public void onConfigurationChanged(NutsRepositoryEvent event) {
            this._onReset(event.getSession());
        }

        public void onConfigurationChanged(NutsWorkspaceEvent event) {
            this._onReset(event.getSession());
        }
    }
}

