/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.util.Map;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

public class NutsFormatUtils {
    public static void putAllInProps(String prefix, Map<String, String> dest, NutsElement value) {
        switch (value.type()) {
            case BOOLEAN: 
            case INSTANT: 
            case INTEGER: 
            case FLOAT: 
            case STRING: 
            case NULL: {
                dest.put(prefix, CoreStringUtils.stringValue(value.asPrimitive().getValue()));
                break;
            }
            case OBJECT: {
                prefix = !NutsBlankable.isBlank((String)prefix) ? prefix + "." : "";
                for (NutsElementEntry e : value.asObject().children()) {
                    NutsFormatUtils.putAllInProps(prefix + e.getKey(), dest, e.getValue());
                }
                break;
            }
            case ARRAY: {
                prefix = !NutsBlankable.isBlank((String)prefix) ? prefix + "." : "";
                int i = 0;
                for (NutsElement e : value.asArray().children()) {
                    NutsFormatUtils.putAllInProps(prefix + (i + 1), dest, e);
                    ++i;
                }
                break;
            }
        }
    }
}

