/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.format.NutsDisplayProperty;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;

public class NutsFetchDisplayOptions {
    public static NutsDisplayProperty[] DISPLAY_LONG = new NutsDisplayProperty[]{NutsDisplayProperty.STATUS, NutsDisplayProperty.INSTALL_DATE, NutsDisplayProperty.INSTALL_USER, NutsDisplayProperty.REPOSITORY, NutsDisplayProperty.ID};
    public static NutsDisplayProperty[] DISPLAY_LONG_LONG = new NutsDisplayProperty[]{NutsDisplayProperty.LONG_STATUS, NutsDisplayProperty.INSTALL_DATE, NutsDisplayProperty.INSTALL_USER, NutsDisplayProperty.REPOSITORY, NutsDisplayProperty.ID};
    public static NutsDisplayProperty[] DISPLAY_MIN = new NutsDisplayProperty[]{NutsDisplayProperty.ID};
    private NutsIdFormat idFormat;
    private List<NutsDisplayProperty> displays = new ArrayList<NutsDisplayProperty>();
    private NutsSession ws;

    public NutsFetchDisplayOptions(NutsSession ws) {
        this.ws = ws;
        this.idFormat = NutsIdFormat.of((NutsSession)ws);
        this.idFormat.setHighlightImportedGroupId(true);
        this.idFormat.setOmitOtherProperties(true);
        this.idFormat.setOmitFace(true);
        this.idFormat.setOmitRepository(true);
        this.idFormat.setOmitClassifier(false);
        this.idFormat.setOmitGroupId(false);
        this.idFormat.setOmitImportedGroupId(false);
    }

    public void setIdFormat(NutsIdFormat idFormat) {
        this.idFormat = idFormat;
    }

    public NutsIdFormat getIdFormat() {
        return this.idFormat;
    }

    public NutsDisplayProperty[] getDisplayProperties() {
        if (this.displays.isEmpty()) {
            return new NutsDisplayProperty[]{NutsDisplayProperty.ID};
        }
        return this.displays.toArray(new NutsDisplayProperty[0]);
    }

    public void addDisplay(String[] columns) {
        if (columns != null) {
            this.addDisplay(NutsFetchDisplayOptions.parseNutsDisplayProperty(Arrays.stream(columns).collect(Collectors.joining(","))));
        }
    }

    public void setDisplay(NutsDisplayProperty display) {
        if (display == null) {
            this.setDisplay(new NutsDisplayProperty[0]);
        } else {
            this.setDisplay(new NutsDisplayProperty[]{display});
        }
    }

    public void setDisplay(NutsDisplayProperty[] display) {
        this.displays.clear();
        this.addDisplay(display);
    }

    public void addDisplay(NutsDisplayProperty[] display) {
        if (display != null) {
            for (NutsDisplayProperty t : display) {
                if (t == null) continue;
                this.displays.add(t);
            }
        }
    }

    public void setDisplayLong(boolean longFormat) {
        if (longFormat) {
            this.setDisplay(DISPLAY_LONG);
        } else {
            this.setDisplay(DISPLAY_MIN);
        }
    }

    public boolean isRequireDefinition() {
        for (NutsDisplayProperty display : this.getDisplayProperties()) {
            if (NutsDisplayProperty.ID.equals((Object)display)) continue;
            return true;
        }
        return false;
    }

    public final NutsFetchDisplayOptions configure(boolean skipUnsupported, String ... args) {
        this.configure(false, NutsCommandLine.of((String[])args, (NutsSession)this.ws));
        return this;
    }

    public final boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        boolean conf = false;
        while (commandLine.hasNext()) {
            if (!this.configureFirst(commandLine)) {
                if (skipUnsupported) {
                    commandLine.skip();
                    continue;
                }
                commandLine.unexpectedArgument();
                continue;
            }
            conf = true;
        }
        return conf;
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        if (this.idFormat.configureFirst(cmdLine)) {
            return true;
        }
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        switch (a.getKey().getString()) {
            case "-l": 
            case "--long": {
                a = cmdLine.nextBoolean(new String[0]);
                if (a.isActive()) {
                    if (a.getBooleanValue()) {
                        this.setDisplay(DISPLAY_LONG);
                    } else {
                        this.setDisplay(DISPLAY_MIN);
                    }
                }
                return true;
            }
            case "--ll": 
            case "--long-long": {
                a = cmdLine.nextBoolean(new String[0]);
                if (a.isActive()) {
                    if (a.getBooleanValue()) {
                        this.setDisplay(DISPLAY_LONG_LONG);
                    } else {
                        this.setDisplay(DISPLAY_MIN);
                    }
                }
                return true;
            }
            case "--display": {
                a = cmdLine.nextString(new String[0]);
                if (a.isActive()) {
                    this.setDisplay(NutsFetchDisplayOptions.parseNutsDisplayProperty(a.getValue().getString()));
                }
                return true;
            }
        }
        return false;
    }

    public String[] toCommandLineOptions() {
        ArrayList<String> displayOptionsArgs = new ArrayList<String>();
        if (this.getIdFormat() != null) {
            if (this.getIdFormat().isHighlightImportedGroupId()) {
                displayOptionsArgs.add("--highlight-imported-group");
            }
            if (this.getIdFormat().isOmitOtherProperties()) {
                displayOptionsArgs.add("--omit-env");
            }
            if (this.getIdFormat().isOmitFace()) {
                displayOptionsArgs.add("--omit-face");
            }
            if (this.getIdFormat().isOmitGroupId()) {
                displayOptionsArgs.add("--omit-group");
            }
            if (this.getIdFormat().isOmitImportedGroupId()) {
                displayOptionsArgs.add("--omit-imported-group");
            }
            if (this.getIdFormat().isOmitRepository()) {
                displayOptionsArgs.add("--omit-repo");
            }
            displayOptionsArgs.add("--display=" + String.join((CharSequence)",", Arrays.asList(this.getDisplayProperties()).stream().map(x -> CoreEnumUtils.getEnumString(x)).collect(Collectors.toList())));
        }
        return displayOptionsArgs.toArray(new String[0]);
    }

    public static NutsDisplayProperty[] parseNutsDisplayProperty(String str) {
        String[] dispNames = (str == null ? "" : str).split("[,|; ]");
        HashSet<NutsDisplayProperty> visited = new HashSet<NutsDisplayProperty>();
        block20: for (int i = 0; i < dispNames.length; ++i) {
            switch (dispNames[i]) {
                case "all": {
                    continue block20;
                }
                case "long": {
                    visited.addAll(Arrays.asList(DISPLAY_LONG));
                    continue block20;
                }
                case "long-long": {
                    visited.addAll(Arrays.asList(DISPLAY_LONG_LONG));
                    continue block20;
                }
                default: {
                    visited.add(CoreEnumUtils.parseEnumString(dispNames[i], NutsDisplayProperty.class, true));
                }
            }
        }
        ArrayList<NutsDisplayProperty> all2 = new ArrayList<NutsDisplayProperty>();
        block21: for (int i = 0; i < dispNames.length; ++i) {
            switch (dispNames[i]) {
                case "all": {
                    for (NutsDisplayProperty value : NutsDisplayProperty.values()) {
                        if (visited.contains((Object)value)) continue;
                        all2.add(value);
                    }
                    continue block21;
                }
                case "long": {
                    all2.addAll(Arrays.asList(DISPLAY_LONG));
                    continue block21;
                }
                case "long-long": {
                    all2.addAll(Arrays.asList(DISPLAY_LONG_LONG));
                    continue block21;
                }
                default: {
                    all2.add(CoreEnumUtils.parseEnumString(dispNames[i], NutsDisplayProperty.class, false));
                }
            }
        }
        return all2.toArray(new NutsDisplayProperty[0]);
    }

    public String toString() {
        return "NutsFetchDisplayOptions{idFormat=" + this.idFormat + ", displays=" + this.displays + '}';
    }
}

