/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsParseEnumException;
import net.thevpc.nuts.NutsSession;

public enum NutsDisplayProperty implements NutsEnum
{
    STATUS,
    INSTALL_DATE,
    INSTALL_USER,
    INSTALL_FOLDER,
    REPOSITORY,
    REPOSITORY_ID,
    ID,
    NAME,
    ARCH,
    PACKAGING,
    PLATFORM,
    PROFILE,
    DESKTOP_ENVIRONMENT,
    OS,
    OSDIST,
    EXEC_ENTRY,
    FILE_NAME,
    FILE,
    VAR_LOCATION,
    TEMP_FOLDER,
    CONFIG_FOLDER,
    LIB_FOLDER,
    LOG_FOLDER,
    CACHE_FOLDER,
    APPS_FOLDER,
    LONG_STATUS;

    private String id = this.name().toLowerCase().replace('_', '-');

    public String id() {
        return this.id;
    }

    public static NutsDisplayProperty parseLenient(String value) {
        return NutsDisplayProperty.parseLenient(value, null);
    }

    public static NutsDisplayProperty parseLenient(String value, NutsDisplayProperty emptyOrErrorValue) {
        return NutsDisplayProperty.parseLenient(value, emptyOrErrorValue, emptyOrErrorValue);
    }

    public static NutsDisplayProperty parseLenient(String value, NutsDisplayProperty emptyValue, NutsDisplayProperty errorValue) {
        if ((value = value == null ? "" : value.toUpperCase().trim().replace('-', '_')).isEmpty()) {
            return emptyValue;
        }
        try {
            return NutsDisplayProperty.valueOf(value.toUpperCase());
        }
        catch (Exception exception) {
            switch (value) {
                case "de": 
                case "desktop": {
                    return DESKTOP_ENVIRONMENT;
                }
                case "osdist": {
                    return OSDIST;
                }
                case "repo": {
                    return REPOSITORY;
                }
                case "repo_id": 
                case "repoid": {
                    return REPOSITORY_ID;
                }
            }
            return errorValue;
        }
    }

    public static NutsDisplayProperty parse(String value, NutsSession session) {
        return NutsDisplayProperty.parse(value, null, session);
    }

    public static NutsDisplayProperty parse(String value, NutsDisplayProperty emptyValue, NutsSession session) {
        NutsDisplayProperty v = NutsDisplayProperty.parseLenient(value, emptyValue, null);
        if (v == null && !NutsBlankable.isBlank((String)value)) {
            throw new NutsParseEnumException(session, value, NutsDisplayProperty.class);
        }
        return v;
    }
}

